"use strict";(self.webpackChunkdeck=self.webpackChunkdeck||[]).push([["src_BoardSelector_vue"],{85890:(t,n,e)=>{e.d(n,{Z:()=>i});var o=e(87537),r=e.n(o),a=e(23645),l=e.n(a)()(r());l.push([t.id,"\n#modal-inner[data-v-4bce508c] {\n\twidth: 90vw;\n\tmax-width: 400px;\n\tpadding: 20px;\n}\nul[data-v-4bce508c] {\n\tmin-height: 100px;\n}\nli[data-v-4bce508c] {\n\tpadding: 6px;\n\tborder: 1px solid transparent;\n}\nli[data-v-4bce508c]:hover, li[data-v-4bce508c]:focus {\n\tbackground-color: var(--color-background-dark);\n}\nli.selected[data-v-4bce508c] {\n\tborder: 1px solid var(--color-primary);\n}\n.board-bullet[data-v-4bce508c] {\n\tdisplay: inline-block;\n\twidth: 12px;\n\theight: 12px;\n\tborder: none;\n\tborder-radius: 50%;\n\tcursor: pointer;\n}\nli > span[data-v-4bce508c],\n.avatar[data-v-4bce508c] {\n\tvertical-align: middle;\n}\n\n","",{version:3,sources:["webpack://./src/BoardSelector.vue"],names:[],mappings:";AA4FA;CACA,WAAA;CACA,gBAAA;CACA,aAAA;AACA;AAEA;CACA,iBAAA;AACA;AAEA;CACA,YAAA;CACA,6BAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;CACA,sCAAA;AACA;AAEA;CACA,qBAAA;CACA,WAAA;CACA,YAAA;CACA,YAAA;CACA,kBAAA;CACA,eAAA;AACA;AAEA;;CAEA,sBAAA;AAEA",sourcesContent:["\x3c!--\n  - @copyright Copyright (c) 2019 Julius Härtl <jus@bitgrid.net>\n  -\n  - @author Julius Härtl <jus@bitgrid.net>\n  -\n  - @license GNU AGPL version 3 or any later version\n  -\n  - This program is free software: you can redistribute it and/or modify\n  - it under the terms of the GNU Affero General Public License as\n  - published by the Free Software Foundation, either version 3 of the\n  - License, or (at your option) any later version.\n  -\n  - This program is distributed in the hope that it will be useful,\n  - but WITHOUT ANY WARRANTY; without even the implied warranty of\n  - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n  - GNU Affero General Public License for more details.\n  -\n  - You should have received a copy of the GNU Affero General Public License\n  - along with this program. If not, see <http://www.gnu.org/licenses/>.\n  -\n  --\x3e\n\n<template>\n\t<NcModal @close=\"close\">\n\t\t<div id=\"modal-inner\" :class=\"{ 'icon-loading': loading }\">\n\t\t\t<h1>{{ t('deck', 'Select the board to link to a project') }}</h1>\n\t\t\t<input v-model=\"filter\" type=\"text\" :placeholder=\"t('deck', 'Search by board title')\">\n\t\t\t<ul v-if=\"!loading\">\n\t\t\t\t<li v-for=\"board in availableBoards\"\n\t\t\t\t\t:key=\"board.id\"\n\t\t\t\t\t:class=\"{'selected': (selectedBoard === board.id) }\"\n\t\t\t\t\t@click=\"selectedBoard=board.id\">\n\t\t\t\t\t<span :style=\"{ 'backgroundColor': '#' + board.color }\" class=\"board-bullet\" />\n\t\t\t\t\t<span>{{ board.title }}</span>\n\t\t\t\t</li>\n\t\t\t</ul>\n\t\t\t<button v-if=\"!loading\" class=\"primary\" @click=\"select\">\n\t\t\t\t{{ t('deck', 'Select board') }}\n\t\t\t</button>\n\t\t</div>\n\t</NcModal>\n</template>\n<script>\nimport { NcModal } from '@nextcloud/vue'\nimport axios from '@nextcloud/axios'\nimport { generateUrl } from '@nextcloud/router'\n\nexport default {\n\tname: 'BoardSelector',\n\tcomponents: {\n\t\tNcModal,\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tfilter: '',\n\t\t\tboards: [],\n\t\t\tselectedBoard: null,\n\t\t\tloading: true,\n\t\t\tcurrentBoard: null,\n\t\t}\n\t},\n\tcomputed: {\n\t\tavailableBoards() {\n\t\t\treturn this.boards.filter((board) => (\n\t\t\t\t'' + board.id !== '' + this.currentBoard\n\t\t\t\t&& board.title.match(this.filter)\n\t\t\t))\n\t\t},\n\t},\n\tbeforeMount() {\n\t\tthis.fetchBoards()\n\t\tconst hash = window.location.hash.match(/\\/boards\\/([0-9]+)/)\n\t\tthis.currentBoard = hash.length > 0 ? hash[1] : null\n\t},\n\tmethods: {\n\t\tfetchBoards() {\n\t\t\taxios.get(generateUrl('/apps/deck/boards')).then((response) => {\n\t\t\t\tthis.boards = response.data\n\t\t\t\tthis.loading = false\n\t\t\t})\n\t\t},\n\t\tclose() {\n\t\t\tthis.$root.$emit('close')\n\t\t},\n\t\tselect() {\n\t\t\tthis.$root.$emit('select', this.selectedBoard)\n\t\t},\n\t},\n\n}\n<\/script>\n<style scoped>\n\t#modal-inner {\n\t\twidth: 90vw;\n\t\tmax-width: 400px;\n\t\tpadding: 20px;\n\t}\n\n\tul {\n\t\tmin-height: 100px;\n\t}\n\n\tli {\n\t\tpadding: 6px;\n\t\tborder: 1px solid transparent;\n\t}\n\n\tli:hover, li:focus {\n\t\tbackground-color: var(--color-background-dark);\n\t}\n\n\tli.selected {\n\t\tborder: 1px solid var(--color-primary);\n\t}\n\n\t.board-bullet {\n\t\tdisplay: inline-block;\n\t\twidth: 12px;\n\t\theight: 12px;\n\t\tborder: none;\n\t\tborder-radius: 50%;\n\t\tcursor: pointer;\n\t}\n\n\tli > span,\n\t.avatar {\n\t\tvertical-align: middle;\n\n\t}\n\n</style>\n"],sourceRoot:""}]);const i=l},18999:(t,n,e)=>{e.r(n),e.d(n,{default:()=>k});var o=e(33476),r=e(26937),a=e(79753);const l={name:"BoardSelector",components:{NcModal:o.NcModal},data:function(){return{filter:"",boards:[],selectedBoard:null,loading:!0,currentBoard:null}},computed:{availableBoards:function(){var t=this;return this.boards.filter((function(n){return""+n.id!=""+t.currentBoard&&n.title.match(t.filter)}))}},beforeMount:function(){this.fetchBoards();var t=window.location.hash.match(/\/boards\/([0-9]+)/);this.currentBoard=t.length>0?t[1]:null},methods:{fetchBoards:function(){var t=this;r.Z.get((0,a.generateUrl)("/apps/deck/boards")).then((function(n){t.boards=n.data,t.loading=!1}))},close:function(){this.$root.$emit("close")},select:function(){this.$root.$emit("select",this.selectedBoard)}}};var i=e(93379),d=e.n(i),s=e(7795),c=e.n(s),A=e(90569),u=e.n(A),h=e(3565),p=e.n(h),b=e(19216),v=e.n(b),f=e(44589),m=e.n(f),g=e(85890),C={};C.styleTagTransform=m(),C.setAttributes=p(),C.insert=u().bind(null,"head"),C.domAPI=c(),C.insertStyleElement=v();d()(g.Z,C);g.Z&&g.Z.locals&&g.Z.locals;const k=(0,e(51900).Z)(l,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("NcModal",{on:{close:t.close}},[e("div",{class:{"icon-loading":t.loading},attrs:{id:"modal-inner"}},[e("h1",[t._v(t._s(t.t("deck","Select the board to link to a project")))]),t._v(" "),e("input",{directives:[{name:"model",rawName:"v-model",value:t.filter,expression:"filter"}],attrs:{type:"text",placeholder:t.t("deck","Search by board title")},domProps:{value:t.filter},on:{input:function(n){n.target.composing||(t.filter=n.target.value)}}}),t._v(" "),t.loading?t._e():e("ul",t._l(t.availableBoards,(function(n){return e("li",{key:n.id,class:{selected:t.selectedBoard===n.id},on:{click:function(e){t.selectedBoard=n.id}}},[e("span",{staticClass:"board-bullet",style:{backgroundColor:"#"+n.color}}),t._v(" "),e("span",[t._v(t._s(n.title))])])})),0),t._v(" "),t.loading?t._e():e("button",{staticClass:"primary",on:{click:t.select}},[t._v("\n\t\t\t"+t._s(t.t("deck","Select board"))+"\n\t\t")])])])}),[],!1,null,"4bce508c",null).exports}}]);
//# sourceMappingURL=deck-src_BoardSelector_vue.js.map?v=dabf8fb5efdbfa462172