# -*- coding: binary -*-

module Msf::Exploit::Remote::SMB::LogAdapter
  # API inherited from ::Rex::Ui::Output, but as it is a class - it can not be included as a mixin
  class Logger < ::Logger
    def initialize(mod, log_device)
      super(log_device)
      @mod = mod
    end

    #
    # Prints an error message.
    #
    def print_error(msg = '')
      @mod.print_error(msg)
    end

    alias print_bad print_error

    #
    # Prints a 'good' message.
    #
    def print_good(msg = '')
      @mod.print_good(msg)
    end

    #
    # Prints a status line.
    #
    def print_status(msg = '')
      @mod.print_status(msg)
    end

    #
    # Prints an undecorated line of information.
    #
    def print_line(msg = '')
      @mod.print_line(msg)
    end

    #
    # Prints a warning
    #
    def print_warning(msg = '')
      @mod.print_warning(msg)
    end

    #
    # Prints a message with no decoration.
    #
    def print(msg = '')
      @mod.print(msg)
    end
  end

  # Log devices to be used with Ruby's default Logging
  module LogDevice
    # Logs using the default framework logging mechanism
    class Framework
      def initialize(_framework)
        # Note that the framework instance is not technically required as {rlog} is global
        # it's just an attempt at future proofing the API
        # @framework = framework
      end

      def write(message)
        rlog(message)
      end

      def close
        # noop
      end
    end

    # Logs using the provided module
    class Module
      def initialize(mod)
        @mod = mod
      end

      def write(message)
        @mod.print(message)
      end

      def close
        # noop
      end
    end
  end
end
