/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.descriptionPanel;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javax.swing.SwingUtilities;
import mediathek.config.Konstanten;
import mediathek.daten.DatenFilm;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.gui.dialog.DialogFilmBeschreibung;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.GuiFunktionen;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DescriptionPanelController {
    private static final Logger logger = LogManager.getLogger(DescriptionPanelController.class);
    private static final String SPACER = "  -  ";
    @FXML
    private Hyperlink websiteLink;
    @FXML
    private TextFlow textField;
    @FXML
    private Tab descriptionTab;
    @FXML
    private ScrollPane scrollPane;
    private DatenFilm currentFilm;
    private ContextMenu contextMenu;

    public static DescriptionPanelController install(JFXPanel fxDescriptionPanel) throws IOException {
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(Konstanten.FXML_FILM_DESCRIPTION_PANEL_URL);
        TabPane descriptionPane = (TabPane)loader.load();
        DescriptionPanelController descriptionPanelController = (DescriptionPanelController)loader.getController();
        descriptionPanelController.setOnCloseRequest(e -> {
            SwingUtilities.invokeLater(() -> fxDescriptionPanel.setVisible(false));
            e.consume();
        });
        fxDescriptionPanel.setScene(new Scene(descriptionPane));
        return descriptionPanelController;
    }

    public static String getStringFromTextFlow(TextFlow tf) {
        StringBuilder sb = new StringBuilder();
        tf.getChildren().stream().filter(t -> Text.class.equals(t.getClass())).forEach(t -> sb.append(((Text)t).getText()));
        return sb.toString();
    }

    private void setupWebsiteLink() {
        this.websiteLink.setOnAction(e -> {
            String link = this.currentFilm.getWebsiteLink();
            SwingUtilities.invokeLater(() -> {
                try {
                    UrlHyperlinkAction.openURL(MediathekGui.ui(), link);
                }
                catch (URISyntaxException ex) {
                    logger.error("Failed to launch web browser for URL: {}", (Object)link);
                }
            });
        });
        ContextMenu contextMenu = new ContextMenu();
        MenuItem mi = new MenuItem("URL kopieren");
        mi.setOnAction(e -> SwingUtilities.invokeLater(() -> GuiFunktionen.copyToClipboard(this.currentFilm.getWebsiteLink())));
        contextMenu.getItems().add(mi);
        this.websiteLink.setContextMenu(contextMenu);
    }

    private Font getFont() {
        Font defaultFont = SystemUtils.IS_OS_MAC_OSX ? Font.font("Arial", 14.0) : Font.getDefault();
        return defaultFont;
    }

    public void showFilmDescription(@NotNull Optional<DatenFilm> optFilm) {
        this.textField.getChildren().clear();
        optFilm.ifPresentOrElse(film -> {
            this.currentFilm = film;
            this.websiteLink.setVisible(true);
            this.websiteLink.setVisited(false);
            this.websiteLink.setTooltip(new Tooltip(film.getWebsiteLink()));
            Font defaultFont = this.getFont();
            Text headLine = new Text((String)(film.getSender().isEmpty() ? "" : film.getSender() + SPACER) + film.getThema() + SPACER + film.getTitle());
            headLine.setFont(Font.font(defaultFont.getName(), FontWeight.BOLD, FontPosture.REGULAR, defaultFont.getSize()));
            Text description = new Text(film.getDescription());
            description.setFont(Font.font(defaultFont.getName(), FontWeight.NORMAL, FontPosture.REGULAR, defaultFont.getSize()));
            this.textField.getChildren().addAll((Node[])new Node[]{headLine, new Text("\n"), new Text("\n"), description});
        }, () -> {
            this.websiteLink.setTooltip(null);
            this.websiteLink.setVisible(false);
            this.currentFilm = null;
        });
    }

    private ContextMenu createContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem edit = new MenuItem("Beschreibung \u00e4ndern");
        edit.setOnAction(e -> SwingUtilities.invokeLater(() -> {
            DialogFilmBeschreibung dialog = new DialogFilmBeschreibung(MediathekGui.ui(), this.currentFilm);
            dialog.setVisible(true);
        }));
        MenuItem copyToClipboard = new MenuItem("In Zwischenablage kopieren");
        copyToClipboard.setOnAction(e -> {
            String text = DescriptionPanelController.getStringFromTextFlow(this.textField);
            GuiFunktionen.copyToClipboard(text);
        });
        ObservableList<MenuItem> items = contextMenu.getItems();
        items.add(edit);
        items.add(new SeparatorMenuItem());
        items.add(copyToClipboard);
        contextMenu.setOnShowing(e -> {
            if (this.currentFilm == null) {
                edit.setDisable(true);
                copyToClipboard.setDisable(true);
            } else {
                edit.setDisable(false);
                copyToClipboard.setDisable(false);
            }
        });
        return contextMenu;
    }

    public void setOnCloseRequest(EventHandler<Event> e) {
        this.descriptionTab.setOnCloseRequest(e);
    }

    public void initialize() {
        this.websiteLink.setVisible(false);
        this.setupWebsiteLink();
        this.contextMenu = this.createContextMenu();
        this.scrollPane.setOnContextMenuRequested(event -> this.contextMenu.show(this.textField, event.getScreenX(), event.getScreenY()));
    }
}

