/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolboxfx.geom;

import eu.hansolo.toolboxfx.HelperFX;
import java.util.List;

public class Point
implements Comparable<Point> {
    public double x;
    public double y;
    private boolean empty;

    public Point() {
        this(0.0, 0.0);
    }

    public Point(Point point) {
        this(point.getX(), point.getY());
    }

    public Point(double x, double y) {
        this(x, y, false);
    }

    public Point(double x, double y, boolean empty) {
        this.x = x;
        this.y = y;
        this.empty = empty;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public int getXAsInt() {
        return (int)this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public int getYAsInt() {
        return (int)this.y;
    }

    public void set(double[] xy) {
        if (xy.length != 2) {
            throw new IllegalArgumentException("Array must contain 2 values");
        }
        this.set(xy[0], xy[1]);
    }

    public void set(Point point) {
        this.set(point.x, point.y);
    }

    public void set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean isEmpty) {
        this.empty = isEmpty;
    }

    public void translateBy(double dx, double dy) {
        this.x += dx;
        this.y += dy;
    }

    public void scaleBy(double sx, double sy) {
        this.x *= sx;
        this.y *= sy;
    }

    public double euclideanDistanceTo(Point p) {
        return HelperFX.euclideanDistance(p.getX(), p.getY(), this.x, this.y);
    }

    public double euclideanDistanceTo(double x, double y) {
        return HelperFX.euclideanDistance(x, y, this.x, this.y);
    }

    public double distanceTo(Point p) {
        return HelperFX.distance(p.getX(), p.getY(), this.x, this.y);
    }

    public double distanceTo(double x, double y) {
        return HelperFX.distance(x, y, this.x, this.y);
    }

    public double distanceSquareTo(Point p) {
        return HelperFX.squareDistance(p.getX(), p.getY(), this.x, this.y);
    }

    public Point fromPolar(double length, double angleRad) {
        return new Point(length * Math.cos(angleRad), length * Math.sin(angleRad));
    }

    public Point add(Point point) {
        return this.add(point.getX(), point.getY());
    }

    public Point add(double x, double y) {
        return new Point(this.getX() + x, this.getY() + y);
    }

    public Point subtract(Point point) {
        return this.subtract(point.getX(), point.getY());
    }

    public Point subtract(double x, double y) {
        return new Point(this.getX() - x, this.getY() - y);
    }

    public Point multiply(double factor) {
        return new Point(this.getX() * factor, this.getY() * factor);
    }

    public Point normalize() {
        double mag = this.magnitude();
        if (mag == 0.0) {
            return new Point(0.0, 0.0);
        }
        return new Point(this.getX() / mag, this.getY() / mag);
    }

    public Point midpoint(Point point) {
        return this.midpoint(point.getX(), point.getY());
    }

    public Point midpoint(double x, double y) {
        return new Point(x + (this.getX() - x) / 2.0, y + (this.getY() - y) / 2.0);
    }

    public double angle(Point point) {
        return this.angle(point.getX(), point.getY());
    }

    public double angle(double x, double y) {
        double ax = this.x;
        double ay = this.y;
        double delta = (ax * x + ay * y) / Math.sqrt((ax * ax + ay * ay) * (x * x + y * y));
        if (delta > 1.0) {
            return 0.0;
        }
        if (delta < -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(delta));
    }

    public double angle(Point p1, Point p2) {
        double by;
        double ax = p1.getX() - this.x;
        double ay = p1.getY() - this.y;
        double bx = p2.getX() - this.x;
        double delta = (ax * bx + ay * (by = p2.getY() - this.y)) / Math.sqrt((ax * ax + ay * ay) * (bx * bx + by * by));
        if (delta > 1.0) {
            return 0.0;
        }
        if (delta < -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(delta));
    }

    public double angleBetween(Point p) {
        return this.angleBetween(p.getX(), p.getY());
    }

    public double angleBetween(double x, double y) {
        double y0 = this.x * y - this.y * x;
        double x0 = this.x * x - this.y * y;
        return Math.atan2(y0, x0);
    }

    public boolean isColinearTo(Point point) {
        return this.crossProductLength(point) == 0.0;
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public double dotProductLength(Point point) {
        return this.dotProductLength(point.getX(), point.getY());
    }

    public double dotProductLength(double x, double y) {
        return this.x * x + this.y * y;
    }

    public double crossProductLength(Point point) {
        return this.crossProductLength(point.getX(), point.getY());
    }

    public double crossProductLength(double x, double y) {
        return this.x * y - x * this.y;
    }

    public static Point nearestWithinRadius(Point point, List<Point> points, double radius) {
        double radiusSquare = radius * radius;
        Point p = points.get(0);
        for (int i = 0; i < points.size(); ++i) {
            double distanceSquare = points.get(i).euclideanDistanceTo(point);
            if (!(distanceSquare < radiusSquare) || !(distanceSquare < p.euclideanDistanceTo(point))) continue;
            p = points.get(i);
        }
        return p;
    }

    public static Point nearest(Point point, List<Point> points) {
        Point p = points.get(0);
        for (int i = 0; i < points.size(); ++i) {
            if (!(points.get(i).euclideanDistanceTo(point) < p.euclideanDistanceTo(point))) continue;
            p = points.get(i);
        }
        return p;
    }

    public static double dotProductLength(Point p1, Point p2) {
        return p1.getX() * p2.getX() + p1.getY() * p2.getY();
    }

    public static double crossProductLength(Point p1, Point p2) {
        return p1.getX() * p2.getY() - p2.getX() * p1.getY();
    }

    public Point clone() {
        return new Point(this.x, this.y);
    }

    @Override
    public int compareTo(Point point) {
        return this.x != point.getX() ? Double.compare(this.x, point.x) : Double.compare(this.y, point.y);
    }

    public int hashCode() {
        int tmp = (int)(this.y + (this.x + 1.0) / 2.0);
        return Math.abs((int)(this.x + (double)(tmp * tmp)));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Point) {
            Point p = (Point)obj;
            return Math.abs(this.x - p.getX()) < 1.0E-6 && Math.abs(this.y - p.getY()) < 1.0E-6;
        }
        return false;
    }

    public String toString() {
        return "{" + "\"" + "x" + "\"" + ":" + this.x + "," + "\"" + "y" + "\"" + ":" + this.y + "}";
    }
}

