/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox;

import java.util.Collections;
import java.util.List;

public class Statistics {
    public static final double getMean(List<Double> data) {
        return data.stream().mapToDouble(v -> v).sum() / (double)data.size();
    }

    public static final double getVariance(List<Double> data) {
        double mean = Statistics.getMean(data);
        double temp = 0.0;
        for (double a : data) {
            temp += (a - mean) * (a - mean);
        }
        return temp / (double)data.size();
    }

    public static final double getStdDev(List<Double> data) {
        return Math.sqrt(Statistics.getVariance(data));
    }

    public static final double getMedian(List<Double> data) {
        int size = data.size();
        Collections.sort(data);
        return size % 2 == 0 ? (data.get(size / 2 - 1) + data.get(size / 2)) / 2.0 : data.get(size / 2);
    }

    public static final double getMin(List<Double> data) {
        return data.stream().mapToDouble(v -> v).min().orElse(0.0);
    }

    public static final double getMax(List<Double> data) {
        return data.stream().mapToDouble(v -> v).max().orElse(0.0);
    }

    public static final double getAverage(List<Double> DATA) {
        return DATA.stream().mapToDouble(data -> data).average().orElse(-1.0);
    }

    public static final double percentile(List<Double> entries, double percentile) {
        Collections.sort(entries);
        int index = (int)Math.ceil(percentile / 100.0 * (double)entries.size());
        return entries.get(index - 1);
    }
}

