/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.fx.countries.Country;
import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.LocationEvt;
import eu.hansolo.tilesfx.events.TileEvt;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.CountryPath;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolboxfx.evt.type.LocationChangeEvt;
import eu.hansolo.toolboxfx.geom.Location;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class WorldMapTileSkin
extends TileSkin {
    protected static final double PREFERRED_WIDTH = 500.0;
    protected static final double PREFERRED_HEIGHT = 250.0;
    private static final double MAP_ASPECT_RATIO = 0.659987853233805;
    private Text titleText;
    private Text text;
    private Pane worldPane;
    private Group group;
    private Map<String, List<CountryPath>> countryPaths;
    private ObservableMap<Location, Circle> chartDataLocations;
    private ObservableMap<Location, Circle> poiLocations;
    private Map<CountryPath, EventHandler<MouseEvent>> handlerMap;
    private ListChangeListener<Location> poiListener;
    private ListChangeListener<ChartData> chartDataListener;
    private Map<Circle, EventHandler<MouseEvent>> circleHandlerMap;

    public WorldMapTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.poiLocations = FXCollections.observableHashMap();
        this.chartDataLocations = FXCollections.observableHashMap();
        this.handlerMap = new HashMap<CountryPath, EventHandler<MouseEvent>>();
        this.circleHandlerMap = new HashMap<Circle, EventHandler<MouseEvent>>();
        this.countryPaths = this.tile.getLoresCountryPaths();
        String formatString = "%." + this.tile.getDecimals() + "f";
        this.poiListener = change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(addedPoi -> {
                        String tooltipText = addedPoi.getName() + "\n" + addedPoi.getInfo();
                        EventHandler<MouseEvent> handler = e -> addedPoi.fireLocationEvent(new LocationEvt((EvtType<? extends LocationChangeEvt>)LocationChangeEvt.LOCATION_CHANGED, (Location)addedPoi, (Location)addedPoi, this.tile));
                        Circle circle = new Circle(3.0, addedPoi.getFill());
                        Tooltip.install(circle, new Tooltip(tooltipText));
                        this.circleHandlerMap.put(circle, handler);
                        this.poiLocations.put((Location)addedPoi, circle);
                        circle.setOnMousePressed(handler);
                        this.getPane().getChildren().add(circle);
                    });
                    continue;
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(removedPoi -> {
                    if (this.circleHandlerMap.get(removedPoi) != null) {
                        ((Circle)this.poiLocations.get(removedPoi)).removeEventHandler(MouseEvent.MOUSE_PRESSED, this.circleHandlerMap.get(removedPoi));
                    }
                    this.getPane().getChildren().remove(removedPoi);
                });
            }
            this.resize();
        };
        this.chartDataListener = change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(addedData -> {
                        String tooltipText = addedData.getName() + "\n" + String.format(Locale.US, formatString, addedData.getValue());
                        EventHandler<MouseEvent> handler = e -> this.tile.fireTileEvt(new TileEvt((Object)this.tile, (EvtType<? extends TileEvt>)TileEvt.SELECTED_CHART_DATA, (ChartData)addedData));
                        Circle circle = new Circle(3.0, addedData.getLocation().getFill());
                        Tooltip.install(circle, new Tooltip(tooltipText));
                        this.circleHandlerMap.put(circle, handler);
                        this.chartDataLocations.put(addedData.getLocation(), circle);
                        circle.setOnMousePressed(handler);
                        circle.setVisible(this.tile.getDataPointsVisible());
                        this.getPane().getChildren().add(circle);
                    });
                    continue;
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(removedData -> {
                    if (this.circleHandlerMap.get(removedData) != null) {
                        ((Circle)this.chartDataLocations.get(removedData)).removeEventHandler(MouseEvent.MOUSE_PRESSED, this.circleHandlerMap.get(removedData));
                    }
                    this.getPane().getChildren().remove(removedData);
                });
            }
            this.resize();
        };
        this.tile.getPoiList().forEach(poi -> {
            String tooltipText = poi.getName() + "\n" + poi.getInfo();
            Circle circle = new Circle(3.0, poi.getFill());
            circle.setOnMousePressed(e -> poi.fireLocationEvent(new LocationEvt(LocationEvt.LOCATION_CHANGED, (Location)poi, (Location)poi, this.tile)));
            Tooltip.install(circle, new Tooltip(tooltipText));
            this.poiLocations.put((Location)poi, circle);
        });
        this.tile.getChartData().stream().filter(chartData -> chartData.getLocation() != null).forEach(chartData -> {
            String tooltipText = chartData.getName() + "\n" + String.format(Locale.US, formatString, chartData.getValue());
            Circle circle = new Circle(3.0, null == chartData.getLocation().getFill() ? Color.TRANSPARENT : chartData.getLocation().getFill());
            circle.setOnMousePressed(e -> this.tile.fireTileEvt(new TileEvt((Object)this.tile, (EvtType<? extends TileEvt>)TileEvt.SELECTED_CHART_DATA, (ChartData)chartData)));
            Tooltip.install(circle, new Tooltip(tooltipText));
            this.chartDataLocations.put(chartData.getLocation(), circle);
        });
        this.titleText = new Text();
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getUnit());
        this.text.setFill(this.tile.getUnitColor());
        Helper.enableNode(this.text, this.tile.isTextVisible());
        Color fill = this.tile.getForegroundColor();
        Color stroke = this.tile.getBackgroundColor();
        this.worldPane = new Pane();
        this.countryPaths.forEach((name, pathList) -> {
            Country country = Country.valueOf(name);
            pathList.forEach(path -> {
                path.setFill(null == country.getFill() ? fill : country.getFill());
                path.setStroke(null == country.getStroke() ? stroke : country.getStroke());
                path.setStrokeWidth(0.2);
            });
            this.worldPane.getChildren().addAll((Collection<Node>)pathList);
        });
        this.group = new Group(this.worldPane);
        this.getPane().getChildren().addAll((Node[])new Node[]{this.group, this.titleText, this.text});
        this.getPane().getChildren().addAll(this.chartDataLocations.values());
        this.getPane().getChildren().addAll(this.poiLocations.values());
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.countryPaths.forEach((name, pathList) -> {
            Country country = Country.valueOf(name);
            EventHandler<MouseEvent> clickHandler = e -> this.tile.fireTileEvt(new TileEvt((Object)this.tile, TileEvt.SELECTED_CHART_DATA, new ChartData(country.getName(), country.getValue(), country.getFill())));
            pathList.forEach(path -> {
                this.handlerMap.put((CountryPath)path, clickHandler);
                path.addEventHandler(MouseEvent.MOUSE_PRESSED, clickHandler);
            });
        });
        this.tile.getPoiList().addListener(this.poiListener);
        this.tile.getChartData().addListener(this.chartDataListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.text, this.tile.isTextVisible());
            this.chartDataLocations.values().forEach(circle -> circle.setVisible(this.tile.getDataPointsVisible()));
        } else if ("REFRESH".equals(EVENT_TYPE)) {
            this.refresh();
        }
    }

    @Override
    public void dispose() {
        this.countryPaths.forEach((name, pathList) -> pathList.forEach(path -> path.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.handlerMap.get(path))));
        this.tile.getPoiList().removeListener(this.poiListener);
        this.tile.getChartData().removeListener(this.chartDataListener);
        this.handlerMap.clear();
        this.circleHandlerMap.clear();
        super.dispose();
    }

    private void setFillAndStroke() {
        this.countryPaths.keySet().forEach(name -> {
            Country country;
            this.setCountryFillAndStroke(country, null == (country = Country.valueOf(name)).getFill() ? this.tile.getForegroundColor() : country.getFill(), null == country.getStroke() ? this.tile.getBackgroundColor() : country.getStroke());
        });
    }

    private void setCountryFillAndStroke(Country COUNTRY, Color FILL, Color STROKE) {
        List<CountryPath> paths = this.countryPaths.get(COUNTRY.getName());
        for (CountryPath path : paths) {
            path.setFill(FILL);
            path.setStroke(STROKE);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.width = this.tile.getWidth() - this.tile.getInsets().getLeft() - this.tile.getInsets().getRight();
        this.height = this.tile.getHeight() - this.tile.getInsets().getTop() - this.tile.getInsets().getBottom();
        this.size = this.width < this.height ? this.width : this.height;
        double containerWidth = this.contentBounds.getWidth();
        double containerHeight = this.contentBounds.getHeight();
        if (this.tile.isShowing() && this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.resizeStaticText();
            this.resizeDynamicText();
            double worldMapHeight = Helper.clamp(0.0, containerWidth * 0.659987853233805, containerHeight);
            double worldMapWidth = Helper.clamp(0.0, containerWidth, containerHeight / 0.659987853233805);
            this.worldPane.setCache(true);
            this.worldPane.setCacheHint(CacheHint.SCALE);
            this.worldPane.setScaleX(worldMapWidth / 1007.9609816074371 * (Tile.TextSize.NORMAL == this.textSize ? 1.0 : 0.95));
            this.worldPane.setScaleY(worldMapHeight / (double)665.242f * (Tile.TextSize.NORMAL == this.textSize ? 1.0 : 0.95));
            this.group.resize(worldMapWidth, worldMapHeight);
            this.group.relocate((this.width - worldMapWidth) * 0.5, this.contentBounds.getY() + (this.contentBounds.getHeight() - worldMapHeight) * 0.5);
            this.worldPane.setCache(false);
            this.poiLocations.forEach((location, circle) -> {
                double[] xy = Helper.latLonToXY(location.getLatitude(), location.getLongitude());
                double x = xy[0] * this.worldPane.getScaleX() + this.group.getBoundsInParent().getMinX();
                double y = xy[1] * this.worldPane.getScaleY() + this.group.getBoundsInParent().getMinY();
                circle.setCenterX(x);
                circle.setCenterY(y);
                circle.setRadius(this.size * 0.0075);
            });
            this.chartDataLocations.forEach((location, circle) -> {
                double[] xy = Helper.latLonToXY(location.getLatitude(), location.getLongitude());
                double x = xy[0] * this.worldPane.getScaleX() + this.group.getBoundsInParent().getMinX();
                double y = xy[1] * this.worldPane.getScaleY() + this.group.getBoundsInParent().getMinY();
                circle.setCenterX(x);
                circle.setCenterY(y);
                circle.setRadius(this.size * 0.0075);
            });
        }
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.resizeStaticText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.text.setFill(this.tile.getTextColor());
    }

    private void refresh() {
        Color fill = this.tile.getForegroundColor();
        Color stroke = this.tile.getBackgroundColor();
        this.countryPaths.forEach((name, pathList) -> {
            Country country = Country.valueOf(name);
            pathList.forEach(path -> {
                path.setFill(null == country.getFill() ? fill : country.getFill());
                path.setStroke(null == country.getStroke() ? stroke : country.getStroke());
                path.setStrokeWidth(0.2);
            });
        });
    }
}

