/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.tilesfx.events.TileEvt;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.Comparator;
import java.util.Locale;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class RadialChartTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private Canvas chartCanvas;
    private GraphicsContext chartCtx;
    private ListChangeListener<ChartData> chartDataListener;
    private ChartDataEventListener chartEventListener;
    private EventHandler<MouseEvent> clickHandler;

    public RadialChartTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.chartEventListener = e -> this.drawChart();
        this.tile.getChartData().forEach(chartData -> chartData.addChartDataEventListener(this.chartEventListener));
        this.chartDataListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(addedItem -> addedItem.addChartDataEventListener(this.chartEventListener));
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(removedItem -> removedItem.removeChartDataEventListener(this.chartEventListener));
            }
            this.drawChart();
        };
        this.clickHandler = e -> {
            double x = e.getX();
            double y = e.getY();
            double startAngle = 90.0;
            ObservableList<ChartData> dataList = this.tile.getChartData();
            int noOfItems = dataList.size();
            double canvasSize = this.chartCanvas.getWidth();
            double radius = canvasSize * 0.5;
            double innerSpacer = radius * 0.18;
            double barWidth = (radius - innerSpacer) / (double)this.tile.getChartData().size();
            double max = noOfItems == 0 ? 0.0 : dataList.stream().max(Comparator.comparingDouble(ChartData::getValue)).get().getValue();
            for (int i = 0; i < noOfItems; ++i) {
                double centerX;
                double barXY = barWidth * 0.5 + (double)i * barWidth;
                double barWH = canvasSize - barWidth - (double)(2 * i) * barWidth;
                double centerY = centerX = barXY + barWH * 0.5;
                ChartData data = (ChartData)dataList.get(i);
                double value = Helper.clamp(0.0, Double.MAX_VALUE, data.getValue());
                double angle = value / max * 270.0;
                boolean hit = Helper.isInRingSegment(x, y, centerX, centerY, (barWH + barWidth) * 0.5, (barWH - barWidth) * 0.5, startAngle, angle);
                if (!hit) continue;
                this.tile.fireTileEvt(new TileEvt((Object)this.tile, TileEvt.SELECTED_CHART_DATA, data));
                break;
            }
        };
        this.titleText = new Text();
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill(this.tile.getTextColor());
        Helper.enableNode(this.text, this.tile.isTextVisible());
        this.chartCanvas = new Canvas(this.size * 0.9, this.tile.isTextVisible() ? this.size * 0.72 : this.size * 0.795);
        this.chartCtx = this.chartCanvas.getGraphicsContext2D();
        this.getPane().getChildren().addAll((Node[])new Node[]{this.titleText, this.chartCanvas, this.text});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.getChartData().addListener(this.chartDataListener);
        this.chartCanvas.addEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.text, this.tile.isTextVisible());
            this.chartCanvas.setWidth(this.tile.isTextVisible() ? this.size * 0.68 : this.size * 0.795);
            this.chartCanvas.setHeight(this.tile.isTextVisible() ? this.size * 0.68 : this.size * 0.795);
        }
    }

    @Override
    public void dispose() {
        this.tile.getChartData().removeListener(this.chartDataListener);
        this.tile.getChartData().forEach(chartData -> chartData.removeChartDataEventListener(this.chartEventListener));
        this.chartCanvas.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.clickHandler);
        super.dispose();
    }

    private void drawChart() {
        double canvasSize = this.chartCanvas.getWidth();
        double radius = canvasSize * 0.5;
        double innerSpacer = radius * 0.18;
        double barWidth = (radius - innerSpacer) / (double)this.tile.getChartData().size();
        ObservableList<ChartData> dataList = this.tile.getChartData();
        int noOfItems = dataList.size();
        double max = noOfItems == 0 ? 0.0 : dataList.stream().max(Comparator.comparingDouble(ChartData::getValue)).get().getValue();
        double nameX = radius * 0.975;
        double nameWidth = radius * 0.95;
        double valueY = radius * 0.94;
        double valueWidth = barWidth * 0.9;
        Color bkgColor = Color.color(this.tile.getTextColor().getRed(), this.tile.getTextColor().getGreen(), this.tile.getTextColor().getBlue(), 0.15);
        this.chartCtx.clearRect(0.0, 0.0, canvasSize, canvasSize);
        this.chartCtx.setLineCap(StrokeLineCap.BUTT);
        this.chartCtx.setFill(this.tile.getTextColor());
        this.chartCtx.setTextAlign(TextAlignment.RIGHT);
        this.chartCtx.setTextBaseline(VPos.CENTER);
        this.chartCtx.setFont(Fonts.latoRegular(barWidth * 0.5));
        this.chartCtx.setStroke(bkgColor);
        this.chartCtx.setLineWidth(1.0);
        this.chartCtx.strokeLine(radius, 0.0, radius, radius - barWidth * 0.875);
        this.chartCtx.strokeLine(0.0, radius, radius - barWidth * 0.875, radius);
        this.chartCtx.strokeArc((double)noOfItems * barWidth, (double)noOfItems * barWidth, canvasSize - (double)(2 * noOfItems) * barWidth, canvasSize - (double)(2 * noOfItems) * barWidth, 90.0, -270.0, ArcType.OPEN);
        for (int i = 0; i < noOfItems; ++i) {
            ChartData data = (ChartData)dataList.get(i);
            double value = Helper.clamp(0.0, Double.MAX_VALUE, data.getValue());
            double bkgXY = (double)i * barWidth;
            double bkgWH = canvasSize - (double)(2 * i) * barWidth;
            double barXY = barWidth * 0.5 + (double)i * barWidth;
            double barWH = canvasSize - barWidth - (double)(2 * i) * barWidth;
            double angle = value / max * 270.0;
            this.chartCtx.setLineWidth(1.0);
            this.chartCtx.setStroke(bkgColor);
            this.chartCtx.strokeArc(bkgXY, bkgXY, bkgWH, bkgWH, 90.0, -270.0, ArcType.OPEN);
            this.chartCtx.setLineWidth(barWidth);
            this.chartCtx.setStroke(data.getFillColor());
            this.chartCtx.strokeArc(barXY, barXY, barWH, barWH, 90.0, -angle, ArcType.OPEN);
            this.chartCtx.setTextAlign(TextAlignment.RIGHT);
            this.chartCtx.fillText(data.getName(), nameX, barXY, nameWidth);
            this.chartCtx.setTextAlign(TextAlignment.CENTER);
            if (this.tile.getShortenNumbers()) {
                this.chartCtx.fillText(Helper.shortenNumber((long)value), barXY, valueY, valueWidth);
                continue;
            }
            this.chartCtx.fillText(String.format(Locale.US, "%.0f", value), barXY, valueY, valueWidth);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        double canvasSize;
        super.resize();
        this.width = this.tile.getWidth() - this.tile.getInsets().getLeft() - this.tile.getInsets().getRight();
        this.height = this.tile.getHeight() - this.tile.getInsets().getTop() - this.tile.getInsets().getBottom();
        this.size = this.width < this.height ? this.width : this.height;
        double canvasWidth = this.contentBounds.getWidth();
        double canvasHeight = this.contentBounds.getHeight();
        double d = canvasSize = canvasWidth < canvasHeight ? canvasWidth : canvasHeight;
        if (this.tile.isShowing() && this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.chartCanvas.setWidth(canvasSize);
            this.chartCanvas.setHeight(canvasSize);
            this.chartCanvas.relocate((this.contentBounds.getWidth() - canvasSize) * 0.5, this.contentBounds.getY() + (this.contentBounds.getHeight() - canvasSize) * 0.5);
            this.resizeStaticText();
        }
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.resizeStaticText();
        this.drawChart();
        this.titleText.setFill(this.tile.getTitleColor());
        this.text.setFill(this.tile.getTextColor());
    }
}

