/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.PixelMatrix;
import eu.hansolo.tilesfx.chart.PixelMatrixBuilder;
import eu.hansolo.tilesfx.events.TileEvt;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.MatrixIcon;
import javafx.animation.AnimationTimer;
import javafx.scene.Node;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class MatrixIconTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private PixelMatrix matrix;
    private int iconCounter;
    private long updateInterval;
    private long pauseInterval;
    private AnimationTimer timer;
    private AnimationTimer pauseTimer;
    private long lastTimerCall;

    public MatrixIconTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.iconCounter = 0;
        this.matrix = ((PixelMatrixBuilder)((PixelMatrixBuilder)((PixelMatrixBuilder)((PixelMatrixBuilder)((PixelMatrixBuilder)((PixelMatrixBuilder)((PixelMatrixBuilder)PixelMatrixBuilder.create().pixelShape(PixelMatrix.PixelShape.SQUARE)).useSpacer(true)).squarePixels(true)).colsAndRows(8, 8)).pixelOnColor(this.tile.getBarColor())).pixelOffColor(MatrixIcon.BACKGROUND)).innerShadowEnabled(true)).build();
        this.titleText = new Text();
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill(this.tile.getTextColor());
        Helper.enableNode(this.text, this.tile.isTextVisible());
        this.updateInterval = this.tile.getAnimationDuration() * 1000000L;
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            @Override
            public void handle(long now) {
                if (now > MatrixIconTileSkin.this.lastTimerCall + MatrixIconTileSkin.this.updateInterval) {
                    MatrixIconTileSkin.this.updateMatrix();
                    MatrixIconTileSkin.this.lastTimerCall = now;
                }
            }
        };
        this.pauseInterval = this.tile.getPauseDuration() * 1000000L;
        this.pauseTimer = new AnimationTimer(){

            @Override
            public void handle(long now) {
                if (now > MatrixIconTileSkin.this.lastTimerCall + MatrixIconTileSkin.this.pauseInterval) {
                    MatrixIconTileSkin.this.pauseTimer.stop();
                    if (MatrixIconTileSkin.this.tile.isAnimated()) {
                        MatrixIconTileSkin.this.timer.start();
                    }
                }
            }
        };
        this.getPane().getChildren().addAll((Node[])new Node[]{this.titleText, this.matrix, this.text});
        if (this.tile.isAnimated() && this.tile.getMatrixIcons().size() > 1) {
            this.timer.start();
        }
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (TileEvt.VISIBILITY.getName().equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.text, this.tile.isTextVisible());
        } else if (TileEvt.RECALC.getName().equals(EVENT_TYPE)) {
            this.matrix.setColsAndRows(this.tile.getMatrixSize());
            this.resize();
        } else if (TileEvt.ANIMATED_ON.getName().equals(EVENT_TYPE)) {
            this.updateInterval = this.tile.getAnimationDuration() * 1000000L;
            this.pauseInterval = this.tile.getPauseDuration() * 1000000L;
            if (this.tile.getMatrixIcons().size() > 1) {
                this.timer.start();
            }
        } else if (TileEvt.ANIMATED_OFF.getName().equals(EVENT_TYPE)) {
            this.timer.stop();
            this.updateMatrix();
        }
    }

    @Override
    public void dispose() {
        this.matrix.dispose();
        super.dispose();
    }

    private void updateMatrix() {
        this.matrix.setAllPixelsOff();
        if (!this.tile.getMatrixIcons().isEmpty()) {
            MatrixIcon matrixIcon = this.tile.getMatrixIcons().get(this.iconCounter);
            for (int y = 0; y < 8; ++y) {
                for (int x = 0; x < 8; ++x) {
                    this.matrix.setPixel(x, y, matrixIcon.getMatrix()[x][y].getColor());
                }
            }
            ++this.iconCounter;
            if (this.iconCounter > this.tile.getMatrixIcons().size() - 1) {
                this.iconCounter = 0;
                this.timer.stop();
                this.pauseTimer.start();
            }
        }
        this.matrix.drawMatrix();
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.width = this.tile.getWidth() - this.tile.getInsets().getLeft() - this.tile.getInsets().getRight();
        this.height = this.tile.getHeight() - this.tile.getInsets().getTop() - this.tile.getInsets().getBottom();
        this.size = this.width < this.height ? this.width : this.height;
        double chartWidth = this.contentBounds.getWidth();
        double chartHeight = this.contentBounds.getHeight();
        if (this.tile.isShowing() && this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.matrix.setPrefSize(chartWidth, chartHeight);
            this.matrix.relocate((this.width - chartWidth) * 0.5, this.contentBounds.getY() + (this.contentBounds.getHeight() - chartHeight) * 0.5);
            this.resizeStaticText();
        }
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.resizeStaticText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.text.setFill(this.tile.getTextColor());
        this.matrix.setPixelOnColor(this.tile.getBarColor());
        this.matrix.setPixelOffColor(Helper.isDark(this.tile.getBackgroundColor()) ? this.tile.getBackgroundColor().brighter() : this.tile.getBackgroundColor().darker());
        this.updateMatrix();
    }
}

