/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.ChartDataEvent;
import eu.hansolo.tilesfx.events.ChartDataEventListener;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.toolboxfx.FontMetrix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class CycleStepTileSkin
extends TileSkin {
    private Text titleText;
    private Text text;
    private List<ChartItem> chartItems;
    private VBox chartBox;
    private ListChangeListener<ChartData> chartDataListener;

    public CycleStepTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.chartDataListener = change -> {
            this.chartBox.getChildren().clear();
            double sum = this.tile.getChartData().stream().mapToDouble(chartData -> chartData.getValue()).sum();
            this.tile.getChartData().forEach(chartData -> this.chartBox.getChildren().add(new ChartItem((ChartData)chartData, sum)));
            this.updateChart();
        };
        this.chartItems = new ArrayList<ChartItem>();
        double sum = this.tile.getChartData().stream().mapToDouble(chartData -> chartData.getValue()).sum();
        this.tile.getChartData().forEach(chartData -> this.chartItems.add(new ChartItem((ChartData)chartData, sum)));
        this.chartBox = new VBox(0.0);
        this.chartBox.setFillWidth(true);
        this.chartBox.getChildren().addAll((Collection<Node>)this.chartItems);
        this.titleText = new Text();
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill(this.tile.getUnitColor());
        Helper.enableNode(this.text, this.tile.isTextVisible());
        this.getPane().getChildren().addAll((Node[])new Node[]{this.titleText, this.text, this.chartBox});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.getChartData().addListener(this.chartDataListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.text, this.tile.isTextVisible());
        } else if ("DATA".equals(EVENT_TYPE)) {
            this.updateChart();
        }
    }

    @Override
    public void dispose() {
        this.tile.getChartData().removeListener(this.chartDataListener);
        super.dispose();
    }

    private void updateChart() {
        Platform.runLater(() -> {
            double sum = this.tile.getChartData().stream().mapToDouble(chartData -> chartData.getValue()).sum();
            double lastFactor = 0.0;
            for (int i = 0; i < this.chartBox.getChildren().size(); ++i) {
                ChartItem item = (ChartItem)this.chartBox.getChildren().get(i);
                item.update(sum, lastFactor);
                lastFactor += item.getChartData().getValue() / sum;
            }
        });
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.chartBox.relocate(this.contentBounds.getMinX(), this.contentBounds.getMinY());
        this.chartBox.setPrefSize(this.contentBounds.getWidth(), this.contentBounds.getHeight());
        this.updateChart();
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.tile.getBarChartItems().forEach(item -> {
            item.setNameColor(this.tile.getTextColor());
            item.setValueColor(this.tile.getValueColor());
        });
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.text.setFill(this.tile.getTextColor());
    }

    public class ChartItem
    extends Region
    implements ChartDataEventListener {
        private static final double PREFERRED_WIDTH = 250.0;
        private static final double PREFERRED_HEIGHT = 250.0;
        private static final double MINIMUM_WIDTH = 10.0;
        private static final double MINIMUM_HEIGHT = 10.0;
        private static final double MAXIMUM_WIDTH = 1024.0;
        private static final double MAXIMUM_HEIGHT = 1024.0;
        private double size;
        private double width;
        private double height;
        private Canvas canvas;
        private GraphicsContext ctx;
        private ChartData chartData;
        private double sum;
        private double factorX;

        public ChartItem(ChartData chartData, double sum) {
            this.chartData = chartData;
            this.sum = sum;
            this.factorX = 0.0;
            this.initGraphics();
            this.registerListeners();
        }

        private void initGraphics() {
            if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
                if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                    this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
                } else {
                    this.setPrefSize(250.0, 250.0);
                }
            }
            this.canvas = new Canvas();
            this.ctx = this.canvas.getGraphicsContext2D();
            this.getChildren().setAll((Node[])new Node[]{this.canvas});
        }

        private void registerListeners() {
            this.widthProperty().addListener(o -> this.resize());
            this.heightProperty().addListener(o -> this.resize());
            this.chartData.addChartDataEventListener(this);
        }

        @Override
        protected double computeMinWidth(double HEIGHT) {
            return 10.0;
        }

        @Override
        protected double computeMinHeight(double WIDTH) {
            return 10.0;
        }

        @Override
        protected double computePrefWidth(double HEIGHT) {
            return super.computePrefWidth(HEIGHT);
        }

        @Override
        protected double computePrefHeight(double WIDTH) {
            return super.computePrefHeight(WIDTH);
        }

        @Override
        protected double computeMaxWidth(double HEIGHT) {
            return 1024.0;
        }

        @Override
        protected double computeMaxHeight(double WIDTH) {
            return 1024.0;
        }

        public ChartData getChartData() {
            return this.chartData;
        }

        public void update(double sum, double factorX) {
            this.sum = sum;
            this.factorX = factorX;
            this.redraw();
        }

        private void resize() {
            this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
            this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
            double d = this.size = this.width < this.height ? this.width : this.height;
            if (this.width > 0.0 && this.height > 0.0) {
                this.canvas.setWidth(this.width);
                this.canvas.setHeight(this.height);
                this.canvas.relocate((this.getWidth() - this.width) * 0.5, (this.getHeight() - this.height) * 0.5);
                this.redraw();
            }
        }

        private void redraw() {
            double value = this.chartData.getValue();
            String formatString = "%." + CycleStepTileSkin.this.tile.getDecimals() + "f";
            double maxTextWidth = this.width * 0.4;
            double barStartX = maxTextWidth + 5.0;
            double barStartY = this.height * 0.2;
            double maxBarWidth = this.width - barStartX;
            double barWidth = value / this.sum * maxBarWidth;
            double barHeight = this.height * 0.6;
            Color barBackgroundColor = Helper.getColorWithOpacity(CycleStepTileSkin.this.tile.getForegroundColor(), 0.1);
            Color barColor = this.chartData.getFillColor();
            boolean autoItemTextColor = CycleStepTileSkin.this.tile.getAutoItemTextColor();
            Color textColor = CycleStepTileSkin.this.tile.getForegroundColor();
            Font valueFont = Fonts.latoRegular(this.height * 0.3);
            FontMetrix fontMetrix = new FontMetrix(valueFont);
            String valueText = String.format(CycleStepTileSkin.this.tile.getLocale(), formatString, value);
            if (autoItemTextColor) {
                textColor = fontMetrix.computeStringWidth(valueText) > barWidth ? (Helper.isDark(CycleStepTileSkin.this.tile.getBackgroundColor()) ? CycleStepTileSkin.this.tile.getAutoItemBrightTextColor() : CycleStepTileSkin.this.tile.getAutoItemDarkTextColor()) : (Helper.isDark(barColor) ? CycleStepTileSkin.this.tile.getAutoItemBrightTextColor() : CycleStepTileSkin.this.tile.getAutoItemDarkTextColor());
            }
            this.ctx.setTextBaseline(VPos.CENTER);
            this.ctx.setFont(Fonts.latoRegular(this.height * 0.4));
            this.ctx.setTextAlign(TextAlignment.LEFT);
            this.ctx.clearRect(0.0, 0.0, this.width, this.height);
            this.ctx.setFill(CycleStepTileSkin.this.tile.getForegroundColor());
            this.ctx.fillText(this.chartData.getName(), 0.0, this.height / 2.0, maxTextWidth);
            this.ctx.setFill(barBackgroundColor);
            this.ctx.fillRect(barStartX, barStartY, maxBarWidth, barHeight);
            this.ctx.setFill(barColor);
            this.ctx.fillRect(barStartX + this.factorX * maxBarWidth, barStartY, barWidth, barHeight);
            this.ctx.setFill(textColor);
            this.ctx.setFont(valueFont);
            this.ctx.setTextAlign(TextAlignment.CENTER);
            this.ctx.fillText(valueText, barStartX + this.factorX * maxBarWidth + barWidth * 0.5, this.height * 0.5, maxTextWidth);
        }

        @Override
        public void onChartDataEvent(ChartDataEvent EVENT) {
            double sum = CycleStepTileSkin.this.tile.getChartData().stream().mapToDouble(chartData -> chartData.getValue()).sum();
            double lastFactor = 0.0;
            for (int i = 0; i < CycleStepTileSkin.this.chartBox.getChildren().size(); ++i) {
                ChartItem item = (ChartItem)CycleStepTileSkin.this.chartBox.getChildren().get(i);
                item.update(sum, lastFactor);
                lastFactor += item.getChartData().getValue() / sum;
            }
            this.redraw();
        }
    }
}

