/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.addons;

import eu.hansolo.tilesfx.addons.CanvasSpinner;
import eu.hansolo.tilesfx.addons.ImageSpinner;
import eu.hansolo.tilesfx.addons.Spinner;
import eu.hansolo.tilesfx.addons.SpinnerType;
import eu.hansolo.tilesfx.events.SpinnerObserver;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.scene.paint.Color;

public class SpinnerBuilder<B extends SpinnerBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected SpinnerBuilder() {
    }

    public static final SpinnerBuilder create() {
        return new SpinnerBuilder();
    }

    public final B value(double value) {
        this.properties.put("value", new SimpleDoubleProperty(value));
        return (B)this;
    }

    public final B backgroundVisible(boolean visible) {
        this.properties.put("backgroundVisible", new SimpleBooleanProperty(visible));
        return (B)this;
    }

    public final B overlayVisible(boolean visible) {
        this.properties.put("overlayVisible", new SimpleBooleanProperty(visible));
        return (B)this;
    }

    public final B snapshotBackground(Color color) {
        this.properties.put("snapshotBackground", new SimpleObjectProperty<Color>(color));
        return (B)this;
    }

    public final B backgroundColor(Color color) {
        this.properties.put("backgroundColor", new SimpleObjectProperty<Color>(color));
        return (B)this;
    }

    public final B foregroundColor(Color color) {
        this.properties.put("foregroundColor", new SimpleObjectProperty<Color>(color));
        return (B)this;
    }

    public final B type(SpinnerType spinnerType) {
        this.properties.put("spinnerType", new SimpleObjectProperty<SpinnerType>(spinnerType));
        return (B)this;
    }

    public final B prefSize(double width, double height) {
        this.properties.put("prefSize", new SimpleObjectProperty<Dimension2D>(new Dimension2D(width, height)));
        return (B)this;
    }

    public final B onValueChanged(SpinnerObserver observer) {
        this.properties.put("onValueChanged", new SimpleObjectProperty<SpinnerObserver>(observer));
        return (B)this;
    }

    public final B onZeroPassed(SpinnerObserver observer) {
        this.properties.put("onZeroPassed", new SimpleObjectProperty<SpinnerObserver>(observer));
        return (B)this;
    }

    public final B onSpinnerEvent(SpinnerObserver observer) {
        this.properties.put("onSpinnerEvent", new SimpleObjectProperty<SpinnerObserver>(observer));
        return (B)this;
    }

    private final void build(Spinner spinner) {
        for (String key : this.properties.keySet()) {
            if ("value".equals(key)) {
                spinner.setValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("snapshotBackground".equals(key)) {
                spinner.setSnapshotBackground((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("backgroundVisible".equals(key)) {
                spinner.setBackgroundVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("overlayVisible".equals(key)) {
                spinner.setOverlayVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("backgroundColor".equals(key)) {
                spinner.setBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("foregroundColor".equals(key)) {
                spinner.setForegroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("spinnerType".equals(key)) {
                spinner.setSpinnerType((SpinnerType)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("onValueChanged".equals(key)) {
                spinner.setOnValueChanged((SpinnerObserver)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("onZeroPassed".equals(key)) {
                spinner.setOnZeroPassed((SpinnerObserver)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"onSpinnerEvent".equals(key)) continue;
            spinner.setOnSpinnerEvent((SpinnerObserver)((ObjectProperty)this.properties.get(key)).get());
        }
    }

    public final ImageSpinner buildImageSpinner() {
        ImageSpinner spinner = new ImageSpinner();
        this.build(spinner);
        if (this.properties.containsKey("prefSize")) {
            Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get("prefSize")).get();
            spinner.setPrefSize(dim.getWidth(), dim.getHeight());
        }
        return spinner;
    }

    public final CanvasSpinner buildCanvasSpinner() {
        CanvasSpinner spinner = new CanvasSpinner();
        this.build(spinner);
        if (this.properties.containsKey("prefSize")) {
            Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get("prefSize")).get();
            spinner.setPrefSize(dim.getWidth(), dim.getHeight());
        }
        return spinner;
    }
}

