/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.heatmap;

import eu.hansolo.fx.heatmap.ColorMapping;
import eu.hansolo.fx.heatmap.HeatMap;
import eu.hansolo.fx.heatmap.Mapping;
import eu.hansolo.fx.heatmap.OpacityDistribution;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;

public class HeatMapBuilder<B extends HeatMapBuilder<B>> {
    private final HashMap<String, Property> properties = new HashMap();

    protected HeatMapBuilder() {
    }

    public static final HeatMapBuilder create() {
        return new HeatMapBuilder();
    }

    public final B prefSize(double width, double height) {
        return this.prefSize(new Dimension2D(width, height));
    }

    public final B prefSize(Dimension2D prefSize) {
        this.properties.put("prefSize", new SimpleObjectProperty<Dimension2D>(prefSize));
        return (B)this;
    }

    public final B width(double width) {
        this.properties.put("width", new SimpleDoubleProperty(width));
        return (B)this;
    }

    public final B height(double height) {
        this.properties.put("height", new SimpleDoubleProperty(height));
        return (B)this;
    }

    public final B colorMapping(Mapping colorMapping) {
        this.properties.put("colorMapping", new SimpleObjectProperty<Mapping>(colorMapping));
        return (B)this;
    }

    public final B spotRadius(double spotRadius) {
        this.properties.put("spotRadius", new SimpleDoubleProperty(spotRadius));
        return (B)this;
    }

    public final B fadeColors(boolean fadeColors) {
        this.properties.put("fadeColors", new SimpleBooleanProperty(fadeColors));
        return (B)this;
    }

    public final B heatMapOpacity(double heatMapOpacity) {
        this.properties.put("heatMapOpacity", new SimpleDoubleProperty(heatMapOpacity));
        return (B)this;
    }

    public final B opacityDistribution(OpacityDistribution opacityDistribution) {
        this.properties.put("opacityDistribution", new SimpleObjectProperty<OpacityDistribution>(opacityDistribution));
        return (B)this;
    }

    public final HeatMap build() {
        double width = 400.0;
        double height = 400.0;
        Mapping colorMapping = ColorMapping.LIME_YELLOW_RED;
        double spotRadius = 15.5;
        boolean fadeColors = false;
        double heatMapOpacity = 0.5;
        OpacityDistribution opacityDistribution = OpacityDistribution.CUSTOM;
        for (String key : this.properties.keySet()) {
            if ("prefSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                width = dim.getWidth();
                height = dim.getHeight();
                continue;
            }
            if ("width".equals(key)) {
                width = ((DoubleProperty)this.properties.get(key)).get();
                continue;
            }
            if ("height".equals(key)) {
                height = ((DoubleProperty)this.properties.get(key)).get();
                continue;
            }
            if ("colorMapping".equals(key)) {
                colorMapping = (Mapping)((ObjectProperty)this.properties.get(key)).get();
                continue;
            }
            if ("spotRadius".equals(key)) {
                spotRadius = ((DoubleProperty)this.properties.get(key)).get();
                continue;
            }
            if ("fadeColors".equals(key)) {
                fadeColors = ((BooleanProperty)this.properties.get(key)).get();
                continue;
            }
            if ("heatMapOpacity".equals(key)) {
                heatMapOpacity = ((DoubleProperty)this.properties.get(key)).get();
                continue;
            }
            if (!"opacityDistribution".equals(key)) continue;
            opacityDistribution = (OpacityDistribution)((Object)((ObjectProperty)this.properties.get(key)).get());
        }
        return new HeatMap(width, height, colorMapping, spotRadius, fadeColors, heatMapOpacity, opacityDistribution);
    }
}

