/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries.tools;

import eu.hansolo.fx.countries.Country;
import eu.hansolo.fx.countries.tools.CRegion;
import eu.hansolo.fx.countries.tools.CountryPath;
import eu.hansolo.toolboxfx.geom.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.paint.Color;

public class CountryRegion
implements CRegion {
    private String name;
    private List<Country> countries;
    private Map<Country, List<CountryPath>> countryPaths;

    public CountryRegion(String name, Country ... countries) {
        this.name = name;
        this.countries = new ArrayList<Country>(List.of(countries));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<Country> getCountries() {
        return this.countries;
    }

    @Override
    public void setFill(Color fill) {
        this.countries.forEach(country -> country.setFill(fill));
    }

    @Override
    public void setStroke(Color stroke) {
        this.countries.forEach(country -> country.setFill(stroke));
    }

    @Override
    public final List<Point> getRegionBounds() {
        double ulx = 360.0;
        double uly = 180.0;
        double lrx = 0.0;
        double lry = 0.0;
        for (Country country : this.getCountries()) {
            List<Point> coords = Country.getCountryBounds().get((Object)country);
            Point ul = coords.get(0);
            Point lr = coords.get(1);
            double lastULx = ulx;
            double lastULy = uly;
            ulx = ul.getX() + 180.0;
            uly = (ul.getY() - 90.0) * -1.0;
            ulx = Math.min(ulx, lastULx);
            uly = Math.min(uly, lastULy);
            double lastLRx = lrx;
            double lastLRy = lry;
            lrx = lr.getX() + 180.0;
            lry = (lr.getY() - 90.0) * -1.0;
            lrx = Math.max(lrx, lastLRx);
            lry = Math.max(lry, lastLRy);
        }
        uly = uly * -1.0 + 90.0;
        lry = lry * -1.0 + 90.0;
        Point upperLeft = new Point(ulx -= 180.0, uly);
        Point lowerRight = new Point(lrx -= 180.0, lry);
        return List.of(upperLeft, lowerRight);
    }

    @Override
    public final Map<Country, List<CountryPath>> getCountryPaths() {
        if (null == this.countryPaths) {
            this.countryPaths = new HashMap<Country, List<CountryPath>>();
            this.getCountries().forEach(country -> {
                ArrayList paths = new ArrayList();
                country.getCopyOfPaths().forEach(countryPath -> paths.add(countryPath));
                this.countryPaths.put((Country)((Object)country), paths);
            });
        }
        return this.countryPaths;
    }

    public final List<CountryPath> getPaths() {
        ArrayList<CountryPath> paths = new ArrayList<CountryPath>();
        this.getCountryPaths().values().forEach(cps -> cps.forEach(countryPath -> paths.add((CountryPath)countryPath)));
        return paths;
    }
}

