/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries;

import eu.hansolo.fx.countries.WorldPane;
import eu.hansolo.fx.countries.tools.Connection;
import eu.hansolo.fx.heatmap.Mapping;
import eu.hansolo.fx.heatmap.OpacityDistribution;
import eu.hansolo.toolboxfx.geom.Poi;
import eu.hansolo.toolboxfx.geom.Point;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class WorldPaneBuilder<B extends WorldPaneBuilder<B>> {
    private final HashMap<String, Property> properties = new HashMap();

    protected WorldPaneBuilder() {
    }

    public static final WorldPaneBuilder create() {
        return new WorldPaneBuilder();
    }

    public final B background(Paint paint) {
        this.properties.put("background", new SimpleObjectProperty<Paint>(paint));
        return (B)this;
    }

    public final B fill(Color fill) {
        this.properties.put("fill", new SimpleObjectProperty<Color>(fill));
        return (B)this;
    }

    public final B lineWidth(double lineWidth) {
        this.properties.put("lineWidth", new SimpleDoubleProperty(lineWidth));
        return (B)this;
    }

    public final B stroke(Color stroke) {
        this.properties.put("stroke", new SimpleObjectProperty<Color>(stroke));
        return (B)this;
    }

    public final B poiFill(Color poiFill) {
        this.properties.put("poiFill", new SimpleObjectProperty<Color>(poiFill));
        return (B)this;
    }

    public final B poiStroke(Color poiStroke) {
        this.properties.put("poiStroke", new SimpleObjectProperty<Color>(poiStroke));
        return (B)this;
    }

    public final B poiTextFill(Color poiTextFill) {
        this.properties.put("poiTextFill", new SimpleObjectProperty<Color>(poiTextFill));
        return (B)this;
    }

    public final B poisVisible(boolean poisVisible) {
        this.properties.put("poisVisible", new SimpleBooleanProperty(poisVisible));
        return (B)this;
    }

    public final B poiTextVisible(boolean poiTextVisible) {
        this.properties.put("poiTextVisible", new SimpleBooleanProperty(poiTextVisible));
        return (B)this;
    }

    public final B pois(List<Poi> pois) {
        this.properties.put("pois", new SimpleObjectProperty<List<Poi>>(pois));
        return (B)this;
    }

    public final B heatmapVisible(boolean heatmapVisible) {
        this.properties.put("heatmapVisible", new SimpleBooleanProperty(heatmapVisible));
        return (B)this;
    }

    public final B heatmapSpots(List<Point> heatmapSpots) {
        this.properties.put("heatmapSpots", new SimpleObjectProperty<List<Point>>(heatmapSpots));
        return (B)this;
    }

    public final B heatmapColorMapping(Mapping heatmapColorMapping) {
        this.properties.put("heatmapColorMapping", new SimpleObjectProperty<Mapping>(heatmapColorMapping));
        return (B)this;
    }

    public final B heatmapSpotRadius(double heatmapSpotRadius) {
        this.properties.put("heatmapSpotRadius", new SimpleDoubleProperty(heatmapSpotRadius));
        return (B)this;
    }

    public final B heatmapFadeColors(boolean heatmapFadeColors) {
        this.properties.put("heatmapFadeColors", new SimpleBooleanProperty(heatmapFadeColors));
        return (B)this;
    }

    public final B heatmapOpacityDistribution(OpacityDistribution heatmapOpacityDistribution) {
        this.properties.put("heatmapOpacityDistribution", new SimpleObjectProperty<OpacityDistribution>(heatmapOpacityDistribution));
        return (B)this;
    }

    public final B heatmapOpacity(double heatmapOpacity) {
        this.properties.put("heatmapOpacity", new SimpleDoubleProperty(heatmapOpacity));
        return (B)this;
    }

    public final B connections(List<Connection> connections) {
        this.properties.put("connections", new SimpleObjectProperty<List<Connection>>(connections));
        return (B)this;
    }

    public final B overlayVisible(boolean overlayVisible) {
        this.properties.put("overlayVisible", new SimpleBooleanProperty(overlayVisible));
        return (B)this;
    }

    public final B hoverEnabled(boolean hoverEnabled) {
        this.properties.put("hoverEnabled", new SimpleBooleanProperty(hoverEnabled));
        return (B)this;
    }

    public final B selectionEnabled(boolean selectionEnabled) {
        this.properties.put("selectionEnabled", new SimpleBooleanProperty(selectionEnabled));
        return (B)this;
    }

    public final B hoverColor(Color hoverColor) {
        this.properties.put("hoverColor", new SimpleObjectProperty<Color>(hoverColor));
        return (B)this;
    }

    public final B pressedColor(Color pressedColor) {
        this.properties.put("pressedColor", new SimpleObjectProperty<Color>(pressedColor));
        return (B)this;
    }

    public final B selectedColor(Color selectedColor) {
        this.properties.put("selectedColor", new SimpleObjectProperty<Color>(selectedColor));
        return (B)this;
    }

    public final B mouseEnterHandler(EventHandler<MouseEvent> handler) {
        this.properties.put("mouseEnterHandler", new SimpleObjectProperty<EventHandler<MouseEvent>>(handler));
        return (B)this;
    }

    public final B mousePressHandler(EventHandler<MouseEvent> handler) {
        this.properties.put("mousePressHandler", new SimpleObjectProperty<EventHandler<MouseEvent>>(handler));
        return (B)this;
    }

    public final B mouseReleaseHandler(EventHandler<MouseEvent> handler) {
        this.properties.put("mouseReleaseHandler", new SimpleObjectProperty<EventHandler<MouseEvent>>(handler));
        return (B)this;
    }

    public final B mouseExitHandler(EventHandler<MouseEvent> handler) {
        this.properties.put("mouseExitHandler", new SimpleObjectProperty<EventHandler<MouseEvent>>(handler));
        return (B)this;
    }

    public final B prefSize(double width, double height) {
        this.properties.put("prefSize", new SimpleObjectProperty<Dimension2D>(new Dimension2D(width, height)));
        return (B)this;
    }

    public final B minSize(double width, double height) {
        this.properties.put("minSize", new SimpleObjectProperty<Dimension2D>(new Dimension2D(width, height)));
        return (B)this;
    }

    public final B maxSize(double width, double height) {
        this.properties.put("maxSize", new SimpleObjectProperty<Dimension2D>(new Dimension2D(width, height)));
        return (B)this;
    }

    public final B prefWidth(double prefWidth) {
        this.properties.put("prefWidth", new SimpleDoubleProperty(prefWidth));
        return (B)this;
    }

    public final B prefHeight(double prefHeight) {
        this.properties.put("prefHeight", new SimpleDoubleProperty(prefHeight));
        return (B)this;
    }

    public final B minWidth(double minWidth) {
        this.properties.put("minWidth", new SimpleDoubleProperty(minWidth));
        return (B)this;
    }

    public final B minHeight(double minHeight) {
        this.properties.put("minHeight", new SimpleDoubleProperty(minHeight));
        return (B)this;
    }

    public final B maxWidth(double maxWidth) {
        this.properties.put("maxWidth", new SimpleDoubleProperty(maxWidth));
        return (B)this;
    }

    public final B maxHeight(double maxheight) {
        this.properties.put("maxHeight", new SimpleDoubleProperty(maxheight));
        return (B)this;
    }

    public final B scaleX(double scaleX) {
        this.properties.put("scaleX", new SimpleDoubleProperty(scaleX));
        return (B)this;
    }

    public final B scaleY(double scaleY) {
        this.properties.put("scaleY", new SimpleDoubleProperty(scaleY));
        return (B)this;
    }

    public final B layoutX(double layoutX) {
        this.properties.put("layoutX", new SimpleDoubleProperty(layoutX));
        return (B)this;
    }

    public final B layoutY(double layoutY) {
        this.properties.put("layoutY", new SimpleDoubleProperty(layoutY));
        return (B)this;
    }

    public final B translateX(double translateX) {
        this.properties.put("translateX", new SimpleDoubleProperty(translateX));
        return (B)this;
    }

    public final B translateY(double translateY) {
        this.properties.put("translateY", new SimpleDoubleProperty(translateY));
        return (B)this;
    }

    public final B padding(Insets insets) {
        this.properties.put("padding", new SimpleObjectProperty<Insets>(insets));
        return (B)this;
    }

    public final WorldPane build() {
        WorldPane worldPane = new WorldPane();
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                worldPane.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                worldPane.setMinSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                worldPane.setMaxSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                worldPane.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                worldPane.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                worldPane.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                worldPane.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                worldPane.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                worldPane.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                worldPane.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                worldPane.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                worldPane.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                worldPane.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                worldPane.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                worldPane.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("padding".equals(key)) {
                worldPane.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("backgroundColor".equals(key)) {
                worldPane.setBackground((Paint)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("fill".equals(key)) {
                worldPane.setFill((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("stroke".equals(key)) {
                worldPane.setStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lineWidth".equals(key)) {
                worldPane.setLineWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("poiFill".equals(key)) {
                worldPane.setPoiFill((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("poiStroke".equals(key)) {
                worldPane.setPoiStroke((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("poiTextFill".equals(key)) {
                worldPane.setPoiTextFill((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("poisVisible".equals(key)) {
                worldPane.setPoisVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("poiTextVisible".equals(key)) {
                worldPane.setPoiTextVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("pois".equals(key)) {
                worldPane.addPois((List)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("heatmapVisible".equals(key)) {
                worldPane.setHeatmapVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("heatmapSpots".equals(key)) {
                worldPane.setHeatmapSpots((List)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("heatmapColorMapping".equals(key)) {
                worldPane.setHeatmapColorMapping((Mapping)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("heatmapSpotRadius".equals(key)) {
                worldPane.setHeatmapSpotRadius(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("heatmapFadeColors".equals(key)) {
                worldPane.setHeatmapFadeColors(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("heatmapOpacityDistribution".equals(key)) {
                worldPane.setHeatmapOpacityDistribution((OpacityDistribution)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("heatmapOpacity".equals(key)) {
                worldPane.setHeatmapOpacity(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("connections".equals(key)) {
                worldPane.setConnections((List)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("overlayVisible".equals(key)) {
                worldPane.setOverlayVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("hoverEnabled".equals(key)) {
                worldPane.setHoverEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("selectionEnabled".equals(key)) {
                worldPane.setSelectionEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("hoverColor".equals(key)) {
                worldPane.setHoverColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("pressedColor".equals(key)) {
                worldPane.setPressedColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("selectedColor".equals(key)) {
                worldPane.setSelectedColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("mouseEnterHandler".equals(key)) {
                worldPane.setMouseEnterHandler((EventHandler)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("mousePressHandler".equals(key)) {
                worldPane.setMousePressHandler((EventHandler)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("mouseReleaseHandler".equals(key)) {
                worldPane.setMouseReleaseHandler((EventHandler)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"mouseExitHandler".equals(key)) continue;
            worldPane.setMouseExitHandler((EventHandler)((ObjectProperty)this.properties.get(key)).get());
        }
        return worldPane;
    }
}

