# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.prop import Prop


class VRControlsHelper(Prop):
    r"""
    VRControlsHelper - Tooltip helper explaining controls
    
    Superclass: Prop
    
    Helper class to draw one tooltip per button around the controller.
    
    @sa
    VRPanelRepresentation
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkVRControlsHelper, obj, update, **traits)
    
    enabled = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _enabled_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnabled,
                        self.enabled_)

    def _get_renderer(self):
        return wrap_vtk(self._vtk_obj.GetRenderer())
    def _set_renderer(self, arg):
        old_val = self._get_renderer()
        self._wrap_call(self._vtk_obj.SetRenderer,
                        deref_vtk(arg))
        self.trait_property_changed('renderer', old_val, arg)
    renderer = traits.Property(_get_renderer, _set_renderer, desc=\
        r"""
        
        """
    )

    def build_representation(self):
        """
        build_representation(self) -> None
        C++: void build_representation()
        Methods to interface with the VRPanelWidget.
        """
        ret = self._vtk_obj.BuildRepresentation()
        return ret
        

    def set_device(self, *args):
        """
        set_device(self, val:EventDataDevice) -> None
        C++: void set_device(EventDataDevice val)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetDevice, *my_args)
        return ret

    def set_text(self, *args):
        """
        set_text(self, str:str) -> None
        C++: void set_text(const std::string &str)
        Set Tooltip text (used by text_actor)
        """
        ret = self._wrap_call(self._vtk_obj.SetText, *args)
        return ret

    def set_tooltip_info(self, *args):
        """
        set_tooltip_info(self, s:str, buttonSide:int, drawSide:int, txt:str)
             -> None
        C++: void set_tooltip_info(const char *s, int buttonSide,
            int drawSide, const char *txt)"""
        ret = self._wrap_call(self._vtk_obj.SetTooltipInfo, *args)
        return ret

    def update_representation(self):
        """
        update_representation(self) -> None
        C++: void update_representation()"""
        ret = self._vtk_obj.UpdateRepresentation()
        return ret
        

    _updateable_traits_ = \
    (('enabled', 'GetEnabled'), ('dragable', 'GetDragable'), ('pickable',
    'GetPickable'), ('use_bounds', 'GetUseBounds'), ('visibility',
    'GetVisibility'), ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('estimated_render_time',
    'GetEstimatedRenderTime'), ('render_time_multiplier',
    'GetRenderTimeMultiplier'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'dragable', 'enabled', 'global_warning_display',
    'pickable', 'use_bounds', 'visibility', 'estimated_render_time',
    'render_time_multiplier'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(VRControlsHelper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit VRControlsHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['enabled', 'use_bounds', 'visibility'], [],
            ['estimated_render_time', 'render_time_multiplier']),
            title='Edit VRControlsHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit VRControlsHelper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

