# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.lagrangian_particle_tracker import LagrangianParticleTracker


class PLagrangianParticleTracker(LagrangianParticleTracker):
    r"""
    PLagrangianParticleTracker - parallel Lagrangian particle tracker
    
    Superclass: LagrangianParticleTracker
    
    This class implements parallel Lagrangian particle tracker. The
    implementation is as follows: First seeds input is parsed to create
    particle in each rank Particles which are not contained by the flow
    in a rank are sent to other ranks which can potentially contain it
    and will grab only if they actually contain it Then each rank begin
    integrating. When a particle goes out of domain, the particle will be
    sent to other ranks the same way. When a rank runs out of particle,
    it waits for other potential particles from other ranks. When all
    ranks run out of particles, integration is over. The master rank
    takes care of communications between rank regarding integration
    termination particles are directly streamed rank to rank, without
    going through the master
    
    @sa
    StreamTracer
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPLagrangianParticleTracker, obj, update, **traits)
    
    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('adaptive_step_reintegration', 'GetAdaptiveStepReintegration'),
    ('generate_particle_paths_output', 'GetGenerateParticlePathsOutput'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('cell_length_computation_mode', 'GetCellLengthComputationMode'),
    ('generate_poly_vertex_interaction_output',
    'GetGeneratePolyVertexInteractionOutput'),
    ('maximum_integration_time', 'GetMaximumIntegrationTime'),
    ('maximum_number_of_steps', 'GetMaximumNumberOfSteps'),
    ('step_factor', 'GetStepFactor'), ('step_factor_max',
    'GetStepFactorMax'), ('step_factor_min', 'GetStepFactorMin'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'adaptive_step_reintegration', 'debug',
    'generate_particle_paths_output', 'global_warning_display',
    'release_data_flag', 'cell_length_computation_mode',
    'generate_poly_vertex_interaction_output', 'maximum_integration_time',
    'maximum_number_of_steps', 'progress_text', 'step_factor',
    'step_factor_max', 'step_factor_min'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PLagrangianParticleTracker, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PLagrangianParticleTracker properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['adaptive_step_reintegration',
            'generate_particle_paths_output'], [],
            ['cell_length_computation_mode',
            'generate_poly_vertex_interaction_output', 'maximum_integration_time',
            'maximum_number_of_steps', 'step_factor', 'step_factor_max',
            'step_factor_min']),
            title='Edit PLagrangianParticleTracker properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PLagrangianParticleTracker properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

