# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class OSPRayMaterialLibrary(Object):
    r"""
    OSPRayMaterialLibrary - a collection of materials for vtk apps to
    draw from
    
    Superclass: Object
    
    A singleton instance of this class manages a collection of materials.
    The materials can be read in from disk or created programmatically.
    
    @sa OSPRayMaterialHelpers
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOSPRayMaterialLibrary, obj, update, **traits)
    
    def get_double_shader_variable(self, *args):
        """
        get_double_shader_variable(self, nickname:str, varname:str) -> (
            float, ...)
        C++: std::vector<double> get_double_shader_variable(
            const std::string &nickname, const std::string &varname)
        Returns a uniform variable.
        """
        ret = self._wrap_call(self._vtk_obj.GetDoubleShaderVariable, *args)
        return ret

    def get_double_shader_variable_list(self, *args):
        """
        get_double_shader_variable_list(self, nickname:str) -> (str, ...)
        C++: std::vector<std::string> get_double_shader_variable_list(
            const std::string &nickname)
        Returns list of variable names set for a specific material.
        """
        ret = self._wrap_call(self._vtk_obj.GetDoubleShaderVariableList, *args)
        return ret

    def get_texture(self, *args):
        """
        get_texture(self, nickname:str, varname:str) -> Texture
        C++: Texture *get_texture(const std::string &nickname,
            const std::string &varname)
        Returns a texture.
        """
        ret = self._wrap_call(self._vtk_obj.GetTexture, *args)
        return wrap_vtk(ret)

    def get_texture_filename(self, *args):
        """
        get_texture_filename(self, nickname:str, varname:str) -> str
        C++: std::string get_texture_filename(const std::string &nickname,
            const std::string &varname)
        Returns the filename associated ti a texture (if any).
        """
        ret = self._wrap_call(self._vtk_obj.GetTextureFilename, *args)
        return ret

    def get_texture_list(self, *args):
        """
        get_texture_list(self, nickname:str) -> (str, ...)
        C++: std::vector<std::string> get_texture_list(
            const std::string &nickname)
        Returns list of texture names set for a specific material.
        """
        ret = self._wrap_call(self._vtk_obj.GetTextureList, *args)
        return ret

    def get_texture_name(self, *args):
        """
        get_texture_name(self, nickname:str, varname:str) -> str
        C++: std::string get_texture_name(const std::string &nickname,
            const std::string &varname)
        Returns the name (and not the shader variable name) associated to
        a texture.
        """
        ret = self._wrap_call(self._vtk_obj.GetTextureName, *args)
        return ret

    def add_material(self, *args):
        """
        add_material(self, nickname:str, implname:str) -> None
        C++: void add_material(const std::string &nickname,
            const std::string &implname)
        Add Material Adds a new material nickname to the set of known
        materials. If the name is a repeat, we replace the old one.
        """
        ret = self._wrap_call(self._vtk_obj.AddMaterial, *args)
        return ret

    def add_shader_variable(self, *args):
        """
        add_shader_variable(self, nickname:str, variablename:str,
            numVars:int, x:(float, ...)) -> None
        C++: void add_shader_variable(const std::string &nickname,
            const std::string &variablename, int numVars, const double *x)"""
        ret = self._wrap_call(self._vtk_obj.AddShaderVariable, *args)
        return ret

    def add_texture(self, *args):
        """
        add_texture(self, nickname:str, varname:str, tex:Texture,
            texturename:str=..., filename:str=...) -> None
        C++: void add_texture(const std::string &nickname,
            const std::string &varname, Texture *tex,
            const std::string &texturename="unnamedTexture",
            const std::string &filename="")
        Add Texture Given a material nickname and a shader variable
        varname, set its data to a specific texture tex named
        texturename. If not specified the texture is called
        "unnamedTexture". The last parameter, filename, is defaulted to
        empty. If specified, the absolut path to find the texture will be
        stored. Useful when writing the library into a file.
        
        Replaces any previous content.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddTexture, *my_args)
        return ret

    def fire(self):
        """
        fire(self) -> None
        C++: void fire()
        Called to kick off events in all followers.
        """
        ret = self._vtk_obj.Fire()
        return ret
        

    def lookup_impl_name(self, *args):
        """
        lookup_impl_name(self, nickname:str) -> str
        C++: std::string lookup_impl_name(const std::string &nickname)
        Return an implementation name for the given material nickname.
        """
        ret = self._wrap_call(self._vtk_obj.LookupImplName, *args)
        return ret

    def read_buffer(self, *args):
        """
        read_buffer(self, Buffer:str) -> bool
        C++: bool read_buffer(const char *Buffer)
        de_serialize contents from an in memory buffer as read_file does
        from a file or set of files. Returns false only if buffer could
        not be meaningfully interpreted.
        """
        ret = self._wrap_call(self._vtk_obj.ReadBuffer, *args)
        return ret

    def read_file(self, *args):
        """
        read_file(self, FileName:str) -> bool
        C++: bool read_file(const char *FileName)
        Reads the given file of materials and creates the in memory data
        structures needed to display objects with them. Returns false
        only if file could not be meaningfully interpreted.
        """
        ret = self._wrap_call(self._vtk_obj.ReadFile, *args)
        return ret

    def remove_all_shader_variables(self, *args):
        """
        remove_all_shader_variables(self, nickname:str) -> None
        C++: void remove_all_shader_variables(const std::string &nickname)
        Remove all control variables of a specific material
        """
        ret = self._wrap_call(self._vtk_obj.RemoveAllShaderVariables, *args)
        return ret

    def remove_all_textures(self, *args):
        """
        remove_all_textures(self, nickname:str) -> None
        C++: void remove_all_textures(const std::string &nickname)
        Remove all textures of a specific material
        """
        ret = self._wrap_call(self._vtk_obj.RemoveAllTextures, *args)
        return ret

    def remove_material(self, *args):
        """
        remove_material(self, nickname:str) -> None
        C++: void remove_material(const std::string &nickname)
        Remove Material Removes a material nickname from the set of known
        materials. Do nothing if material does not exist.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveMaterial, *args)
        return ret

    def remove_shader_variable(self, *args):
        """
        remove_shader_variable(self, nickname:str, variablename:str) -> None
        C++: void remove_shader_variable(const std::string &nickname,
            const std::string &variablename)
        Remove control variable Removes a new control variable. Do
        nothing if variable does not exist.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveShaderVariable, *args)
        return ret

    def remove_texture(self, *args):
        """
        remove_texture(self, nickname:str, varname:str) -> None
        C++: void remove_texture(const std::string &nickname,
            const std::string &varname)
        Remove Texture Removes a texture for a specific materal nickname
        and shader variable varname. Do nothing if texture does not
        exist.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveTexture, *args)
        return ret

    def write_buffer(self, *args):
        """
        write_buffer(self, writeImageInline:bool=True) -> str
        C++: const char *write_buffer(bool writeImageInline=true)
        Serialize contents to an in memory buffer. If writeimage_inline,
        all textures are stored in a XML format. Else, store the texture
        using its filename stored in its texture_info struct. Warning: you
        must free the return value using delete.
        """
        ret = self._wrap_call(self._vtk_obj.WriteBuffer, *args)
        return ret

    def write_file(self, *args):
        """
        write_file(self, filename:str, writeImageInline:bool=False) -> None
        C++: void write_file(const std::string &filename,
            bool writeImageInline=false)
        Serialize contents to a file specified by filename. If
        writeimage_inline, all textures are stored in a XML format. Else,
        store the texture using its filename stored in its texture_info
        struct Warning: if filename exists, its content is discarded.
        """
        ret = self._wrap_call(self._vtk_obj.WriteFile, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OSPRayMaterialLibrary, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OSPRayMaterialLibrary properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit OSPRayMaterialLibrary properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OSPRayMaterialLibrary properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

