# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.light_node import LightNode


class OSPRayLightNode(LightNode):
    r"""
    OSPRayLightNode - links Lights to OSPRay
    
    Superclass: LightNode
    
    Translates Light state into OSPRay rendering calls
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOSPRayLightNode, obj, update, **traits)
    
    def get_is_ambient(self, *args):
        """
        get_is_ambient(__a:Light) -> int
        C++: static int get_is_ambient(Light *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetIsAmbient, *my_args)
        return ret

    def set_is_ambient(self, *args):
        """
        set_is_ambient(__a:int, __b:Light) -> None
        C++: static void set_is_ambient(int, Light *)
        Convenience method to set/get IS_AMBIENT on a Light.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetIsAmbient, *my_args)
        return ret

    light_scale = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        A global multiplier to all ospray lights. default is 1.0
        """
    )

    def _light_scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLightScale,
                        self.light_scale)

    def get_radius(self, *args):
        """
        get_radius(__a:Light) -> float
        C++: static double get_radius(Light *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetRadius, *my_args)
        return ret

    def set_radius(self, *args):
        """
        set_radius(__a:float, __b:Light) -> None
        C++: static void set_radius(double, Light *)
        Convenience method to set/get RADIUS on a Light.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetRadius, *my_args)
        return ret

    def IS_AMBIENT(self):
        """
        is__ambient() -> InformationIntegerKey
        C++: static InformationIntegerKey *is__ambient()
        When present on light, the light acts as an ambient source. An
        ambient_light is one that has no specific position in space and
        for which only the ambient color term affects the result.
        """
        ret = wrap_vtk(self._vtk_obj.IS_AMBIENT())
        return ret
        

    def RADIUS(self):
        """
        radius() -> InformationDoubleKey
        C++: static InformationDoubleKey *radius()
        The radius setting, when > 0.0, produces soft shadows in the path
        tracer.
        """
        ret = wrap_vtk(self._vtk_obj.RADIUS())
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('light_scale', 'GetLightScale'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'light_scale'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OSPRayLightNode, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OSPRayLightNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['light_scale']),
            title='Edit OSPRayLightNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OSPRayLightNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

