# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.actor_node import ActorNode


class OSPRayActorNode(ActorNode):
    r"""
    OSPRayActorNode - links Actor and Mapper to OSPRay
    
    Superclass: ActorNode
    
    Translates Actor/Mapper state into OSPRay rendering calls
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOSPRayActorNode, obj, update, **traits)
    
    def get_enable_scaling(self, *args):
        """
        get_enable_scaling(__a:Actor) -> int
        C++: static int get_enable_scaling(Actor *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetEnableScaling, *my_args)
        return ret

    def set_enable_scaling(self, *args):
        """
        set_enable_scaling(value:int, __b:Actor) -> None
        C++: static void set_enable_scaling(int value, Actor *)
        Convenience method to set enable_scaling on my renderable.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetEnableScaling, *my_args)
        return ret

    def get_luminosity(self, *args):
        """
        get_luminosity(__a:Property) -> float
        C++: static double get_luminosity(Property *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetLuminosity, *my_args)
        return ret

    def set_luminosity(self, *args):
        """
        set_luminosity(value:float, __b:Property) -> None
        C++: static void set_luminosity(double value, Property *)
        Convenience method to set luminosity on my renderable.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetLuminosity, *my_args)
        return ret

    def ENABLE_SCALING(self):
        """
        enable__scaling() -> InformationIntegerKey
        C++: static InformationIntegerKey *enable__scaling()
        A key to set the scaling_mode. The default is ALL_APPROXIMATE.
        ALL_EXACT means use Actor.PointSize/LineWidth for all radii.
        ALL_APPROXIMATE sets all radii to approximate GL's pixel sizes
        via a function of point_size/line_width and object bounding box.
        EACH_MAPPED means map every value from SCALE_ARRAY_NAME through
        the SCALE_FUNCTION lookup table to set each radius independently.
        EACH_EXACT means use the SCALE_ARRAY_NAME to set each radius
        directly.
        """
        ret = wrap_vtk(self._vtk_obj.ENABLE_SCALING())
        return ret
        

    def LUMINOSITY(self):
        """
        luminosity() -> InformationDoubleKey
        C++: static InformationDoubleKey *luminosity()
        Indicates that the actor acts as a light emitting object.
        """
        ret = wrap_vtk(self._vtk_obj.LUMINOSITY())
        return ret
        

    def SCALE_ARRAY_NAME(self):
        """
        scale__array__name() -> InformationStringKey
        C++: static InformationStringKey *scale__array__name()
        Name of a point aligned, single component wide, double valued
        array that, when added to the mapper, will be used to scale each
        element in the sphere and cylinder representations individually.
        When not supplied the radius is constant across all elements and
        is a function of the Mapper's point_size and line_width.
        """
        ret = wrap_vtk(self._vtk_obj.SCALE_ARRAY_NAME())
        return ret
        

    def SCALE_FUNCTION(self):
        """
        scale__function() -> InformationObjectBaseKey
        C++: static InformationObjectBaseKey *scale__function()
        A piecewise function for values from the scale array that alters
        the resulting radii arbitrarily
        """
        ret = wrap_vtk(self._vtk_obj.SCALE_FUNCTION())
        return ret
        

    def set_scale_array_name(self, *args):
        """
        set_scale_array_name(scaleArrayName:str, __b:Actor) -> None
        C++: static void set_scale_array_name(const char *scaleArrayName,
            Actor *)
        Convenience method to set a scale_array_name on my renderable.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetScaleArrayName, *my_args)
        return ret

    def set_scale_function(self, *args):
        """
        set_scale_function(scaleFunction:PiecewiseFunction, __b:Actor)
             -> None
        C++: static void set_scale_function(
            PiecewiseFunction *scaleFunction, Actor *)
        Convenience method to set a scale_function on my renderable.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetScaleFunction, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OSPRayActorNode, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OSPRayActorNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit OSPRayActorNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OSPRayActorNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

