# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class OMFReader(DataObjectAlgorithm):
    r"""
    OMFReader - Read Open Mining Format files
    
    Superclass: DataObjectAlgorithm
    
    OMFReader reads OMF files. Details about the OMF format can be
    found at https://omf.readthedocs.io/en/stable/index.html. The reader
    outputs a PartitionedDataSetCollection, where each
    PartitionedDataSet is one OMF element (point set, line set,
    surface, or volume).
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOMFReader, obj, update, **traits)
    
    column_major_ordering = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        Get/Set if scalar data is in column major order. It should be in
        row major order but some software seems to write out column major
        for volumes.
        """
    )

    def _column_major_ordering_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetColumnMajorOrdering,
                        self.column_major_ordering)

    def get_data_element_array_status(self, *args):
        """
        get_data_element_array_status(self, name:str) -> bool
        C++: bool get_data_element_array_status(const char *name)
        Data element selection to determine which data elements in the
        OMF file should be loaded. By default all elements' status are
        set to false/disabled, so they will not be loaded.
        """
        ret = self._wrap_call(self._vtk_obj.GetDataElementArrayStatus, *args)
        return ret

    def set_data_element_array_status(self, *args):
        """
        set_data_element_array_status(self, name:str, status:int) -> None
        C++: void set_data_element_array_status(const char *name, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetDataElementArrayStatus, *args)
        return ret

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Accessor for name of the OMF file to read
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    write_out_textures = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        r"""
        Get/Set for determining to write out textures from OMF file
        """
    )

    def _write_out_textures_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWriteOutTextures,
                        self.write_out_textures)

    def get_data_element_array_name(self, *args):
        """
        get_data_element_array_name(self, index:int) -> str
        C++: const char *get_data_element_array_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetDataElementArrayName, *args)
        return ret

    def _get_data_element_array_selection(self):
        return wrap_vtk(self._vtk_obj.GetDataElementArraySelection())
    data_element_array_selection = traits.Property(_get_data_element_array_selection, desc=\
        r"""
        
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_number_of_data_element_arrays(self):
        return self._vtk_obj.GetNumberOfDataElementArrays()
    number_of_data_element_arrays = traits.Property(_get_number_of_data_element_arrays, desc=\
        r"""
        
        """
    )

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('column_major_ordering', 'GetColumnMajorOrdering'), ('file_name',
    'GetFileName'), ('write_out_textures', 'GetWriteOutTextures'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'column_major_ordering', 'file_name',
    'progress_text', 'write_out_textures'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OMFReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OMFReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['column_major_ordering', 'file_name',
            'write_out_textures']),
            title='Edit OMFReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OMFReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

