# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.communicator import Communicator


class MPICommunicator(Communicator):
    r"""
    MPICommunicator - Class for creating user defined MPI
    communicators.
    
    Superclass: Communicator
    
    This class can be used to create user defined MPI communicators. The
    actual creation (with MPI_Comm_create) occurs in Initialize which
    takes as arguments a super-communicator and a group of process ids.
    The new communicator is created by including the processes contained
    in the group. The global communicator (equivalent to MPI_COMM_WORLD)
    can be obtained using the class method get_world_communicator. It is
    important to note that this communicator should not be used on the
    processes not contained in the group. For example, if the group
    contains processes 0 and 1, controller->set_communicator(communicator)
    would cause an MPI error on any other process.
    
    @sa
    MPIController ProcessGroup
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMPICommunicator, obj, update, **traits)
    
    use_ssend = tvtk_base.false_bool_trait(desc=\
        r"""
        When set to 1, all MPI_Send calls are replaced by MPI_Ssend
        calls. Default is 0.
        """
    )

    def _use_ssend_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseSsend,
                        self.use_ssend_)

    def _get_mpi_comm(self):
        return wrap_vtk(self._vtk_obj.GetMPIComm())
    mpi_comm = traits.Property(_get_mpi_comm, desc=\
        r"""
        
        """
    )

    def _get_use_ssend_max_value(self):
        return self._vtk_obj.GetUseSsendMaxValue()
    use_ssend_max_value = traits.Property(_get_use_ssend_max_value, desc=\
        r"""
        
        """
    )

    def _get_use_ssend_min_value(self):
        return self._vtk_obj.GetUseSsendMinValue()
    use_ssend_min_value = traits.Property(_get_use_ssend_min_value, desc=\
        r"""
        
        """
    )

    def _get_world_communicator(self):
        return wrap_vtk(self._vtk_obj.GetWorldCommunicator())
    world_communicator = traits.Property(_get_world_communicator, desc=\
        r"""
        Returns the singleton which behaves as the global communicator
        (MPI_COMM_WORLD)
        """
    )

    def allocate(self, *args):
        """
        allocate(size:int) -> str
        C++: static char *allocate(size_t size)"""
        ret = self._wrap_call(self._vtk_obj.Allocate, *args)
        return ret

    def copy_from(self, *args):
        """
        copy_from(self, source:MPICommunicator) -> None
        C++: void copy_from(MPICommunicator *source)
        Copies all the attributes of source, deleting previously stored
        data. The MPI communicator handle is also copied. Normally, this
        should not be needed. It is used during the construction of a new
        communicator for copying the world communicator, keeping the same
        context.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CopyFrom, *my_args)
        return ret

    def free(self, *args):
        """
        free(ptr:str) -> None
        C++: static void free(char *ptr)"""
        ret = self._wrap_call(self._vtk_obj.Free, *args)
        return ret

    def initialize(self, *args):
        """
        initialize(self, group:ProcessGroup) -> int
        C++: int initialize(ProcessGroup *group)
        Used to initialize the communicator (i.e. create the underlying
        MPI_Comm). The group must be associated with a valid
        MPICommunicator.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Initialize, *my_args)
        return ret

    def initialize_external(self, *args):
        """
        initialize_external(self, comm:MPICommunicatorOpaqueComm) -> int
        C++: int initialize_external(MPICommunicatorOpaqueComm *comm)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.InitializeExternal, *my_args)
        return ret

    def iprobe(self, *args):
        """
        iprobe(self, source:int, tag:int, flag:[int, ...],
            actualSource:[int, ...]) -> int
        C++: int iprobe(int source, int tag, int *flag, int *actualSource)
        iprobe(self, source:int, tag:int, flag:[int, ...],
            actualSource:[int, ...], type:[int, ...], size:[int, ...])
            -> int
        C++: int iprobe(int source, int tag, int *flag, int *actualSource,
             int *type, int *size)
        iprobe(self, source:int, tag:int, flag:[int, ...],
            actualSource:[int, ...], type:[int, ...], size:[int, ...])
            -> int
        C++: int iprobe(int source, int tag, int *flag, int *actualSource,
             unsigned long *type, int *size)
        iprobe(self, source:int, tag:int, flag:[int, ...],
            actualSource:[int, ...], type:str, size:[int, ...]) -> int
        C++: int iprobe(int source, int tag, int *flag, int *actualSource,
             const char *type, int *size)
        iprobe(self, source:int, tag:int, flag:[int, ...],
            actualSource:[int, ...], type:[float, ...], size:[int, ...])
            -> int
        C++: int iprobe(int source, int tag, int *flag, int *actualSource,
             double *type, int *size)
        Nonblocking test for a message.  Inputs are: source -- the source
        rank or ANY_SOURCE; tag -- the tag value.  Outputs are: flag --
        True if a message matches; actualSource -- the rank sending the
        message (useful if ANY_SOURCE is used) if flag is True and
        actualSource isn't nullptr; size -- the length of the message in
        bytes if flag is true (only set if size isn't nullptr). The
        return value is 1 for success and 0 otherwise.
        """
        ret = self._wrap_call(self._vtk_obj.Iprobe, *args)
        return ret

    def split_initialize(self, *args):
        """
        split_initialize(self, oldcomm:Communicator, color:int, key:int)
             -> int
        C++: int split_initialize(Communicator *oldcomm, int color,
            int key)
        Used to initialize the communicator (i.e. create the underlying
        MPI_Comm) using MPI_Comm_split on the given communicator. Return
        values are 1 for success and 0 otherwise.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SplitInitialize, *my_args)
        return ret

    _updateable_traits_ = \
    (('use_ssend', 'GetUseSsend'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('number_of_processes', 'GetNumberOfProcesses'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'use_ssend',
    'number_of_processes'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MPICommunicator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MPICommunicator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['use_ssend'], [], ['number_of_processes']),
            title='Edit MPICommunicator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MPICommunicator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

