# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_set_algorithm import DataSetAlgorithm


class mProbe(DataSetAlgorithm):
    r"""
    vtkmProbe - Sample data at specified point locations
    
    Superclass: DataSetAlgorithm
    
    vtkmProbe is a filter that computes point attributes(e.g., scalars,
    vectors, etc.) at specific point positions using the probe filter in
    VTK-m. The filter has two inputs: the Input and Source. The Input
    geometric structure is passed through the filter. The point
    attributes are computed at the Input point positions by interpolating
    into the source data. For example, we can compute data values on a
    plane(plane specified as Input from a volume(Source). The source
    geometry must have cellSet defined otherwise the vtkm filter won't
    work. The cell data of the source data is copied to the output based
    on in which source cell each input point is. If an array of the same
    name exists both in source's point and cell data, only the one from
    the point data is probed. The valid point result is stored as a field
    array whose default name is "vtkvalid_point_mask" in the point data and
    the valid cell result(Invalid cells are the cells with at least one
    invalid point) is stored as a field array whose default name is
    "vtkvalid_cell_mask" in the cell data.
    
    This filter can be used to resample data, or convert one dataset form
    into another. For example, an unstructured grid (vtkunstructured_grid)
    can be probed with a volume (three-dimensional ImageData), and
    then volume rendering techniques can be used to visualize the
    results. Another example: a line or curve can be used to probe data
    to produce x-y plots along that line or curve.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkmProbe, obj, update, **traits)
    
    pass_cell_arrays = tvtk_base.false_bool_trait(desc=\
        r"""
        Shallow copy the input cell data arrays to the output. Off by
        default.
        """
    )

    def _pass_cell_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassCellArrays,
                        self.pass_cell_arrays_)

    pass_field_arrays = tvtk_base.true_bool_trait(desc=\
        r"""
        Set whether to pass the field-data arrays from the Input i.e. the
        input providing the geometry to the output. On by default.
        """
    )

    def _pass_field_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassFieldArrays,
                        self.pass_field_arrays_)

    pass_point_arrays = tvtk_base.false_bool_trait(desc=\
        r"""
        Shallow copy the input point data arrays to the output. Off by
        default.
        """
    )

    def _pass_point_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassPointArrays,
                        self.pass_point_arrays_)

    valid_cell_mask_array_name = traits.String('vtkValidCellMask', enter_set=True, auto_set=False, desc=\
        r"""
        Returns the name of the valid cell array added to the output with
        values 2 for hidden points and 0 for valid points. Set to
        "vtkvalid_cell_mask" by default.
        """
    )

    def _valid_cell_mask_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetValidCellMaskArrayName,
                        self.valid_cell_mask_array_name)

    valid_point_mask_array_name = traits.String('vtkValidPointMask', enter_set=True, auto_set=False, desc=\
        r"""
        Returns the name of the valid point array added to the output
        with values 2 for hidden points and 0 for valid points. Set to
        "vtkvalid_point_mask" by default.
        """
    )

    def _valid_point_mask_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetValidPointMaskArrayName,
                        self.valid_point_mask_array_name)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    def _get_source(self):
        return wrap_vtk(self._vtk_obj.GetSource())
    source = traits.Property(_get_source, desc=\
        r"""
        
        """
    )

    def set_source_connection(self, *args):
        """
        set_source_connection(self, algOutput:AlgorithmOutput) -> None
        C++: void set_source_connection(AlgorithmOutput *algOutput)
        Specify the data set that will be probed at the input points. The
        Input gives the geometry (the points and cells) for the output,
        while the Source is probed (interpolated) to generate the
        scalars, vectors, etc. for the output points based on the point
        locations.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSourceConnection, *my_args)
        return ret

    def set_source_data(self, *args):
        """
        set_source_data(self, source:DataObject) -> None
        C++: void set_source_data(DataObject *source)
        Specify the data set that will be probed at the input points. The
        Input gives the geometry (the points and cells) for the output,
        while the Source is probed (interpolated) to generate the
        scalars, vectors, etc. for the output points based on the point
        locations.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSourceData, *my_args)
        return ret

    _updateable_traits_ = \
    (('pass_cell_arrays', 'GetPassCellArrays'), ('pass_field_arrays',
    'GetPassFieldArrays'), ('pass_point_arrays', 'GetPassPointArrays'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('valid_cell_mask_array_name', 'GetValidCellMaskArrayName'),
    ('valid_point_mask_array_name', 'GetValidPointMaskArrayName'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'pass_cell_arrays', 'pass_field_arrays', 'pass_point_arrays',
    'release_data_flag', 'progress_text', 'valid_cell_mask_array_name',
    'valid_point_mask_array_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(mProbe, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit mProbe properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['pass_cell_arrays', 'pass_field_arrays', 'pass_point_arrays'],
            [], ['valid_cell_mask_array_name', 'valid_point_mask_array_name']),
            title='Edit mProbe properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit mProbe properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

