# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.non_linear_cell import NonLinearCell


class HigherOrderTriangle(NonLinearCell):
    r"""
    HigherOrderTriangle - A 2D cell that represents an arbitrary order
    higher_order triangle
    
    Superclass: NonLinearCell
    
    HigherOrderTriangle is a concrete implementation of Cell to
    represent a 2D triangle using higher_order shape functions of user
    specified order.
    
    The number of points in a higher_order cell determines the order over
    which they are iterated relative to the parametric coordinate system
    of the cell. The first points that are reported are vertices. They
    appear in the same order in which they would appear in linear cells.
    Mid-edge points are reported next. They are reported in sequence. For
    two- and three-dimensional (3D) cells, the following set of points to
    be reported are face points. Finally, 3D cells report points interior
    to their volume.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHigherOrderTriangle, obj, update, **traits)
    
    parametric_coords = traits.Array(enter_set=True, auto_set=False, shape=(9,), dtype="float", value=(nan, nan, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0762617082497645e-289, 0.0), cols=3, desc=\
        r"""
        
        """
    )

    def _parametric_coords_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetParametricCoords,
                        self.parametric_coords)

    def _get_edge_cell(self):
        return wrap_vtk(self._vtk_obj.GetEdgeCell())
    edge_cell = traits.Property(_get_edge_cell, desc=\
        r"""
        
        """
    )

    def _get_order(self):
        return self._vtk_obj.GetOrder()
    order = traits.Property(_get_order, desc=\
        r"""
        
        """
    )

    def barycentric_index(self, *args):
        """
        barycentric_index(index:int, bindex:[int, ...], order:int) -> None
        C++: static void barycentric_index(IdType index,
            IdType *bindex, IdType order)"""
        ret = self._wrap_call(self._vtk_obj.BarycentricIndex, *args)
        return ret

    def compute_order(self):
        """
        compute_order(self) -> int
        C++: IdType compute_order()"""
        ret = self._vtk_obj.ComputeOrder()
        return ret
        

    def deta(self, *args):
        """
        deta(n:int, chi:int, sigma:float) -> float
        C++: static double deta(IdType n, IdType chi, double sigma)"""
        ret = self._wrap_call(self._vtk_obj.Deta, *args)
        return ret

    def eta(self, *args):
        """
        eta(n:int, chi:int, sigma:float) -> float
        C++: static double eta(IdType n, IdType chi, double sigma)"""
        ret = self._wrap_call(self._vtk_obj.Eta, *args)
        return ret

    def index(self, *args):
        """
        index(bindex:(int, ...), order:int) -> int
        C++: static IdType index(const IdType *bindex,
            IdType order)"""
        ret = self._wrap_call(self._vtk_obj.Index, *args)
        return ret

    def to_barycentric_index(self, *args):
        """
        to_barycentric_index(self, index:int, bindex:[int, ...]) -> None
        C++: void to_barycentric_index(IdType index, IdType *bindex)"""
        ret = self._wrap_call(self._vtk_obj.ToBarycentricIndex, *args)
        return ret

    def to_index(self, *args):
        """
        to_index(self, bindex:(int, ...)) -> int
        C++: IdType to_index(const IdType *bindex)"""
        ret = self._wrap_call(self._vtk_obj.ToIndex, *args)
        return ret

    def d_eta(self, *args):
        """
        d_eta(n:int, chi:int, sigma:float) -> float
        C++: static double d_eta(IdType n, IdType chi, double sigma)"""
        ret = self._wrap_call(self._vtk_obj.d_eta, *args)
        return ret

    def eta(self, *args):
        """
        eta(n:int, chi:int, sigma:float) -> float
        C++: static double eta(IdType n, IdType chi, double sigma)"""
        ret = self._wrap_call(self._vtk_obj.eta, *args)
        return ret

    def get_edge_cell(self):
        """
        get_edge_cell(self) -> HigherOrderCurve
        C++: virtual HigherOrderCurve *get_edge_cell()"""
        ret = wrap_vtk(self._vtk_obj.getEdgeCell())
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('parametric_coords',
    'GetParametricCoords'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'parametric_coords'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HigherOrderTriangle, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HigherOrderTriangle properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['parametric_coords']),
            title='Edit HigherOrderTriangle properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HigherOrderTriangle properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

