# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class DataEncoder(Object):
    r"""
    DataEncoder - class used to compress/encode images using threads.
    
    Superclass: Object
    
    DataEncoder is used to compress and encode images using threads.
    Multiple images can be pushed into the encoder for compression and
    encoding. We use a TypeUInt32 as the key to identify different
    image pipes. The images in each pipe will be processed in parallel
    threads. The latest compressed and encoded image can be accessed
    using get_latest_output().
    
    DataEncoder uses a thread-pool to do the compression and encoding
    in parallel.  Note that images may not come out of the DataEncoder
    in the same order as they are pushed in, if an image pushed in at
    N-th location takes longer to compress and encode than that pushed in
    at N+1-th location or if it was pushed in before the N-th location
    was even taken up for encoding by the a thread in the thread pool.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDataEncoder, obj, update, **traits)
    
    def get_latest_output(self, *args):
        """
        get_latest_output(self, key:int,
            data:SmartPointer_I20vtkUnsignedCharArrayE) -> bool
        C++: bool get_latest_output(TypeUInt32 key,
            SmartPointer<vtkUnsignedCharArray> &data)
        Get access to the most-recent fully encoded result corresponding
        to the given key, if any. This methods returns true if the data
        obtained is the result from the most recent Push() for the key,
        if any. If this method returns false, it means that there's some
        image either being processed on pending processing.
        """
        my_args = deref_array(args, [('int', 'vtkSmartPointer_I20vtkUnsignedCharArrayE')])
        ret = self._wrap_call(self._vtk_obj.GetLatestOutput, *my_args)
        return ret

    def _get_max_threads(self):
        return self._vtk_obj.GetMaxThreads()
    max_threads = traits.Property(_get_max_threads, desc=\
        r"""
        
        """
    )

    def encode_as_base64_jpg(self, *args):
        """
        encode_as_base64_jpg(self, img:ImageData, quality:int=50) -> str
        C++: const char *encode_as_base64_jpg(ImageData *img,
            int quality=50)
        Take an image data and synchronously convert it to a base-64
        encoded jpg.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.EncodeAsBase64Jpg, *my_args)
        return ret

    def encode_as_base64_png(self, *args):
        """
        encode_as_base64_png(self, img:ImageData, compressionLevel:int=5)
            -> str
        C++: const char *encode_as_base64_png(ImageData *img,
            int compressionLevel=5)
        Take an image data and synchronously convert it to a base-64
        encoded png.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.EncodeAsBase64Png, *my_args)
        return ret

    def finalize(self):
        """
        finalize(self) -> None
        C++: void finalize()
        This method will wait for any running thread to terminate.
        """
        ret = self._vtk_obj.Finalize()
        return ret
        

    def flush(self, *args):
        """
        flush(self, key:int) -> None
        C++: void flush(TypeUInt32 key)
        Flushes the encoding pipe and blocks till the most recently
        pushed image for the particular key has been processed. This call
        will block. Once this method returns, caller can use
        get_latest_output(key) to access the processed output.
        """
        ret = self._wrap_call(self._vtk_obj.Flush, *args)
        return ret

    def initialize(self):
        """
        initialize(self) -> None
        C++: void initialize()
        Re-initializes the encoder. This will abort any on going encoding
        threads and clear internal data-structures.
        """
        ret = self._vtk_obj.Initialize()
        return ret
        

    def push(self, *args):
        """
        push(self, key:int, data:ImageData, quality:int,
            encoding:int=1) -> None
        C++: void push(TypeUInt32 key, ImageData *data, int quality,
             int encoding=1)
        Push an image into the encoder. The data is considered unchanging
        and thus should not be modified once pushed. Reference count
        changes are now thread safe and hence callers should ensure they
        release the reference held, if appropriate.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Push, *my_args)
        return ret

    def set_max_threads(self, *args):
        """
        set_max_threads(self, __a:int) -> None
        C++: void set_max_threads(TypeUInt32)
        Define the number of worker threads to use. Default is 3.
        Initialize() needs to be called after changing the thread count.
        """
        ret = self._wrap_call(self._vtk_obj.SetMaxThreads, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DataEncoder, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DataEncoder properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit DataEncoder properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DataEncoder properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

