#pragma once

#include "IO.h"

namespace APE
{

#pragma pack(push, 1)

class CWholeFileIO : public CIO
{
public:
    // construction / destruction
    CWholeFileIO(CIO * pSource);
    ~CWholeFileIO();

    // open / close
    int Open(const wchar_t * pName, bool bOpenReadOnly = false);
    int Close();

    // read / write
    int Read(void * pBuffer, unsigned int nBytesToRead, unsigned int * pBytesRead);
    int Write(const void * pBuffer, unsigned int nBytesToWrite, unsigned int * pBytesWritten);

    // seek
    int64 PerformSeek();

    // other functions
    int SetEOF();
    unsigned char * GetBuffer(int *) { return APE_NULL; }

    // creation / destruction
    int Create(const wchar_t * pName);
    int Delete();

    // attributes
    int64 GetPosition();
    int64 GetSize();
    int GetName(wchar_t * pBuffer);

private:

    CSmartPtr<CIO> m_spSource;
    CSmartPtr<unsigned char> m_spWholeFile;
    CSmartPtr<unsigned char> m_spBuffer;
    int m_nOpenResult;
    int64 m_nWholeFilePointer;
    int64 m_nWholeFileSize;
};

#pragma pack(pop)

}
