// D import file generated from 'src/core/sync/rwmutex.d'
module core.sync.rwmutex;
public import core.sync.exception;
import core.sync.condition;
import core.sync.mutex;
import core.memory;
version (Posix)
{
	import core.sys.posix.pthread;
}
class ReadWriteMutex
{
	enum Policy
	{
		PREFER_READERS,
		PREFER_WRITERS,
	}
	nothrow @safe this(Policy policy = Policy.PREFER_WRITERS)
	{
		m_commonMutex = new Mutex;
		if (!m_commonMutex)
			throw new SyncError("Unable to initialize mutex");
		m_readerQueue = new Condition(m_commonMutex);
		if (!m_readerQueue)
			throw new SyncError("Unable to initialize mutex");
		m_writerQueue = new Condition(m_commonMutex);
		if (!m_writerQueue)
			throw new SyncError("Unable to initialize mutex");
		m_policy = policy;
		m_reader = new Reader;
		m_writer = new Writer;
	}
	shared nothrow @safe this(Policy policy = Policy.PREFER_WRITERS)
	{
		m_commonMutex = new shared(Mutex);
		if (!m_commonMutex)
			throw new SyncError("Unable to initialize mutex");
		m_readerQueue = new shared(Condition)(m_commonMutex);
		if (!m_readerQueue)
			throw new SyncError("Unable to initialize mutex");
		m_writerQueue = new shared(Condition)(m_commonMutex);
		if (!m_writerQueue)
			throw new SyncError("Unable to initialize mutex");
		m_policy = policy;
		m_reader = new shared(Reader);
		m_writer = new shared(Writer);
	}
	nothrow @property @safe Policy policy()
	{
		return m_policy;
	}
	shared nothrow @property @safe Policy policy()
	{
		return m_policy;
	}
	nothrow @property @safe Reader reader()
	{
		return m_reader;
	}
	shared nothrow @property @safe shared(Reader) reader()
	{
		return m_reader;
	}
	nothrow @property @safe Writer writer()
	{
		return m_writer;
	}
	shared nothrow @property @safe shared(Writer) writer()
	{
		return m_writer;
	}
	class Reader : Object.Monitor
	{
		nothrow @trusted this(this Q)() if (is(Q == Reader) || is(Q == shared(Reader)))
		{
			m_proxy.link = this;
			this.__monitor = cast(void*)&m_proxy;
		}
		@trusted void lock()
		{
			synchronized(m_commonMutex) {
				++m_numQueuedReaders;
				scope(exit) --m_numQueuedReaders;
				while (shouldQueueReader)
				m_readerQueue.wait();
				++m_numActiveReaders;
			}
		}
		shared @trusted void lock()
		{
			synchronized(m_commonMutex) {
				++(cast()m_numQueuedReaders);
				scope(exit) --(cast()m_numQueuedReaders);
				while (shouldQueueReader)
				m_readerQueue.wait();
				++(cast()m_numActiveReaders);
			}
		}
		@trusted void unlock()
		{
			synchronized(m_commonMutex) {
				if (--m_numActiveReaders < 1)
				{
					if (m_numQueuedWriters > 0)
						m_writerQueue.notify();
				}
			}
		}
		shared @trusted void unlock()
		{
			synchronized(m_commonMutex) {
				if (--(cast()m_numActiveReaders) < 1)
				{
					if (m_numQueuedWriters > 0)
						m_writerQueue.notify();
				}
			}
		}
		@trusted bool tryLock()
		{
			synchronized(m_commonMutex) {
				if (shouldQueueReader)
					return false;
				++m_numActiveReaders;
				return true;
			}
		}
		shared @trusted bool tryLock()
		{
			synchronized(m_commonMutex) {
				if (shouldQueueReader)
					return false;
				++(cast()m_numActiveReaders);
				return true;
			}
		}
		@trusted bool tryLock(Duration timeout)
		{
			synchronized(m_commonMutex) {
				if (!shouldQueueReader)
				{
					++m_numActiveReaders;
					return true;
				}
				enum zero = Duration.zero();
				if (timeout <= zero)
					return false;
				++m_numQueuedReaders;
				scope(exit) --m_numQueuedReaders;
				enum maxWaitPerCall = dur!"hours"(24 * 365);
				const initialTime = MonoTime.currTime;
				m_readerQueue.wait(timeout < maxWaitPerCall ? timeout : maxWaitPerCall);
				while (shouldQueueReader)
				{
					const timeElapsed = MonoTime.currTime - initialTime;
					if (timeElapsed >= timeout)
						return false;
					auto nextWait = timeout - timeElapsed;
					m_readerQueue.wait(nextWait < maxWaitPerCall ? nextWait : maxWaitPerCall);
				}
				++m_numActiveReaders;
				return true;
			}
		}
		shared @trusted bool tryLock(Duration timeout)
		{
			const initialTime = MonoTime.currTime;
			synchronized(m_commonMutex) {
				++(cast()m_numQueuedReaders);
				scope(exit) --(cast()m_numQueuedReaders);
				while (shouldQueueReader)
				{
					const timeElapsed = MonoTime.currTime - initialTime;
					if (timeElapsed >= timeout)
						return false;
					auto nextWait = timeout - timeElapsed;
					enum maxWaitPerCall = dur!"hours"(24 * 365);
					m_readerQueue.wait(nextWait < maxWaitPerCall ? nextWait : maxWaitPerCall);
				}
				++(cast()m_numActiveReaders);
				return true;
			}
		}
		private
		{
			nothrow @nogc @property @safe bool shouldQueueReader(this Q)() if (is(Q == Reader) || is(Q == shared(Reader)))
			{
				if (m_numActiveWriters > 0)
					return true;
				switch (m_policy)
				{
					case Policy.PREFER_WRITERS:
					{
						return m_numQueuedWriters > 0;
					}
					case Policy.PREFER_READERS:
					{
					}
					default:
					{
						break;
					}
				}
				return false;
			}
			struct MonitorProxy
			{
				Object.Monitor link;
			}
			MonitorProxy m_proxy;
		}
	}
	class Writer : Object.Monitor
	{
		nothrow @trusted this(this Q)() if (is(Q == Writer) || is(Q == shared(Writer)))
		{
			m_proxy.link = this;
			this.__monitor = cast(void*)&m_proxy;
		}
		@trusted void lock()
		{
			synchronized(m_commonMutex) {
				++m_numQueuedWriters;
				scope(exit) --m_numQueuedWriters;
				while (shouldQueueWriter)
				m_writerQueue.wait();
				++m_numActiveWriters;
			}
		}
		shared @trusted void lock()
		{
			synchronized(m_commonMutex) {
				++(cast()m_numQueuedWriters);
				scope(exit) --(cast()m_numQueuedWriters);
				while (shouldQueueWriter)
				m_writerQueue.wait();
				++(cast()m_numActiveWriters);
			}
		}
		@trusted void unlock()
		{
			synchronized(m_commonMutex) {
				if (--m_numActiveWriters < 1)
				{
					switch (m_policy)
					{
						default:
						{
						}
						case Policy.PREFER_READERS:
						{
							if (m_numQueuedReaders > 0)
								m_readerQueue.notifyAll();
							else if (m_numQueuedWriters > 0)
								m_writerQueue.notify();
							break;
						}
						case Policy.PREFER_WRITERS:
						{
							if (m_numQueuedWriters > 0)
								m_writerQueue.notify();
							else if (m_numQueuedReaders > 0)
								m_readerQueue.notifyAll();
						}
					}
				}
			}
		}
		shared @trusted void unlock()
		{
			synchronized(m_commonMutex) {
				if (--(cast()m_numActiveWriters) < 1)
				{
					switch (m_policy)
					{
						default:
						{
						}
						case Policy.PREFER_READERS:
						{
							if (m_numQueuedReaders > 0)
								m_readerQueue.notifyAll();
							else if (m_numQueuedWriters > 0)
								m_writerQueue.notify();
							break;
						}
						case Policy.PREFER_WRITERS:
						{
							if (m_numQueuedWriters > 0)
								m_writerQueue.notify();
							else if (m_numQueuedReaders > 0)
								m_readerQueue.notifyAll();
						}
					}
				}
			}
		}
		@trusted bool tryLock()
		{
			synchronized(m_commonMutex) {
				if (shouldQueueWriter)
					return false;
				++m_numActiveWriters;
				return true;
			}
		}
		shared @trusted bool tryLock()
		{
			synchronized(m_commonMutex) {
				if (shouldQueueWriter)
					return false;
				++(cast()m_numActiveWriters);
				return true;
			}
		}
		@trusted bool tryLock(Duration timeout)
		{
			synchronized(m_commonMutex) {
				if (!shouldQueueWriter)
				{
					++m_numActiveWriters;
					return true;
				}
				enum zero = Duration.zero();
				if (timeout <= zero)
					return false;
				++m_numQueuedWriters;
				scope(exit) --m_numQueuedWriters;
				enum maxWaitPerCall = dur!"hours"(24 * 365);
				const initialTime = MonoTime.currTime;
				m_writerQueue.wait(timeout < maxWaitPerCall ? timeout : maxWaitPerCall);
				while (shouldQueueWriter)
				{
					const timeElapsed = MonoTime.currTime - initialTime;
					if (timeElapsed >= timeout)
						return false;
					auto nextWait = timeout - timeElapsed;
					m_writerQueue.wait(nextWait < maxWaitPerCall ? nextWait : maxWaitPerCall);
				}
				++m_numActiveWriters;
				return true;
			}
		}
		shared @trusted bool tryLock(Duration timeout)
		{
			const initialTime = MonoTime.currTime;
			synchronized(m_commonMutex) {
				++(cast()m_numQueuedWriters);
				scope(exit) --(cast()m_numQueuedWriters);
				while (shouldQueueWriter)
				{
					const timeElapsed = MonoTime.currTime - initialTime;
					if (timeElapsed >= timeout)
						return false;
					auto nextWait = timeout - timeElapsed;
					enum maxWaitPerCall = dur!"hours"(24 * 365);
					m_writerQueue.wait(nextWait < maxWaitPerCall ? nextWait : maxWaitPerCall);
				}
				++(cast()m_numActiveWriters);
				return true;
			}
		}
		private
		{
			@property bool shouldQueueWriter(this Q)() if (is(Q == Writer) || is(Q == shared(Writer)))
			{
				if (m_numActiveWriters > 0 || m_numActiveReaders > 0)
					return true;
				switch (m_policy)
				{
					case Policy.PREFER_READERS:
					{
						return m_numQueuedReaders > 0;
					}
					case Policy.PREFER_WRITERS:
					{
					}
					default:
					{
						break;
					}
				}
				return false;
			}
			struct MonitorProxy
			{
				Object.Monitor link;
			}
			MonitorProxy m_proxy;
		}
	}
	private
	{
		Policy m_policy;
		Reader m_reader;
		Writer m_writer;
		Mutex m_commonMutex;
		Condition m_readerQueue;
		Condition m_writerQueue;
		int m_numQueuedReaders;
		int m_numActiveReaders;
		int m_numQueuedWriters;
		int m_numActiveWriters;
	}
}
