/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util;

import java.io.IOException;
import java.security.Key;
import org.keycloak.jose.jwe.JWE;
import org.keycloak.jose.jwe.JWEException;
import org.keycloak.jose.jwe.JWEHeader;
import org.keycloak.jose.jwe.JWEKeyStorage;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.enc.JWEEncryptionProvider;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.util.JsonSerialization;

public class TokenUtil {
    public static final String TOKEN_TYPE_BEARER = "Bearer";
    public static final String TOKEN_TYPE_KEYCLOAK_ID = "Serialized-ID";
    public static final String TOKEN_TYPE_ID = "ID";
    public static final String TOKEN_TYPE_REFRESH = "Refresh";
    public static final String TOKEN_TYPE_OFFLINE = "Offline";
    public static final String TOKEN_TYPE_LOGOUT = "Logout";
    public static final String TOKEN_BACKCHANNEL_LOGOUT_EVENT = "http://schemas.openid.net/event/backchannel-logout";
    public static final String TOKEN_BACKCHANNEL_LOGOUT_EVENT_REVOKE_OFFLINE_TOKENS = "revoke_offline_access";

    public static String attachOIDCScope(String scopeParam) {
        if (scopeParam == null || scopeParam.isEmpty()) {
            return "openid";
        }
        if (TokenUtil.hasScope(scopeParam, "openid")) {
            return scopeParam;
        }
        return "openid " + scopeParam;
    }

    public static boolean isOIDCRequest(String scopeParam) {
        return TokenUtil.hasScope(scopeParam, "openid");
    }

    public static boolean isOfflineTokenRequested(String scopeParam) {
        return TokenUtil.hasScope(scopeParam, "offline_access");
    }

    public static boolean hasScope(String scopeParam, String targetScope) {
        String[] scopes;
        if (scopeParam == null || targetScope == null) {
            return false;
        }
        for (String scope : scopes = scopeParam.split(" ")) {
            if (!targetScope.equals(scope)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPrompt(String promptParam, String targetPrompt) {
        String[] prompts;
        if (promptParam == null || targetPrompt == null) {
            return false;
        }
        for (String prompt : prompts = promptParam.split(" ")) {
            if (!targetPrompt.equals(prompt)) continue;
            return true;
        }
        return false;
    }

    public static RefreshToken getRefreshToken(byte[] decodedToken) throws JWSInputException {
        try {
            return JsonSerialization.readValue(decodedToken, RefreshToken.class);
        }
        catch (IOException e) {
            throw new JWSInputException(e);
        }
    }

    public static RefreshToken getRefreshToken(String refreshToken) throws JWSInputException {
        byte[] encodedContent = new JWSInput(refreshToken).getContent();
        return TokenUtil.getRefreshToken(encodedContent);
    }

    public static boolean isOfflineToken(String refreshToken) throws JWSInputException {
        RefreshToken token = TokenUtil.getRefreshToken(refreshToken);
        return token.getType().equals(TOKEN_TYPE_OFFLINE);
    }

    public static String jweDirectEncode(Key aesKey, Key hmacKey, JsonWebToken jwt) throws JWEException {
        try {
            byte[] contentBytes = JsonSerialization.writeValueAsBytes(jwt);
            return TokenUtil.jweDirectEncode(aesKey, hmacKey, contentBytes);
        }
        catch (IOException ioe) {
            throw new JWEException((Throwable)ioe);
        }
    }

    public static <T extends JsonWebToken> T jweDirectVerifyAndDecode(Key aesKey, Key hmacKey, String jweStr, Class<T> expectedClass) throws JWEException {
        byte[] contentBytes = TokenUtil.jweDirectVerifyAndDecode(aesKey, hmacKey, jweStr);
        try {
            return (T)((JsonWebToken)JsonSerialization.readValue(contentBytes, expectedClass));
        }
        catch (IOException ioe) {
            throw new JWEException((Throwable)ioe);
        }
    }

    public static String jweKeyEncryptionEncode(Key encryptionKEK, byte[] contentBytes, String algAlgorithm, String encAlgorithm, String kid, JWEAlgorithmProvider jweAlgorithmProvider, JWEEncryptionProvider jweEncryptionProvider) throws JWEException {
        return TokenUtil.jweKeyEncryptionEncode(encryptionKEK, contentBytes, algAlgorithm, encAlgorithm, kid, jweAlgorithmProvider, jweEncryptionProvider, "JWT");
    }

    public static String jweKeyEncryptionEncode(Key encryptionKEK, byte[] contentBytes, String algAlgorithm, String encAlgorithm, String kid, JWEAlgorithmProvider jweAlgorithmProvider, JWEEncryptionProvider jweEncryptionProvider, String jweContentType) throws JWEException {
        JWEHeader jweHeader = new JWEHeader(algAlgorithm, encAlgorithm, null, kid, jweContentType);
        return TokenUtil.jweKeyEncryptionEncode(encryptionKEK, contentBytes, jweHeader, jweAlgorithmProvider, jweEncryptionProvider);
    }

    private static String jweKeyEncryptionEncode(Key encryptionKEK, byte[] contentBytes, JWEHeader jweHeader, JWEAlgorithmProvider jweAlgorithmProvider, JWEEncryptionProvider jweEncryptionProvider) throws JWEException {
        JWE jwe = new JWE().header(jweHeader).content(contentBytes);
        jwe.getKeyStorage().setEncryptionKey(encryptionKEK);
        String encodedContent = jwe.encodeJwe(jweAlgorithmProvider, jweEncryptionProvider);
        return encodedContent;
    }

    public static byte[] jweKeyEncryptionVerifyAndDecode(Key decryptionKEK, String encodedContent) throws JWEException {
        JWE jwe = new JWE();
        jwe.getKeyStorage().setDecryptionKey(decryptionKEK);
        jwe.verifyAndDecodeJwe(encodedContent);
        return jwe.getContent();
    }

    public static byte[] jweKeyEncryptionVerifyAndDecode(Key decryptionKEK, String encodedContent, JWEAlgorithmProvider algorithmProvider, JWEEncryptionProvider encryptionProvider) throws JWEException {
        JWE jwe = new JWE();
        jwe.getKeyStorage().setDecryptionKey(decryptionKEK);
        jwe.verifyAndDecodeJwe(encodedContent, algorithmProvider, encryptionProvider);
        return jwe.getContent();
    }

    public static String jweDirectEncode(Key aesKey, Key hmacKey, byte[] contentBytes) throws JWEException {
        String encAlgorithm;
        int keyLength = aesKey.getEncoded().length;
        switch (keyLength) {
            case 16: {
                encAlgorithm = "A128CBC-HS256";
                break;
            }
            case 24: {
                encAlgorithm = "A192CBC-HS384";
                break;
            }
            case 32: {
                encAlgorithm = "A256CBC-HS512";
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad size for Encryption key: " + aesKey + ". Valid sizes are 16, 24, 32.");
            }
        }
        JWEHeader jweHeader = new JWEHeader("dir", encAlgorithm, null);
        JWE jwe = new JWE().header(jweHeader).content(contentBytes);
        jwe.getKeyStorage().setCEKKey(aesKey, JWEKeyStorage.KeyUse.ENCRYPTION).setCEKKey(hmacKey, JWEKeyStorage.KeyUse.SIGNATURE);
        return jwe.encodeJwe();
    }

    public static byte[] jweDirectVerifyAndDecode(Key aesKey, Key hmacKey, String jweStr) throws JWEException {
        JWE jwe = new JWE();
        jwe.getKeyStorage().setCEKKey(aesKey, JWEKeyStorage.KeyUse.ENCRYPTION).setCEKKey(hmacKey, JWEKeyStorage.KeyUse.SIGNATURE);
        jwe.verifyAndDecodeJwe(jweStr);
        return jwe.getContent();
    }
}

