/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.role;

import java.util.Objects;
import java.util.Set;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoDocs;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.models.map.annotations.IgnoreForEntityImplementationGenerator;
import org.keycloak.models.map.role.MapRoleEntity;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.CommonPrimitivesProtoSchemaInitializer;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntityNonIndexed;
import org.keycloak.models.map.storage.hotRod.common.UpdatableHotRodEntityDelegateImpl;
import org.keycloak.models.map.storage.hotRod.role.HotRodRoleEntityDelegate;
import org.keycloak.models.map.storage.hotRod.role.HotRodRoleEntitySchemaImpl;

@ProtoDocs(value={@ProtoDoc(value="@Indexed"), @ProtoDoc(value="schema-version: 1")})
public class HotRodRoleEntity
extends AbstractHotRodEntity {
    @IgnoreForEntityImplementationGenerator
    public static final int VERSION = 1;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=1)
    public Integer entityVersion = 1;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=2)
    public String id;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=3)
    public String realmId;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=4)
    public String name;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=5)
    public String nameLowercase;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES, analyze = Analyze.YES, analyzer = @Analyzer(definition = \"filename\"))")
    @ProtoField(number=6)
    public String description;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=7)
    public Boolean clientRole;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=8)
    public String clientId;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=9)
    public Set<String> compositeRoles;
    @ProtoField(number=10)
    public Set<HotRodAttributeEntityNonIndexed> attributes;

    public boolean equals(Object o) {
        return HotRodRoleEntityDelegate.entityEquals(this, o);
    }

    public int hashCode() {
        return HotRodRoleEntityDelegate.entityHashCode(this);
    }

    public static abstract class AbstractHotRodRoleEntityDelegate
    extends UpdatableHotRodEntityDelegateImpl<HotRodRoleEntity>
    implements MapRoleEntity {
        public String getId() {
            return ((HotRodRoleEntity)this.getHotRodEntity()).id;
        }

        public void setId(String id) {
            HotRodRoleEntity entity = (HotRodRoleEntity)this.getHotRodEntity();
            if (entity.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            entity.id = id;
            entity.updated = entity.updated | id != null;
        }

        public void setName(String name) {
            HotRodRoleEntity entity = (HotRodRoleEntity)this.getHotRodEntity();
            entity.updated = entity.updated | !Objects.equals(entity.name, name);
            entity.name = name;
            entity.nameLowercase = name == null ? null : name.toLowerCase();
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={HotRodRoleEntity.class}, schemaFilePath="proto/", schemaPackageName="kc", dependsOn={CommonPrimitivesProtoSchemaInitializer.class})
    public static interface HotRodRoleEntitySchema
    extends GeneratedSchema {
        public static final HotRodRoleEntitySchema INSTANCE = new HotRodRoleEntitySchemaImpl();
    }
}

