/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.user;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialAuthentication;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialProviderFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SubjectCredentialManager;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.map.credential.MapUserCredentialManager;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapKeycloakTransactionWithAuth;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.models.map.user.MapCredentialValidationOutput;
import org.keycloak.models.map.user.MapUserAdapter;
import org.keycloak.models.map.user.MapUserConsentEntity;
import org.keycloak.models.map.user.MapUserEntity;
import org.keycloak.models.map.user.MapUserEntityImpl;
import org.keycloak.models.map.user.MapUserFederatedIdentityEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.InvalidationHandler;

public class MapUserProvider
implements UserProvider.Streams {
    private static final Logger LOG = Logger.getLogger(MapUserProvider.class);
    private final KeycloakSession session;
    final MapKeycloakTransaction<MapUserEntity, UserModel> tx;

    public MapUserProvider(KeycloakSession session, MapStorage<MapUserEntity, UserModel> store) {
        this.session = session;
        this.tx = store.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private Function<MapUserEntity, UserModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapUserAdapter(this.session, realm, (MapUserEntity)origEntity){

            @Override
            public boolean checkEmailUniqueness(RealmModel realm, String email) {
                return MapUserProvider.this.getUserByEmail(realm, email) != null;
            }

            @Override
            public boolean checkUsernameUniqueness(RealmModel realm, String username) {
                return MapUserProvider.this.getUserByUsername(realm, username) != null;
            }

            public SubjectCredentialManager credentialManager() {
                return new MapUserCredentialManager(this.session, this.realm, (UserModel)this, (MapUserEntity)this.entity);
            }
        };
    }

    private Predicate<MapUserEntity> entityRealmFilter(RealmModel realm) {
        if (realm == null || realm.getId() == null) {
            return c -> false;
        }
        String realmId = realm.getId();
        return entity -> entity.getRealmId() == null || Objects.equals(realmId, entity.getRealmId());
    }

    private ModelException userDoesntExistException() {
        return new ModelException("Specified user doesn't exist.");
    }

    private Optional<MapUserEntity> getEntityById(RealmModel realm, String id) {
        try {
            MapUserEntity mapUserEntity = this.tx.read(id);
            if (mapUserEntity != null && this.entityRealmFilter(realm).test(mapUserEntity)) {
                return Optional.of(mapUserEntity);
            }
            return Optional.empty();
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    private MapUserEntity getEntityByIdOrThrow(RealmModel realm, String id) {
        return this.getEntityById(realm, id).orElseThrow(this::userDoesntExistException);
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel socialLink) {
        if (user == null || user.getId() == null) {
            return;
        }
        LOG.tracef("addFederatedIdentity(%s, %s, %s)%s", new Object[]{realm, user.getId(), socialLink.getIdentityProvider(), StackUtil.getShortStackTrace()});
        this.getEntityById(realm, user.getId()).ifPresent(userEntity -> userEntity.addFederatedIdentity(MapUserFederatedIdentityEntity.fromModel(socialLink)));
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        LOG.tracef("removeFederatedIdentity(%s, %s, %s)%s", new Object[]{realm, user.getId(), socialProvider, StackUtil.getShortStackTrace()});
        Optional<MapUserEntity> entityById = this.getEntityById(realm, user.getId());
        if (!entityById.isPresent()) {
            return false;
        }
        Boolean result = entityById.get().removeFederatedIdentity(socialProvider);
        return result == null ? true : result;
    }

    public void preRemove(RealmModel realm, IdentityProviderModel provider) {
        String socialProvider = provider.getAlias();
        LOG.tracef("preRemove[RealmModel realm, IdentityProviderModel provider](%s, %s)%s", (Object)realm, (Object)socialProvider, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserModel.SearchableFields.IDP_AND_USER, ModelCriteriaBuilder.Operator.EQ, new Object[]{socialProvider});
        this.tx.read(QueryParameters.withCriteria(mcb)).forEach(userEntity -> userEntity.removeFederatedIdentity(socialProvider));
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        LOG.tracef("updateFederatedIdentity(%s, %s, %s)%s", new Object[]{realm, federatedUser.getId(), federatedIdentityModel.getIdentityProvider(), StackUtil.getShortStackTrace()});
        this.getEntityById(realm, federatedUser.getId()).flatMap(u -> u.getFederatedIdentity(federatedIdentityModel.getIdentityProvider())).ifPresent(fi -> {
            fi.setUserId(federatedIdentityModel.getUserId());
            fi.setUserName(federatedIdentityModel.getUserName());
            fi.setToken(federatedIdentityModel.getToken());
        });
    }

    public Stream<FederatedIdentityModel> getFederatedIdentitiesStream(RealmModel realm, UserModel user) {
        LOG.tracef("getFederatedIdentitiesStream(%s, %s)%s", (Object)realm, (Object)user.getId(), StackUtil.getShortStackTrace());
        return this.getEntityById(realm, user.getId()).map(MapUserEntity::getFederatedIdentities).map(Collection::stream).orElseGet(Stream::empty).map(MapUserFederatedIdentityEntity::toModel);
    }

    public FederatedIdentityModel getFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        LOG.tracef("getFederatedIdentity(%s, %s, %s)%s", new Object[]{realm, user.getId(), socialProvider, StackUtil.getShortStackTrace()});
        return this.getEntityById(realm, user.getId()).flatMap(userEntity -> userEntity.getFederatedIdentity(socialProvider)).map(MapUserFederatedIdentityEntity::toModel).orElse(null);
    }

    public UserModel getUserByFederatedIdentity(RealmModel realm, FederatedIdentityModel socialLink) {
        LOG.tracef("getUserByFederatedIdentity(%s, %s)%s", (Object)realm, (Object)socialLink, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserModel.SearchableFields.IDP_AND_USER, ModelCriteriaBuilder.Operator.EQ, new Object[]{socialLink.getIdentityProvider(), socialLink.getUserId()});
        return this.tx.read(QueryParameters.withCriteria(mcb)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() != 1) {
                throw new IllegalStateException("More results found for identityProvider=" + socialLink.getIdentityProvider() + ", userId=" + socialLink.getUserId() + ", results=" + list);
            }
            return this.entityToAdapterFunc(realm).apply((MapUserEntity)list.get(0));
        }));
    }

    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        LOG.tracef("addConsent(%s, %s, %s)%s", new Object[]{realm, userId, consent, StackUtil.getShortStackTrace()});
        this.getEntityByIdOrThrow(realm, userId).addUserConsent(MapUserConsentEntity.fromModel(consent));
    }

    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientInternalId) {
        LOG.tracef("getConsentByClient(%s, %s, %s)%s", new Object[]{realm, userId, clientInternalId, StackUtil.getShortStackTrace()});
        return this.getEntityById(realm, userId).flatMap(userEntity -> userEntity.getUserConsent(clientInternalId)).map(consent -> MapUserConsentEntity.toModel(realm, consent)).orElse(null);
    }

    public Stream<UserConsentModel> getConsentsStream(RealmModel realm, String userId) {
        LOG.tracef("getConsentByClientStream(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        return this.getEntityById(realm, userId).map(MapUserEntity::getUserConsents).map(Collection::stream).orElseGet(Stream::empty).map(consent -> MapUserConsentEntity.toModel(realm, consent));
    }

    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        LOG.tracef("updateConsent(%s, %s, %s)%s", new Object[]{realm, userId, consent, StackUtil.getShortStackTrace()});
        MapUserEntity user = this.getEntityByIdOrThrow(realm, userId);
        MapUserConsentEntity userConsentEntity = user.getUserConsent(consent.getClient().getId()).orElseThrow(() -> new ModelException("Consent not found for client [" + consent.getClient().getId() + "] and user [" + userId + "]"));
        userConsentEntity.setGrantedClientScopesIds(consent.getGrantedClientScopes().stream().map(ClientScopeModel::getId).collect(Collectors.toSet()));
        userConsentEntity.setLastUpdatedDate(Time.currentTimeMillis());
    }

    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientInternalId) {
        LOG.tracef("revokeConsentForClient(%s, %s, %s)%s", new Object[]{realm, userId, clientInternalId, StackUtil.getShortStackTrace()});
        Optional<MapUserEntity> entityById = this.getEntityById(realm, userId);
        if (!entityById.isPresent()) {
            return false;
        }
        Boolean result = entityById.get().removeUserConsent(clientInternalId);
        return result == null ? true : result;
    }

    public void setNotBeforeForUser(RealmModel realm, UserModel user, int notBefore) {
        LOG.tracef("setNotBeforeForUser(%s, %s, %d)%s", new Object[]{realm, user.getId(), notBefore, StackUtil.getShortStackTrace()});
        this.getEntityByIdOrThrow(realm, user.getId()).setNotBefore(TimeAdapter.fromIntegerWithTimeInSecondsToLongWithTimeAsInSeconds(notBefore));
    }

    public int getNotBeforeOfUser(RealmModel realm, UserModel user) {
        LOG.tracef("getNotBeforeOfUser(%s, %s)%s", (Object)realm, (Object)user.getId(), StackUtil.getShortStackTrace());
        Long notBefore = this.getEntityById(realm, user.getId()).orElseThrow(this::userDoesntExistException).getNotBefore();
        return notBefore == null ? 0 : TimeAdapter.fromLongWithTimeInSecondsToIntegerWithTimeInSeconds(notBefore);
    }

    public UserModel getServiceAccount(ClientModel client) {
        LOG.tracef("getServiceAccount(%s)%s", (Object)client.getId(), StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getRealm().getId()})).compare(UserModel.SearchableFields.SERVICE_ACCOUNT_CLIENT, ModelCriteriaBuilder.Operator.EQ, new Object[]{client.getId()});
        return this.tx.read(QueryParameters.withCriteria(mcb)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() != 1) {
                throw new IllegalStateException("More service account linked users found for client=" + client.getClientId() + ", results=" + list);
            }
            return this.entityToAdapterFunc(client.getRealm()).apply((MapUserEntity)list.get(0));
        }));
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        LOG.tracef("addUser(%s, %s, %s, %s, %s)%s", new Object[]{realm, id, username, addDefaultRoles, addDefaultRequiredActions, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserModel.SearchableFields.USERNAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{username});
        if (this.tx.getCount(QueryParameters.withCriteria(mcb)) > 0L) {
            throw new ModelDuplicateException("User with username '" + username + "' in realm " + realm.getName() + " already exists");
        }
        if (id != null && this.tx.read(id) != null) {
            throw new ModelDuplicateException("User exists: " + id);
        }
        MapUserEntity entity = new MapUserEntityImpl();
        entity.setId(id);
        entity.setRealmId(realm.getId());
        entity.setEmailConstraint(KeycloakModelUtils.generateId());
        entity.setUsername(username.toLowerCase());
        entity.setCreatedTimestamp(Time.currentTimeMillis());
        entity = this.tx.create(entity);
        UserModel userModel = this.entityToAdapterFunc(realm).apply(entity);
        if (addDefaultRoles) {
            userModel.grantRole(realm.getDefaultRole());
            realm.getDefaultGroupsStream().forEach(arg_0 -> ((UserModel)userModel).joinGroup(arg_0));
        }
        if (addDefaultRequiredActions) {
            realm.getRequiredActionProvidersStream().filter(RequiredActionProviderModel::isEnabled).filter(RequiredActionProviderModel::isDefaultAction).map(RequiredActionProviderModel::getAlias).forEach(arg_0 -> ((UserModel)userModel).addRequiredAction(arg_0));
        }
        return userModel;
    }

    public void preRemove(RealmModel realm) {
        LOG.tracef("preRemove[RealmModel](%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        this.tx.delete(QueryParameters.withCriteria(mcb));
    }

    public void removeImportedUsers(RealmModel realm, String storageProviderId) {
        LOG.tracef("removeImportedUsers(%s, %s)%s", (Object)realm, (Object)storageProviderId, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserModel.SearchableFields.FEDERATION_LINK, ModelCriteriaBuilder.Operator.EQ, new Object[]{storageProviderId});
        this.tx.delete(QueryParameters.withCriteria(mcb));
    }

    public void unlinkUsers(RealmModel realm, String storageProviderId) {
        LOG.tracef("unlinkUsers(%s, %s)%s", (Object)realm, (Object)storageProviderId, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserModel.SearchableFields.FEDERATION_LINK, ModelCriteriaBuilder.Operator.EQ, new Object[]{storageProviderId});
        try (Stream<MapUserEntity> s = this.tx.read(QueryParameters.withCriteria(mcb));){
            s.forEach(userEntity -> userEntity.setFederationLink(null));
        }
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        String roleId = role.getId();
        LOG.tracef("preRemove[RoleModel](%s, %s)%s", (Object)realm, (Object)roleId, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserModel.SearchableFields.ASSIGNED_ROLE, ModelCriteriaBuilder.Operator.EQ, new Object[]{roleId});
        try (Stream<MapUserEntity> s = this.tx.read(QueryParameters.withCriteria(mcb));){
            s.forEach(userEntity -> userEntity.removeRolesMembership(roleId));
        }
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        String groupId = group.getId();
        LOG.tracef("preRemove[GroupModel](%s, %s)%s", (Object)realm, (Object)groupId, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserModel.SearchableFields.ASSIGNED_GROUP, ModelCriteriaBuilder.Operator.EQ, new Object[]{groupId});
        try (Stream<MapUserEntity> s = this.tx.read(QueryParameters.withCriteria(mcb));){
            s.forEach(userEntity -> userEntity.removeGroupsMembership(groupId));
        }
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        String clientId = client.getId();
        LOG.tracef("preRemove[ClientModel](%s, %s)%s", (Object)realm, (Object)clientId, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserModel.SearchableFields.CONSENT_FOR_CLIENT, ModelCriteriaBuilder.Operator.EQ, new Object[]{clientId});
        try (Stream<MapUserEntity> s = this.tx.read(QueryParameters.withCriteria(mcb));){
            s.forEach(userEntity -> userEntity.removeUserConsent(clientId));
        }
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
    }

    public void preRemove(ClientScopeModel clientScope) {
        String clientScopeId = clientScope.getId();
        LOG.tracef("preRemove[ClientScopeModel](%s)%s", (Object)clientScopeId, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{clientScope.getRealm().getId()})).compare(UserModel.SearchableFields.CONSENT_WITH_CLIENT_SCOPE, ModelCriteriaBuilder.Operator.EQ, new Object[]{clientScopeId});
        try (Stream<MapUserEntity> s = this.tx.read(QueryParameters.withCriteria(mcb));){
            s.map(MapUserEntity::getUserConsents).filter(Objects::nonNull).flatMap(Collection::stream).forEach(consent -> consent.removeGrantedClientScopesId(clientScopeId));
        }
    }

    public void preRemove(RealmModel realm, ComponentModel component) {
    }

    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        String roleId = role.getId();
        LOG.tracef("grantToAllUsers(%s, %s)%s", (Object)realm, (Object)roleId, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        try (Stream<MapUserEntity> s = this.tx.read(QueryParameters.withCriteria(mcb));){
            s.forEach(entity -> entity.addRolesMembership(roleId));
        }
    }

    public UserModel getUserById(RealmModel realm, String id) {
        LOG.tracef("getUserById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        return this.getEntityById(realm, id).map(this.entityToAdapterFunc(realm)).orElse(null);
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        if (username == null) {
            return null;
        }
        LOG.tracef("getUserByUsername(%s, %s)%s", (Object)realm, (Object)username, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserModel.SearchableFields.USERNAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{username});
        try (Stream<MapUserEntity> s = this.tx.read(QueryParameters.withCriteria(mcb));){
            UserModel userModel = s.findFirst().map(this.entityToAdapterFunc(realm)).orElse(null);
            return userModel;
        }
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        LOG.tracef("getUserByEmail(%s, %s)%s", (Object)realm, (Object)email, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserModel.SearchableFields.EMAIL, ModelCriteriaBuilder.Operator.EQ, new Object[]{email});
        List usersWithEmail = this.tx.read(QueryParameters.withCriteria(mcb)).filter(userEntity -> Objects.equals(userEntity.getEmail(), email)).collect(Collectors.toList());
        if (usersWithEmail.isEmpty()) {
            return null;
        }
        if (usersWithEmail.size() > 1) {
            throw new ModelDuplicateException("Multiple users with email '" + email + "' exist in Keycloak.");
        }
        MapUserEntity userEntity2 = (MapUserEntity)usersWithEmail.get(0);
        if (!realm.isDuplicateEmailsAllowed() && userEntity2.getEmail() != null && !userEntity2.getEmail().equals(userEntity2.getEmailConstraint())) {
            userEntity2.setEmailConstraint(userEntity2.getEmail());
        }
        return this.entityToAdapterFunc(realm).apply(userEntity2);
    }

    public int getUsersCount(RealmModel realm, boolean includeServiceAccount) {
        LOG.tracef("getUsersCount(%s, %s)%s", (Object)realm, (Object)includeServiceAccount, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb).compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        if (!includeServiceAccount) {
            mcb = ((DefaultModelCriteria)mcb).compare(UserModel.SearchableFields.SERVICE_ACCOUNT_CLIENT, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
        }
        return (int)this.tx.getCount(QueryParameters.withCriteria(mcb));
    }

    public Stream<UserModel> getUsersStream(RealmModel realm, Integer firstResult, Integer maxResults, boolean includeServiceAccounts) {
        LOG.tracef("getUsersStream(%s, %d, %d, %s)%s", new Object[]{realm, firstResult, maxResults, includeServiceAccounts, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb).compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        if (!includeServiceAccounts) {
            mcb = ((DefaultModelCriteria)mcb).compare(UserModel.SearchableFields.SERVICE_ACCOUNT_CLIENT, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
        }
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResults, UserModel.SearchableFields.USERNAME)).map(this.entityToAdapterFunc(realm));
    }

    public Stream<UserModel> getUsersStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        LOG.tracef("getUsersStream(%s, %d, %d)%s", new Object[]{realm, firstResult, maxResults, StackUtil.getShortStackTrace()});
        return this.getUsersStream(realm, firstResult, maxResults, false);
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        LOG.tracef("searchForUserStream(%s, %s, %d, %d)%s", new Object[]{realm, search, firstResult, maxResults, StackUtil.getShortStackTrace()});
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("keycloak.session.realm.users.query.search", search);
        this.session.setAttribute("keycloak.session.realm.users.query.include_service_account", (Object)false);
        return this.searchForUserStream(realm, attributes, firstResult, maxResults);
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        LOG.tracef("searchForUserStream(%s, %s, %d, %d)%s", new Object[]{realm, attributes, firstResult, maxResults, StackUtil.getShortStackTrace()});
        DefaultModelCriteria<UserModel> mcb = DefaultModelCriteria.criteria();
        DefaultModelCriteria<UserModel> criteria = mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        if (!((Boolean)this.session.getAttributeOrDefault("keycloak.session.realm.users.query.include_service_account", (Object)true)).booleanValue()) {
            criteria = criteria.compare(UserModel.SearchableFields.SERVICE_ACCOUNT_CLIENT, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
        }
        boolean exactSearch = Boolean.parseBoolean(attributes.getOrDefault("keycloak.session.realm.users.query.exact", Boolean.FALSE.toString()));
        block24: for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            value = value.trim();
            String searchedString = exactSearch ? value : "%" + value + "%";
            switch (key) {
                case "keycloak.session.realm.users.query.search": {
                    DefaultModelCriteria<UserModel> searchCriteria = null;
                    for (String stringToSearch : value.split("\\s+")) {
                        searchCriteria = searchCriteria == null ? this.addSearchToModelCriteria(stringToSearch, mcb) : mcb.and(searchCriteria, this.addSearchToModelCriteria(stringToSearch, mcb));
                    }
                    criteria = mcb.and(criteria, searchCriteria);
                    continue block24;
                }
                case "username": {
                    criteria = criteria.compare(UserModel.SearchableFields.USERNAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{searchedString});
                    continue block24;
                }
                case "firstName": {
                    criteria = criteria.compare(UserModel.SearchableFields.FIRST_NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{searchedString});
                    continue block24;
                }
                case "lastName": {
                    criteria = criteria.compare(UserModel.SearchableFields.LAST_NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{searchedString});
                    continue block24;
                }
                case "email": {
                    criteria = criteria.compare(UserModel.SearchableFields.EMAIL, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{searchedString});
                    continue block24;
                }
                case "emailVerified": {
                    boolean booleanValue = Boolean.parseBoolean(value);
                    criteria = criteria.compare(UserModel.SearchableFields.EMAIL_VERIFIED, ModelCriteriaBuilder.Operator.EQ, new Object[]{booleanValue});
                    continue block24;
                }
                case "enabled": {
                    boolean booleanValue = Boolean.parseBoolean(value);
                    criteria = criteria.compare(UserModel.SearchableFields.ENABLED, ModelCriteriaBuilder.Operator.EQ, new Object[]{booleanValue});
                    continue block24;
                }
                case "keycloak.session.realm.users.query.idp_alias": {
                    if (attributes.containsKey("keycloak.session.realm.users.query.idp_user_id")) continue block24;
                    criteria = criteria.compare(UserModel.SearchableFields.IDP_AND_USER, ModelCriteriaBuilder.Operator.EQ, new Object[]{value});
                    continue block24;
                }
                case "keycloak.session.realm.users.query.idp_user_id": {
                    criteria = criteria.compare(UserModel.SearchableFields.IDP_AND_USER, ModelCriteriaBuilder.Operator.EQ, new Object[]{attributes.get("keycloak.session.realm.users.query.idp_alias"), value});
                    continue block24;
                }
                case "keycloak.session.realm.users.query.exact": {
                    continue block24;
                }
            }
            criteria = criteria.compare(UserModel.SearchableFields.ATTRIBUTE, ModelCriteriaBuilder.Operator.EQ, new Object[]{key, value});
        }
        Set userGroups = (Set)this.session.getAttribute("keycloak.session.realm.users.query.groups");
        if (userGroups != null) {
            if (userGroups.isEmpty()) {
                return Stream.empty();
            }
            ResourceStore resourceStore = ((AuthorizationProvider)this.session.getProvider(AuthorizationProvider.class)).getStoreFactory().getResourceStore();
            HashSet<String> authorizedGroups = new HashSet<String>(userGroups);
            authorizedGroups.removeIf(id -> {
                EnumMap<Resource.FilterOption, String[]> values = new EnumMap<Resource.FilterOption, String[]>(Resource.FilterOption.class);
                values.put(Resource.FilterOption.EXACT_NAME, new String[]{"group.resource." + id});
                return resourceStore.find(realm, null, values, Integer.valueOf(0), Integer.valueOf(1)).isEmpty();
            });
            criteria = criteria.compare(UserModel.SearchableFields.ASSIGNED_GROUP, ModelCriteriaBuilder.Operator.IN, new Object[]{authorizedGroups});
        }
        return this.tx.read(QueryParameters.withCriteria(criteria).pagination(firstResult, maxResults, UserModel.SearchableFields.USERNAME)).map(this.entityToAdapterFunc(realm)).filter(Objects::nonNull);
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, Integer firstResult, Integer maxResults) {
        LOG.tracef("getGroupMembersStream(%s, %s, %d, %d)%s", new Object[]{realm, group.getId(), firstResult, maxResults, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserModel.SearchableFields.ASSIGNED_GROUP, ModelCriteriaBuilder.Operator.EQ, new Object[]{group.getId()});
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResults, UserModel.SearchableFields.USERNAME)).map(this.entityToAdapterFunc(realm));
    }

    public Stream<UserModel> searchForUserByUserAttributeStream(RealmModel realm, String attrName, String attrValue) {
        LOG.tracef("searchForUserByUserAttributeStream(%s, %s, %s)%s", new Object[]{realm, attrName, attrValue, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserModel.SearchableFields.ATTRIBUTE, ModelCriteriaBuilder.Operator.EQ, new Object[]{attrName, attrValue});
        return this.tx.read(QueryParameters.withCriteria(mcb).orderBy(UserModel.SearchableFields.USERNAME, QueryParameters.Order.ASCENDING)).map(this.entityToAdapterFunc(realm));
    }

    public UserModel addUser(RealmModel realm, String username) {
        return this.addUser(realm, null, username.toLowerCase(), true, true);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        String userId = user.getId();
        Optional<MapUserEntity> userById = this.getEntityById(realm, userId);
        if (userById.isPresent()) {
            this.session.invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.USER_BEFORE_REMOVE, new Object[]{realm, user});
            this.tx.delete(userId);
            this.session.invalidate((InvalidationHandler.InvalidableObjectType)AbstractMapProviderFactory.MapProviderObjectType.USER_AFTER_REMOVE, new Object[]{realm, user});
            return true;
        }
        return false;
    }

    public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        LOG.tracef("getRoleMembersStream(%s, %s, %d, %d)%s", new Object[]{realm, role, firstResult, maxResults, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserModel.SearchableFields.ASSIGNED_ROLE, ModelCriteriaBuilder.Operator.EQ, new Object[]{role.getId()});
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResults, UserModel.SearchableFields.USERNAME)).map(this.entityToAdapterFunc(realm));
    }

    public void close() {
    }

    public static <T> Stream<T> getCredentialProviders(KeycloakSession session, Class<T> type) {
        return session.getKeycloakSessionFactory().getProviderFactoriesStream(CredentialProvider.class).filter(f -> Types.supports((Class)type, (Object)f, CredentialProviderFactory.class)).map(f -> session.getProvider(CredentialProvider.class, f.getId()));
    }

    public CredentialValidationOutput getUserByCredential(RealmModel realm, CredentialInput input) {
        MapCredentialValidationOutput result;
        Stream<CredentialAuthentication> credentialAuthenticationStream = MapUserProvider.getCredentialProviders(this.session, CredentialAuthentication.class);
        CredentialValidationOutput r = credentialAuthenticationStream.filter(credentialAuthentication -> credentialAuthentication.supportsCredentialAuthenticationFor(input.getType())).map(credentialAuthentication -> credentialAuthentication.authenticate(realm, input)).filter(Objects::nonNull).findFirst().orElse(null);
        if (r == null && this.tx instanceof MapKeycloakTransactionWithAuth && (result = ((MapKeycloakTransactionWithAuth)this.tx).authenticate(realm, input)) != null) {
            UserModel user = null;
            if (result.getAuthenticatedUser() != null) {
                user = this.entityToAdapterFunc(realm).apply((MapUserEntity)result.getAuthenticatedUser());
            }
            r = new CredentialValidationOutput(user, result.getAuthStatus(), result.getState());
        }
        return r;
    }

    private DefaultModelCriteria<UserModel> addSearchToModelCriteria(String value, DefaultModelCriteria<UserModel> mcb) {
        if (value.length() >= 2 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            value = value.substring(1, value.length() - 1);
        } else if (value.length() >= 2 && value.charAt(0) == '*' && value.charAt(value.length() - 1) == '*') {
            value = "%" + value.substring(1, value.length() - 1) + "%";
        } else {
            if (value.length() > 0 && value.charAt(value.length() - 1) == '*') {
                value = value.substring(0, value.length() - 1);
            }
            value = value + "%";
        }
        return mcb.or(new DefaultModelCriteria[]{mcb.compare(UserModel.SearchableFields.USERNAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{value}), mcb.compare(UserModel.SearchableFields.EMAIL, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{value}), mcb.compare(UserModel.SearchableFields.FIRST_NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{value}), mcb.compare(UserModel.SearchableFields.LAST_NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{value})});
    }
}

