/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization.adapter;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.authorization.adapter.AbstractPolicyModel;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;

public class MapPolicyAdapter
extends AbstractPolicyModel<MapPolicyEntity> {
    private final RealmModel realm;
    private ResourceServer resourceServer;

    public MapPolicyAdapter(RealmModel realm, ResourceServer resourceServer, MapPolicyEntity entity, StoreFactory storeFactory) {
        super(entity, storeFactory);
        Objects.requireNonNull(realm);
        this.realm = realm;
        this.resourceServer = resourceServer;
    }

    public String getId() {
        return ((MapPolicyEntity)this.entity).getId();
    }

    public String getType() {
        return ((MapPolicyEntity)this.entity).getType();
    }

    public DecisionStrategy getDecisionStrategy() {
        DecisionStrategy ds = ((MapPolicyEntity)this.entity).getDecisionStrategy();
        return ds == null ? DecisionStrategy.UNANIMOUS : ds;
    }

    public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).setDecisionStrategy(decisionStrategy);
    }

    public Logic getLogic() {
        Logic l = ((MapPolicyEntity)this.entity).getLogic();
        return l == null ? Logic.POSITIVE : l;
    }

    public void setLogic(Logic logic) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).setLogic(logic);
    }

    public Map<String, String> getConfig() {
        Map<String, String> c = ((MapPolicyEntity)this.entity).getConfigs();
        return c == null ? Collections.emptyMap() : c;
    }

    public void setConfig(Map<String, String> config) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).setConfigs(config);
    }

    public void removeConfig(String name) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).removeConfig(name);
    }

    public void putConfig(String name, String value) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).setConfig(name, value);
    }

    public String getName() {
        return ((MapPolicyEntity)this.entity).getName();
    }

    public void setName(String name) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).setName(name);
    }

    public String getDescription() {
        return ((MapPolicyEntity)this.entity).getDescription();
    }

    public void setDescription(String description) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).setDescription(description);
    }

    public ResourceServer getResourceServer() {
        if (this.resourceServer == null) {
            this.resourceServer = this.storeFactory.getResourceServerStore().findById(this.realm, ((MapPolicyEntity)this.entity).getResourceServerId());
        }
        return this.resourceServer;
    }

    public Set<Policy> getAssociatedPolicies() {
        Set<String> ids = ((MapPolicyEntity)this.entity).getAssociatedPolicyIds();
        ResourceServer resourceServer = this.getResourceServer();
        return ids == null ? Collections.emptySet() : ids.stream().map(policyId -> this.storeFactory.getPolicyStore().findById(this.realm, resourceServer, policyId)).collect(Collectors.toSet());
    }

    public Set<Resource> getResources() {
        Set<String> ids = ((MapPolicyEntity)this.entity).getResourceIds();
        return ids == null ? Collections.emptySet() : ids.stream().map(resourceId -> this.storeFactory.getResourceStore().findById(this.realm, this.getResourceServer(), resourceId)).collect(Collectors.toSet());
    }

    public Set<Scope> getScopes() {
        Set<String> ids = ((MapPolicyEntity)this.entity).getScopeIds();
        return ids == null ? Collections.emptySet() : ids.stream().map(scopeId -> this.storeFactory.getScopeStore().findById(this.realm, this.getResourceServer(), scopeId)).collect(Collectors.toSet());
    }

    public String getOwner() {
        return ((MapPolicyEntity)this.entity).getOwner();
    }

    public void setOwner(String owner) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).setOwner(owner);
    }

    public void addScope(Scope scope) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).addScopeId(scope.getId());
    }

    public void removeScope(Scope scope) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).removeScopeId(scope.getId());
    }

    public void addAssociatedPolicy(Policy associatedPolicy) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).addAssociatedPolicyId(associatedPolicy.getId());
    }

    public void removeAssociatedPolicy(Policy associatedPolicy) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).removeAssociatedPolicyId(associatedPolicy.getId());
    }

    public void addResource(Resource resource) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).addResourceId(resource.getId());
    }

    public void removeResource(Resource resource) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).removeResourceId(resource.getId());
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode((Object)this));
    }
}

