/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.client;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaPredicateFunction;
import org.keycloak.models.map.storage.jpa.client.entity.JpaClientEntity;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.storage.SearchableModelField;

public class JpaClientModelCriteriaBuilder
extends JpaModelCriteriaBuilder<JpaClientEntity, ClientModel, JpaClientModelCriteriaBuilder> {
    public JpaClientModelCriteriaBuilder() {
        super(JpaClientModelCriteriaBuilder::new);
    }

    private JpaClientModelCriteriaBuilder(JpaPredicateFunction<JpaClientEntity> predicateFunc) {
        super(JpaClientModelCriteriaBuilder::new, predicateFunc);
    }

    public JpaClientModelCriteriaBuilder compare(SearchableModelField<? super ClientModel> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        switch (op) {
            case EQ: {
                if (modelField == ClientModel.SearchableFields.REALM_ID || modelField == ClientModel.SearchableFields.CLIENT_ID) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaClientModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                if (modelField == ClientModel.SearchableFields.ENABLED) {
                    this.validateValue(value, modelField, op, Boolean.class);
                    return new JpaClientModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                if (modelField == ClientModel.SearchableFields.SCOPE_MAPPING_ROLE) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaClientModelCriteriaBuilder((cb, query, root) -> cb.isTrue(cb.function("@>", Boolean.TYPE, new Expression[]{cb.function("->", JsonbType.class, new Expression[]{root.get("metadata"), cb.literal((Object)"fScopeMappings")}), cb.literal((Object)this.convertToJson(value[0]))})));
                }
                if (modelField == ClientModel.SearchableFields.ALWAYS_DISPLAY_IN_CONSOLE) {
                    this.validateValue(value, modelField, op, Boolean.class);
                    return new JpaClientModelCriteriaBuilder((cb, query, root) -> cb.equal(cb.function("->", JsonbType.class, new Expression[]{root.get("metadata"), cb.literal((Object)"fAlwaysDisplayInConsole")}), cb.literal((Object)this.convertToJson(value[0]))));
                }
                if (modelField == ClientModel.SearchableFields.ATTRIBUTE) {
                    this.validateValue(value, modelField, op, String.class, String.class);
                    return new JpaClientModelCriteriaBuilder((cb, query, root) -> {
                        Join join = root.join("attributes", JoinType.LEFT);
                        return cb.and((Expression)cb.equal((Expression)join.get("name"), value[0]), (Expression)cb.equal((Expression)join.get("value"), value[1]));
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case ILIKE: {
                if (modelField != ClientModel.SearchableFields.CLIENT_ID) break;
                this.validateValue(value, modelField, op, String.class);
                return new JpaClientModelCriteriaBuilder((cb, query, root) -> cb.like(cb.lower((Expression)root.get(modelField.getName())), value[0].toString().toLowerCase()));
            }
        }
        throw new CriterionNotSupportedException(modelField, op);
    }
}

