/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.authorization.policy;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import org.keycloak.authorization.model.Policy;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaPredicateFunction;
import org.keycloak.models.map.storage.jpa.authorization.policy.entity.JpaPolicyEntity;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.storage.SearchableModelField;

public class JpaPolicyModelCriteriaBuilder
extends JpaModelCriteriaBuilder<JpaPolicyEntity, Policy, JpaPolicyModelCriteriaBuilder> {
    public JpaPolicyModelCriteriaBuilder() {
        super(JpaPolicyModelCriteriaBuilder::new);
    }

    private JpaPolicyModelCriteriaBuilder(JpaPredicateFunction<JpaPolicyEntity> predicateFunc) {
        super(JpaPolicyModelCriteriaBuilder::new, predicateFunc);
    }

    public JpaPolicyModelCriteriaBuilder compare(SearchableModelField<? super Policy> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        switch (op) {
            case EQ: {
                if (modelField == Policy.SearchableFields.ID || modelField == Policy.SearchableFields.RESOURCE_SERVER_ID) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> {
                        UUID uuid = (UUID)StringKeyConverter.UUIDKey.INSTANCE.fromStringSafe(Objects.toString(value[0], null));
                        if (uuid == null) {
                            return cb.or(new Predicate[0]);
                        }
                        return cb.equal((Expression)root.get(modelField.getName()), (Object)uuid);
                    });
                }
                if (modelField == Policy.SearchableFields.REALM_ID || modelField == Policy.SearchableFields.NAME || modelField == Policy.SearchableFields.TYPE) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                if (modelField == Policy.SearchableFields.ASSOCIATED_POLICY_ID) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> {
                        UUID uuid = (UUID)StringKeyConverter.UUIDKey.INSTANCE.fromStringSafe(Objects.toString(value[0], null));
                        if (uuid == null) {
                            return cb.or(new Predicate[0]);
                        }
                        return cb.equal((Expression)root.join("policyIds", JoinType.LEFT), (Object)uuid);
                    });
                }
                if (modelField == Policy.SearchableFields.RESOURCE_ID) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> {
                        UUID uuid = (UUID)StringKeyConverter.UUIDKey.INSTANCE.fromStringSafe(Objects.toString(value[0], null));
                        if (uuid == null) {
                            return cb.or(new Predicate[0]);
                        }
                        return cb.equal((Expression)root.join("resourceIds", JoinType.LEFT), (Object)uuid);
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case NOT_EXISTS: {
                if (modelField == Policy.SearchableFields.OWNER) {
                    return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> cb.isNull(cb.function("->", JsonbType.class, new Expression[]{root.get("metadata"), cb.literal((Object)"fOwner")})));
                }
                if (modelField == Policy.SearchableFields.RESOURCE_ID) {
                    return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> cb.isNull((Expression)root.join("resourceIds", JoinType.LEFT)));
                }
                if (modelField == Policy.SearchableFields.CONFIG) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> {
                        Join join = root.join("config", JoinType.LEFT);
                        return cb.isNull((Expression)join.get("name"));
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case LIKE: {
                if (modelField == Policy.SearchableFields.CONFIG) {
                    this.validateValue(value, modelField, op, String.class, String.class);
                    return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> {
                        Join join = root.join("config", JoinType.LEFT);
                        return cb.and((Expression)cb.equal((Expression)join.get("name"), value[0]), (Expression)cb.like((Expression)join.get("value"), value[1].toString()));
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case ILIKE: {
                if (modelField == Policy.SearchableFields.NAME || modelField == Policy.SearchableFields.TYPE) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> cb.like(cb.lower((Expression)root.get(modelField.getName())), value[0].toString().toLowerCase()));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case IN: {
                if (modelField == Policy.SearchableFields.ID) {
                    Set<UUID> uuids = this.getUuidsForInOperator(value, modelField);
                    if (uuids.isEmpty()) {
                        return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in((Expression)root.get("id"));
                        uuids.forEach(arg_0 -> ((CriteriaBuilder.In)in).value(arg_0));
                        return in;
                    });
                }
                if (modelField == Policy.SearchableFields.TYPE) {
                    Collection<? super Policy> collectionValues = this.getValuesForInOperator(value, modelField);
                    if (collectionValues.isEmpty()) {
                        return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in((Expression)root.get("type"));
                        for (Object type : collectionValues) {
                            if (!(type instanceof String)) {
                                throw new CriterionNotSupportedException(modelField, op, type + " type is not String.");
                            }
                            in.value((Object)type.toString());
                        }
                        return in;
                    });
                }
                if (modelField == Policy.SearchableFields.OWNER) {
                    Collection<? super Policy> collectionValues = this.getValuesForInOperator(value, modelField);
                    if (collectionValues.isEmpty()) {
                        return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in((Expression)root.get("owner"));
                        collectionValues.forEach(owner -> {
                            if (!(owner instanceof String)) {
                                throw new CriterionNotSupportedException(modelField, op, owner + " owner is not String.");
                            }
                            in.value((Object)owner.toString());
                        });
                        return in;
                    });
                }
                if (modelField == Policy.SearchableFields.SCOPE_ID) {
                    Set<UUID> scopeUuids = this.getUuidsForInOperator(value, modelField);
                    if (scopeUuids.isEmpty()) {
                        return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in((Expression)root.join("scopeIds", JoinType.LEFT));
                        scopeUuids.forEach(arg_0 -> ((CriteriaBuilder.In)in).value(arg_0));
                        return in;
                    });
                }
                if (modelField == Policy.SearchableFields.RESOURCE_ID) {
                    Set<UUID> resourceUuids = this.getUuidsForInOperator(value, modelField);
                    if (resourceUuids.isEmpty()) {
                        return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaPolicyModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in((Expression)root.join("resourceIds", JoinType.LEFT));
                        resourceUuids.forEach(arg_0 -> ((CriteriaBuilder.In)in).value(arg_0));
                        return in;
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
        }
        throw new CriterionNotSupportedException(modelField, op);
    }
}

