/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.api.BasicCache;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenValueEntity;

public class InfinispanSingleUseObjectProvider
implements SingleUseObjectProvider {
    public static final Logger logger = Logger.getLogger(InfinispanSingleUseObjectProvider.class);
    private final Supplier<BasicCache<String, ActionTokenValueEntity>> tokenCache;
    private final KeycloakSession session;

    public InfinispanSingleUseObjectProvider(KeycloakSession session, Supplier<BasicCache<String, ActionTokenValueEntity>> actionKeyCache) {
        this.session = session;
        this.tokenCache = actionKeyCache;
    }

    public void put(String key, long lifespanSeconds, Map<String, String> notes) {
        ActionTokenValueEntity tokenValue = new ActionTokenValueEntity(notes);
        try {
            BasicCache<String, ActionTokenValueEntity> cache = this.tokenCache.get();
            long lifespanMs = InfinispanUtil.toHotrodTimeMs(cache, Time.toMillis((long)lifespanSeconds));
            cache.put((Object)key, (Object)tokenValue, lifespanMs, TimeUnit.MILLISECONDS);
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when adding code %s", (Object)key);
            }
            throw re;
        }
    }

    public Map<String, String> get(String key) {
        BasicCache<String, ActionTokenValueEntity> cache = this.tokenCache.get();
        ActionTokenValueEntity actionTokenValueEntity = (ActionTokenValueEntity)cache.get((Object)key);
        return actionTokenValueEntity != null ? actionTokenValueEntity.getNotes() : null;
    }

    public Map<String, String> remove(String key) {
        try {
            BasicCache<String, ActionTokenValueEntity> cache = this.tokenCache.get();
            ActionTokenValueEntity existing = (ActionTokenValueEntity)cache.remove((Object)key);
            return existing == null ? null : existing.getNotes();
        }
        catch (HotRodClientException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "Failed when removing code %s", (Object)key);
            }
            return null;
        }
    }

    public boolean replace(String key, Map<String, String> notes) {
        BasicCache<String, ActionTokenValueEntity> cache = this.tokenCache.get();
        return cache.replace((Object)key, (Object)new ActionTokenValueEntity(notes)) != null;
    }

    public boolean putIfAbsent(String key, long lifespanInSeconds) {
        ActionTokenValueEntity tokenValue = new ActionTokenValueEntity(null);
        try {
            BasicCache<String, ActionTokenValueEntity> cache = this.tokenCache.get();
            long lifespanMs = InfinispanUtil.toHotrodTimeMs(cache, Time.toMillis((long)lifespanInSeconds));
            ActionTokenValueEntity existing = (ActionTokenValueEntity)cache.putIfAbsent((Object)key, (Object)tokenValue, lifespanMs, TimeUnit.MILLISECONDS);
            return existing == null;
        }
        catch (HotRodClientException re) {
            logger.debugf((Throwable)re, "Failed when adding token %s", (Object)key);
            return false;
        }
    }

    public boolean contains(String key) {
        BasicCache<String, ActionTokenValueEntity> cache = this.tokenCache.get();
        return cache.containsKey((Object)key);
    }

    public void close() {
    }
}

