/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization;

import org.keycloak.authorization.model.CachedModel;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.models.cache.infinispan.authorization.InfinispanCacheStoreFactoryProviderFactory;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheSession;
import org.keycloak.models.cache.infinispan.authorization.entities.CachedPermissionTicket;

public class PermissionTicketAdapter
implements PermissionTicket,
CachedModel<PermissionTicket> {
    protected CachedPermissionTicket cached;
    protected StoreFactoryCacheSession cacheSession;
    protected PermissionTicket updated;
    protected boolean invalidated;

    public PermissionTicketAdapter(CachedPermissionTicket cached, StoreFactoryCacheSession cacheSession) {
        this.cached = cached;
        this.cacheSession = cacheSession;
    }

    public PermissionTicket getDelegateForUpdate() {
        if (this.updated == null) {
            ResourceServer resourceServer = this.cacheSession.getResourceServerStoreDelegate().findById(InfinispanCacheStoreFactoryProviderFactory.NULL_REALM, this.cached.getResourceServerId());
            this.updated = this.cacheSession.getPermissionTicketStoreDelegate().findById(InfinispanCacheStoreFactoryProviderFactory.NULL_REALM, resourceServer, this.cached.getId());
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
            this.cacheSession.registerPermissionTicketInvalidation(this.cached.getId(), this.cached.getOwner(), this.cached.getRequester(), this.cached.getResourceId(), this.updated.getResource().getName(), this.cached.getScopeId(), this.cached.getResourceServerId());
        }
        return this.updated;
    }

    protected void invalidateFlag() {
        this.invalidated = true;
    }

    public void invalidate() {
        this.invalidated = true;
        this.getDelegateForUpdate();
    }

    public long getCacheTimestamp() {
        return this.cached.getCacheTimestamp();
    }

    protected boolean isUpdated() {
        if (this.updated != null) {
            return true;
        }
        if (!this.invalidated) {
            return false;
        }
        ResourceServer resourceServer = this.cacheSession.getResourceServerStoreDelegate().findById(InfinispanCacheStoreFactoryProviderFactory.NULL_REALM, this.cached.getResourceServerId());
        this.updated = this.cacheSession.getPermissionTicketStoreDelegate().findById(InfinispanCacheStoreFactoryProviderFactory.NULL_REALM, resourceServer, this.cached.getId());
        if (this.updated == null) {
            throw new IllegalStateException("Not found in database");
        }
        return true;
    }

    public String getId() {
        if (this.isUpdated()) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public String getOwner() {
        if (this.isUpdated()) {
            return this.updated.getOwner();
        }
        return this.cached.getOwner();
    }

    public String getRequester() {
        if (this.isUpdated()) {
            return this.updated.getRequester();
        }
        return this.cached.getRequester();
    }

    public boolean isGranted() {
        if (this.isUpdated()) {
            return this.updated.isGranted();
        }
        return this.cached.isGranted();
    }

    public Long getCreatedTimestamp() {
        if (this.isUpdated()) {
            return this.updated.getCreatedTimestamp();
        }
        return this.cached.getCreatedTimestamp();
    }

    public Long getGrantedTimestamp() {
        if (this.isUpdated()) {
            return this.updated.getGrantedTimestamp();
        }
        return this.cached.getGrantedTimestamp();
    }

    public void setGrantedTimestamp(Long millis) {
        this.getDelegateForUpdate();
        this.cacheSession.registerPermissionTicketInvalidation(this.cached.getId(), this.cached.getOwner(), this.cached.getRequester(), this.cached.getResourceId(), this.updated.getResource().getName(), this.cached.getScopeId(), this.cached.getResourceServerId());
        this.updated.setGrantedTimestamp(millis);
    }

    public ResourceServer getResourceServer() {
        return this.cacheSession.getResourceServerStore().findById(InfinispanCacheStoreFactoryProviderFactory.NULL_REALM, this.cached.getResourceServerId());
    }

    public Policy getPolicy() {
        if (this.isUpdated()) {
            return this.updated.getPolicy();
        }
        return this.cacheSession.getPolicyStore().findById(InfinispanCacheStoreFactoryProviderFactory.NULL_REALM, this.cacheSession.getResourceServerStore().findById(InfinispanCacheStoreFactoryProviderFactory.NULL_REALM, this.cached.getResourceServerId()), this.cached.getPolicy());
    }

    public void setPolicy(Policy policy) {
        this.getDelegateForUpdate();
        this.cacheSession.registerPermissionTicketInvalidation(this.cached.getId(), this.cached.getOwner(), this.cached.getRequester(), this.cached.getResourceId(), this.updated.getResource().getName(), this.cached.getScopeId(), this.cached.getResourceServerId());
        this.updated.setPolicy(policy);
    }

    public Resource getResource() {
        return this.cacheSession.getResourceStore().findById(InfinispanCacheStoreFactoryProviderFactory.NULL_REALM, this.getResourceServer(), this.cached.getResourceId());
    }

    public Scope getScope() {
        return this.cacheSession.getScopeStore().findById(InfinispanCacheStoreFactoryProviderFactory.NULL_REALM, this.getResourceServer(), this.cached.getScopeId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

