/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.keycloak.common.Profile;
import org.keycloak.config.FeatureOptions;
import org.keycloak.config.StorageOptions;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;

final class FeaturePropertyMappers {
    private FeaturePropertyMappers() {
    }

    public static PropertyMapper[] getMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(FeatureOptions.FEATURES).paramLabel("feature").transformer(FeaturePropertyMappers::transformFeatures).build(), PropertyMapper.fromOption(FeatureOptions.FEATURES_DISABLED).paramLabel("feature").build()};
    }

    private static Optional<String> transformFeatures(Optional<String> features, ConfigSourceInterceptorContext context) {
        if (Configuration.getOptionalValue("kc.".concat(StorageOptions.STORAGE.getKey())).isEmpty()) {
            return features;
        }
        HashSet<String> featureSet = new HashSet<String>(List.of(features.orElse("").split(",")));
        featureSet.add(Profile.Feature.MAP_STORAGE.name().replace('_', '-'));
        return Optional.of(String.join((CharSequence)",", featureSet));
    }
}

