/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import com.fasterxml.jackson.core.type.TypeReference;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.Config;
import org.keycloak.KeyPairVerifier;
import org.keycloak.authentication.CredentialRegistrator;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.PemUtils;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.EventQuery;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.AdminEventQuery;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.exportimport.ClientDescriptionConverter;
import org.keycloak.exportimport.ClientDescriptionConverterFactory;
import org.keycloak.exportimport.util.ExportOptions;
import org.keycloak.exportimport.util.ExportUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.models.utils.StripSecretsUtils;
import org.keycloak.partialimport.PartialImportManager;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AttackDetectionResource;
import org.keycloak.services.resources.admin.AuthenticationManagementResource;
import org.keycloak.services.resources.admin.ClientInitialAccessResource;
import org.keycloak.services.resources.admin.ClientPoliciesResource;
import org.keycloak.services.resources.admin.ClientProfilesResource;
import org.keycloak.services.resources.admin.ClientRegistrationPolicyResource;
import org.keycloak.services.resources.admin.ClientScopesResource;
import org.keycloak.services.resources.admin.ClientsResource;
import org.keycloak.services.resources.admin.ComponentResource;
import org.keycloak.services.resources.admin.GroupsResource;
import org.keycloak.services.resources.admin.IdentityProvidersResource;
import org.keycloak.services.resources.admin.KeyResource;
import org.keycloak.services.resources.admin.RealmLocalizationResource;
import org.keycloak.services.resources.admin.RoleByIdResource;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.UsersResource;
import org.keycloak.services.resources.admin.ext.AdminRealmResourceProvider;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.storage.LegacyStoreSyncEvent;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.LockObjectsForModification;
import org.keycloak.utils.ProfileHelper;
import org.keycloak.utils.ReservedCharValidator;

public class RealmAdminResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected AdminPermissionEvaluator auth;
    protected RealmModel realm;
    private TokenManager tokenManager;
    private AdminEventBuilder adminEvent;
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection connection;
    @Context
    protected HttpHeaders headers;

    public RealmAdminResource(AdminPermissionEvaluator auth, RealmModel realm, TokenManager tokenManager, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.tokenManager = tokenManager;
        this.adminEvent = adminEvent.realm(realm).resource(ResourceType.REALM);
    }

    @Path(value="client-description-converter")
    @Consumes(value={"application/json", "application/xml", "text/plain"})
    @POST
    @Produces(value={"application/json"})
    public ClientRepresentation convertClientDescription(String description) {
        this.auth.clients().requireManage();
        if (this.realm == null) {
            throw new NotFoundException("Realm not found.");
        }
        return this.session.getKeycloakSessionFactory().getProviderFactoriesStream(ClientDescriptionConverter.class).map(ClientDescriptionConverterFactory.class::cast).filter(factory -> factory.isSupported(description)).map(factory -> ((ClientDescriptionConverter)factory.create(this.session)).convertToInternal(description)).findFirst().orElseThrow(() -> new BadRequestException("Unsupported format"));
    }

    @Path(value="attack-detection")
    public AttackDetectionResource getAttackDetection() {
        AttackDetectionResource resource = new AttackDetectionResource(this.auth, this.realm, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="clients")
    public ClientsResource getClients() {
        ClientsResource clientsResource = new ClientsResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)clientsResource);
        return clientsResource;
    }

    @Deprecated
    @Path(value="client-templates")
    public ClientScopesResource getClientTemplates() {
        return this.getClientScopes();
    }

    @Path(value="client-scopes")
    public ClientScopesResource getClientScopes() {
        ClientScopesResource clientScopesResource = new ClientScopesResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)clientScopesResource);
        return clientScopesResource;
    }

    @Path(value="localization")
    public RealmLocalizationResource getLocalization() {
        RealmLocalizationResource resource = new RealmLocalizationResource(this.realm, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Path(value="default-default-client-scopes")
    public Stream<ClientScopeRepresentation> getDefaultDefaultClientScopes() {
        return this.getDefaultClientScopes(true);
    }

    private Stream<ClientScopeRepresentation> getDefaultClientScopes(boolean defaultScope) {
        this.auth.clients().requireViewClientScopes();
        return this.realm.getDefaultClientScopesStream(defaultScope).map(clientScope -> {
            ClientScopeRepresentation rep = new ClientScopeRepresentation();
            rep.setId(clientScope.getId());
            rep.setName(clientScope.getName());
            rep.setProtocol(clientScope.getProtocol());
            return rep;
        });
    }

    @PUT
    @NoCache
    @Path(value="default-default-client-scopes/{clientScopeId}")
    public void addDefaultDefaultClientScope(@PathParam(value="clientScopeId") String clientScopeId) {
        this.addDefaultClientScope(clientScopeId, true);
    }

    private void addDefaultClientScope(String clientScopeId, boolean defaultScope) {
        this.auth.clients().requireManageClientScopes();
        ClientScopeModel clientScope = this.realm.getClientScopeById(clientScopeId);
        if (clientScope == null) {
            throw new NotFoundException("Client scope not found");
        }
        this.realm.addDefaultClientScope(clientScope, defaultScope);
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.CLIENT_SCOPE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @DELETE
    @NoCache
    @Path(value="default-default-client-scopes/{clientScopeId}")
    public void removeDefaultDefaultClientScope(@PathParam(value="clientScopeId") String clientScopeId) {
        this.auth.clients().requireManageClientScopes();
        ClientScopeModel clientScope = this.realm.getClientScopeById(clientScopeId);
        if (clientScope == null) {
            throw new NotFoundException("Client scope not found");
        }
        this.realm.removeDefaultClientScope(clientScope);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.CLIENT_SCOPE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Path(value="default-optional-client-scopes")
    public Stream<ClientScopeRepresentation> getDefaultOptionalClientScopes() {
        return this.getDefaultClientScopes(false);
    }

    @PUT
    @NoCache
    @Path(value="default-optional-client-scopes/{clientScopeId}")
    public void addDefaultOptionalClientScope(@PathParam(value="clientScopeId") String clientScopeId) {
        this.addDefaultClientScope(clientScopeId, false);
    }

    @DELETE
    @NoCache
    @Path(value="default-optional-client-scopes/{clientScopeId}")
    public void removeDefaultOptionalClientScope(@PathParam(value="clientScopeId") String clientScopeId) {
        this.removeDefaultDefaultClientScope(clientScopeId);
    }

    @Path(value="clients-initial-access")
    public ClientInitialAccessResource getClientInitialAccess() {
        ClientInitialAccessResource resource = new ClientInitialAccessResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="client-registration-policy")
    public ClientRegistrationPolicyResource getClientRegistrationPolicy() {
        ClientRegistrationPolicyResource resource = new ClientRegistrationPolicyResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="components")
    public ComponentResource getComponents() {
        ComponentResource resource = new ComponentResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="roles")
    public RoleContainerResource getRoleContainerResource() {
        return new RoleContainerResource(this.session, (UriInfo)this.session.getContext().getUri(), this.realm, this.auth, (RoleContainerModel)this.realm, this.adminEvent);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public RealmRepresentation getRealm() {
        if (this.auth.realm().canViewRealm()) {
            return ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (boolean)false);
        }
        this.auth.realm().requireViewRealmNameList();
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm(this.realm.getName());
        if (this.auth.realm().canViewIdentityProviders()) {
            RealmRepresentation r = ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (boolean)false);
            rep.setIdentityProviders(r.getIdentityProviders());
            rep.setIdentityProviderMappers(r.getIdentityProviderMappers());
        }
        return rep;
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response updateRealm(RealmRepresentation rep) {
        this.auth.realm().requireManageRealm();
        logger.debug((Object)("updating realm: " + this.realm.getName()));
        if (Config.getAdminRealm().equals(this.realm.getName()) && rep.getRealm() != null && !rep.getRealm().equals(Config.getAdminRealm())) {
            return ErrorResponse.error("Can't rename master realm", Response.Status.BAD_REQUEST);
        }
        ReservedCharValidator.validate(rep.getRealm());
        ReservedCharValidator.validateLocales(rep.getSupportedLocales());
        try {
            if (!"GENERATE".equals(rep.getPublicKey()) && rep.getPrivateKey() != null && rep.getPublicKey() != null) {
                try {
                    KeyPairVerifier.verify((String)rep.getPrivateKey(), (String)rep.getPublicKey());
                }
                catch (VerificationException e) {
                    return ErrorResponse.error(e.getMessage(), Response.Status.BAD_REQUEST);
                }
            }
            if (!"GENERATE".equals(rep.getPublicKey()) && rep.getCertificate() != null) {
                try {
                    X509Certificate cert = PemUtils.decodeCertificate((String)rep.getCertificate());
                    if (cert == null) {
                        return ErrorResponse.error("Failed to decode certificate", Response.Status.BAD_REQUEST);
                    }
                }
                catch (Exception e) {
                    return ErrorResponse.error("Failed to decode certificate", Response.Status.BAD_REQUEST);
                }
            }
            boolean wasDuplicateEmailsAllowed = this.realm.isDuplicateEmailsAllowed();
            RepresentationToModel.updateRealm((RealmRepresentation)rep, (RealmModel)this.realm, (KeycloakSession)this.session);
            LegacyStoreSyncEvent.fire((KeycloakSession)this.session, (RealmModel)this.realm, (boolean)false);
            this.session.getContext().getUri();
            this.adminEvent.operation(OperationType.UPDATE).representation(StripSecretsUtils.strip((RealmRepresentation)rep)).success();
            if (rep.isDuplicateEmailsAllowed() != null && rep.isDuplicateEmailsAllowed() != wasDuplicateEmailsAllowed) {
                this.session.invalidate((InvalidationHandler.InvalidableObjectType)InvalidationHandler.ObjectType.REALM, new Object[]{this.realm.getId()});
            }
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Realm with same name exists");
        }
        catch (ModelException e) {
            return ErrorResponse.error(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return ErrorResponse.error("Failed to update realm", Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    public void deleteRealm() {
        this.auth.realm().requireManageRealm();
        if (!new RealmManager(this.session).removeRealm(this.realm)) {
            throw new NotFoundException("Realm doesn't exist");
        }
    }

    @Path(value="users")
    public UsersResource users() {
        UsersResource users = new UsersResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)users);
        return users;
    }

    @NoCache
    @GET
    @Produces(value={"application/json"})
    @Path(value="users-management-permissions")
    public ManagementPermissionReference getUserMgmtPermissions() {
        this.auth.realm().requireViewRealm();
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        if (permissions.users().isPermissionsEnabled()) {
            return RealmAdminResource.toUsersMgmtRef(permissions);
        }
        return new ManagementPermissionReference();
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @NoCache
    @Path(value="users-management-permissions")
    public ManagementPermissionReference setUsersManagementPermissionsEnabled(ManagementPermissionReference ref) {
        this.auth.realm().requireManageRealm();
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        permissions.users().setPermissionsEnabled(ref.isEnabled());
        if (ref.isEnabled()) {
            return RealmAdminResource.toUsersMgmtRef(permissions);
        }
        return new ManagementPermissionReference();
    }

    public static ManagementPermissionReference toUsersMgmtRef(AdminPermissionManagement permissions) {
        ManagementPermissionReference ref = new ManagementPermissionReference();
        ref.setEnabled(true);
        ref.setResource(permissions.users().resource().getId());
        Map<String, String> scopes = permissions.users().getPermissions();
        ref.setScopePermissions(scopes);
        return ref;
    }

    @Path(value="{extension}")
    public Object extension(@PathParam(value="extension") String extension) {
        Object resource;
        AdminRealmResourceProvider provider = (AdminRealmResourceProvider)this.session.getProvider(AdminRealmResourceProvider.class, extension);
        if (provider != null && (resource = provider.getResource(this.session, this.realm, this.auth, this.adminEvent)) != null) {
            ResteasyProviderFactory.getInstance().injectProperties(resource);
            return resource;
        }
        throw new NotFoundException();
    }

    @Path(value="authentication")
    public AuthenticationManagementResource flows() {
        AuthenticationManagementResource resource = new AuthenticationManagementResource(this.realm, this.session, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="roles-by-id")
    public RoleByIdResource rolesById() {
        RoleByIdResource resource = new RoleByIdResource(this.realm, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="push-revocation")
    @POST
    public GlobalRequestResult pushRevocation() {
        this.auth.realm().requireManageRealm();
        GlobalRequestResult result = new ResourceAdminManager(this.session).pushRealmRevocationPolicy(this.realm);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(result).success();
        return result;
    }

    @Path(value="logout-all")
    @POST
    @Produces(value={"application/json"})
    public GlobalRequestResult logoutAll() {
        this.auth.users().requireManage();
        this.session.sessions().removeUserSessions(this.realm);
        GlobalRequestResult result = new ResourceAdminManager(this.session).logoutAll(this.realm);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(result).success();
        return result;
    }

    @Path(value="sessions/{session}")
    @DELETE
    public void deleteSession(@PathParam(value="session") String sessionId) {
        this.auth.users().requireManage();
        UserSessionModel userSession = (UserSessionModel)LockObjectsForModification.lockUserSessionsForModification((KeycloakSession)this.session, () -> this.session.sessions().getUserSession(this.realm, sessionId));
        if (userSession == null) {
            throw new NotFoundException("Sesssion not found");
        }
        AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, (UriInfo)this.session.getContext().getUri(), this.connection, this.headers, true);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.USER_SESSION).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="client-session-stats")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<Map<String, String>> getClientSessionStats() {
        ClientModel client;
        Map<String, String> map;
        this.auth.realm().requireViewRealm();
        HashMap<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();
        Map activeCount = this.session.sessions().getActiveClientSessionStats(this.realm, false);
        for (Map.Entry entry : activeCount.entrySet()) {
            map = new HashMap<String, String>();
            client = this.realm.getClientById((String)entry.getKey());
            if (client == null) continue;
            map.put("id", client.getId());
            map.put("clientId", client.getClientId());
            map.put("active", ((Long)entry.getValue()).toString());
            map.put("offline", "0");
            data.put(client.getId(), map);
        }
        Map offlineCount = this.session.sessions().getActiveClientSessionStats(this.realm, true);
        for (Map.Entry entry : offlineCount.entrySet()) {
            map = (Map)data.get(entry.getKey());
            if (map == null) {
                map = new HashMap();
                client = this.realm.getClientById((String)entry.getKey());
                if (client == null) continue;
                map.put("id", client.getId());
                map.put("clientId", client.getClientId());
                map.put("active", "0");
                data.put(client.getId(), map);
            }
            map.put("offline", ((Long)entry.getValue()).toString());
        }
        return data.values().stream();
    }

    @GET
    @NoCache
    @Path(value="events/config")
    @Produces(value={"application/json"})
    public RealmEventsConfigRepresentation getRealmEventsConfig() {
        this.auth.realm().requireViewEvents();
        RealmEventsConfigRepresentation config = ModelToRepresentation.toEventsConfigReprensetation((RealmModel)this.realm);
        if (config.getEnabledEventTypes() == null || config.getEnabledEventTypes().isEmpty()) {
            List eventTypes = Arrays.stream(EventType.values()).filter(EventType::isSaveByDefault).map(Enum::name).collect(Collectors.toList());
            config.setEnabledEventTypes(eventTypes);
        }
        return config;
    }

    @PUT
    @Path(value="events/config")
    @Consumes(value={"application/json"})
    public void updateRealmEventsConfig(RealmEventsConfigRepresentation rep) {
        this.auth.realm().requireManageEvents();
        logger.debug((Object)("updating realm events config: " + this.realm.getName()));
        new RealmManager(this.session).updateRealmEventsConfig(rep, this.realm);
        this.adminEvent.operation(OperationType.UPDATE).resource(ResourceType.REALM).realm(this.realm).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).refreshRealmEventsConfig(this.session).success();
    }

    @Path(value="events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<EventRepresentation> getEvents(@QueryParam(value="type") List<String> types, @QueryParam(value="client") String client, @QueryParam(value="user") String user, @QueryParam(value="dateFrom") String dateFrom, @QueryParam(value="dateTo") String dateTo, @QueryParam(value="ipAddress") String ipAddress, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        SimpleDateFormat df;
        this.auth.realm().requireViewEvents();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        EventQuery query = eventStore.createQuery().realm(this.realm.getId());
        if (client != null) {
            query.client(client);
        }
        if (types != null && !types.isEmpty()) {
            EventType[] t = new EventType[types.size()];
            for (int i = 0; i < t.length; ++i) {
                t[i] = EventType.valueOf((String)types.get(i));
            }
            query.type(t);
        }
        if (user != null) {
            query.user(user);
        }
        if (dateFrom != null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            Date from = null;
            try {
                from = df.parse(dateFrom);
            }
            catch (ParseException e) {
                throw new BadRequestException("Invalid value for 'Date(From)', expected format is yyyy-MM-dd");
            }
            query.fromDate(from);
        }
        if (dateTo != null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            Date to = null;
            try {
                to = df.parse(dateTo);
            }
            catch (ParseException e) {
                throw new BadRequestException("Invalid value for 'Date(To)', expected format is yyyy-MM-dd");
            }
            query.toDate(to);
        }
        if (ipAddress != null) {
            query.ipAddress(ipAddress);
        }
        if (firstResult != null) {
            query.firstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.maxResults(maxResults.intValue());
        } else {
            query.maxResults(100);
        }
        return query.getResultStream().map(ModelToRepresentation::toRepresentation);
    }

    @Path(value="admin-events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<AdminEventRepresentation> getEvents(@QueryParam(value="operationTypes") List<String> operationTypes, @QueryParam(value="authRealm") String authRealm, @QueryParam(value="authClient") String authClient, @QueryParam(value="authUser") String authUser, @QueryParam(value="authIpAddress") String authIpAddress, @QueryParam(value="resourcePath") String resourcePath, @QueryParam(value="dateFrom") String dateFrom, @QueryParam(value="dateTo") String dateTo, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults, @QueryParam(value="resourceTypes") List<String> resourceTypes) {
        SimpleDateFormat df;
        int i;
        OperationType[] t;
        this.auth.realm().requireViewEvents();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        AdminEventQuery query = eventStore.createAdminQuery().realm(this.realm.getId());
        if (authRealm != null) {
            query.authRealm(authRealm);
        }
        if (authClient != null) {
            query.authClient(authClient);
        }
        if (authUser != null) {
            query.authUser(authUser);
        }
        if (authIpAddress != null) {
            query.authIpAddress(authIpAddress);
        }
        if (resourcePath != null) {
            query.resourcePath(resourcePath);
        }
        if (operationTypes != null && !operationTypes.isEmpty()) {
            t = new OperationType[operationTypes.size()];
            for (i = 0; i < t.length; ++i) {
                t[i] = OperationType.valueOf((String)operationTypes.get(i));
            }
            query.operation(t);
        }
        if (resourceTypes != null && !resourceTypes.isEmpty()) {
            t = new ResourceType[resourceTypes.size()];
            for (i = 0; i < t.length; ++i) {
                t[i] = ResourceType.valueOf((String)resourceTypes.get(i));
            }
            query.resourceType((ResourceType[])t);
        }
        if (dateFrom != null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            Date from = null;
            try {
                from = df.parse(dateFrom);
            }
            catch (ParseException e) {
                throw new BadRequestException("Invalid value for 'Date(From)', expected format is yyyy-MM-dd");
            }
            query.fromTime(from);
        }
        if (dateTo != null) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            Date to = null;
            try {
                to = df.parse(dateTo);
            }
            catch (ParseException e) {
                throw new BadRequestException("Invalid value for 'Date(To)', expected format is yyyy-MM-dd");
            }
            query.toTime(to);
        }
        if (firstResult != null) {
            query.firstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.maxResults(maxResults.intValue());
        } else {
            query.maxResults(100);
        }
        return query.getResultStream().map(ModelToRepresentation::toRepresentation);
    }

    @Path(value="events")
    @DELETE
    public void clearEvents() {
        this.auth.realm().requireManageEvents();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.clear(this.realm);
    }

    @Path(value="admin-events")
    @DELETE
    public void clearAdminEvents() {
        this.auth.realm().requireManageEvents();
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.clearAdmin(this.realm);
    }

    @Path(value="testSMTPConnection")
    @POST
    @NoCache
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Deprecated
    public Response testSMTPConnection(@FormParam(value="config") String config) throws Exception {
        Map settings = (Map)JsonSerialization.readValue((String)config, (TypeReference)new TypeReference<Map<String, String>>(){});
        return this.testSMTPConnection(settings);
    }

    @Path(value="testSMTPConnection")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response testSMTPConnection(Map<String, String> settings) throws Exception {
        try {
            UserModel user = this.auth.adminAuth().getUser();
            if (user.getEmail() == null) {
                return ErrorResponse.error("Logged in user does not have an e-mail.", Response.Status.INTERNAL_SERVER_ERROR);
            }
            if ("**********".equals(settings.get("password"))) {
                settings.put("password", (String)this.realm.getSmtpConfig().get("password"));
            }
            ((EmailTemplateProvider)this.session.getProvider(EmailTemplateProvider.class)).sendSmtpTestEmail(settings, user);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.errorf("Failed to send email \n %s", (Object)e.getCause());
            return ErrorResponse.error("Failed to send email", Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.noContent().build();
    }

    @Path(value="identity-provider")
    public IdentityProvidersResource getIdentityProviderResource() {
        return new IdentityProvidersResource(this.realm, this.session, this.auth, this.adminEvent);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Path(value="default-groups")
    public Stream<GroupRepresentation> getDefaultGroups() {
        this.auth.realm().requireViewRealm();
        return this.realm.getDefaultGroupsStream().map(ModelToRepresentation::groupToBriefRepresentation);
    }

    @PUT
    @NoCache
    @Path(value="default-groups/{groupId}")
    public void addDefaultGroup(@PathParam(value="groupId") String groupId) {
        this.auth.realm().requireManageRealm();
        GroupModel group = this.realm.getGroupById(groupId);
        if (group == null) {
            throw new NotFoundException("Group not found");
        }
        this.realm.addDefaultGroup(group);
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.GROUP).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @DELETE
    @NoCache
    @Path(value="default-groups/{groupId}")
    public void removeDefaultGroup(@PathParam(value="groupId") String groupId) {
        this.auth.realm().requireManageRealm();
        GroupModel group = this.realm.getGroupById(groupId);
        if (group == null) {
            throw new NotFoundException("Group not found");
        }
        this.realm.removeDefaultGroup(group);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.GROUP).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="groups")
    public GroupsResource getGroups() {
        GroupsResource resource = new GroupsResource(this.realm, this.session, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @GET
    @Path(value="group-by-path/{path: .*}")
    @NoCache
    @Produces(value={"application/json"})
    public GroupRepresentation getGroupByPath(@PathParam(value="path") String path) {
        GroupModel found = KeycloakModelUtils.findGroupByPath((RealmModel)this.realm, (String)path);
        if (found == null) {
            throw new NotFoundException("Group path does not exist");
        }
        this.auth.groups().requireView(found);
        return ModelToRepresentation.toGroupHierarchy((GroupModel)found, (boolean)true);
    }

    @Path(value="partialImport")
    @POST
    @Consumes(value={"application/json"})
    public Response partialImport(PartialImportRepresentation rep) {
        this.auth.realm().requireManageRealm();
        PartialImportManager partialImport = new PartialImportManager(rep, this.session, this.realm, this.adminEvent);
        return partialImport.saveResources();
    }

    @Path(value="partial-export")
    @POST
    @Produces(value={"application/json"})
    public RealmRepresentation partialExport(@QueryParam(value="exportGroupsAndRoles") Boolean exportGroupsAndRoles, @QueryParam(value="exportClients") Boolean exportClients) {
        boolean clientsExported;
        this.auth.realm().requireViewRealm();
        boolean groupsAndRolesExported = exportGroupsAndRoles != null && exportGroupsAndRoles != false;
        boolean bl = clientsExported = exportClients != null && exportClients != false;
        if (groupsAndRolesExported) {
            this.auth.groups().requireList();
        }
        if (clientsExported) {
            this.auth.clients().requireView();
        }
        ExportOptions options = new ExportOptions(false, clientsExported, groupsAndRolesExported, clientsExported);
        RealmRepresentation rep = ExportUtils.exportRealm(this.session, this.realm, options, false);
        return StripSecretsUtils.stripForExport((KeycloakSession)this.session, (RealmRepresentation)rep);
    }

    @Path(value="keys")
    public KeyResource keys() {
        KeyResource resource = new KeyResource(this.realm, this.session, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @GET
    @Path(value="credential-registrators")
    @NoCache
    @Produces(value={"application/json"})
    public Stream<String> getCredentialRegistrators() {
        this.auth.realm().requireViewRealm();
        return this.session.getContext().getRealm().getRequiredActionProvidersStream().filter(RequiredActionProviderModel::isEnabled).map(RequiredActionProviderModel::getProviderId).filter(providerId -> this.session.getProvider(RequiredActionProvider.class, providerId) instanceof CredentialRegistrator);
    }

    @Path(value="client-policies/policies")
    public ClientPoliciesResource getClientPoliciesResource() {
        ProfileHelper.requireFeature(Profile.Feature.CLIENT_POLICIES);
        ClientPoliciesResource resource = new ClientPoliciesResource(this.realm, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="client-policies/profiles")
    public ClientProfilesResource getClientProfilesResource() {
        ProfileHelper.requireFeature(Profile.Feature.CLIENT_POLICIES);
        ClientProfilesResource resource = new ClientProfilesResource(this.realm, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }
}

