/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.secrets.totp;

import java.util.Objects;

public class KeyConfiguration {
    private String accountName;
    private String algorithm;
    private int digits;
    private String issuer;
    private int period;

    public KeyConfiguration(String accountName, String algorithm, int digits, String issuer, int period) {
        this.accountName = accountName;
        this.algorithm = algorithm;
        this.digits = digits;
        this.issuer = issuer;
        this.period = period;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public int getDigits() {
        return this.digits;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public int getPeriod() {
        return this.period;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyConfiguration that = (KeyConfiguration)o;
        return this.digits == that.digits && this.period == that.period && this.accountName.equals(that.accountName) && Objects.equals(this.algorithm, that.algorithm) && this.issuer.equals(that.issuer);
    }

    public int hashCode() {
        return Objects.hash(this.accountName, this.issuer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("KeyConfiguration{");
        sb.append("accountName='").append(this.accountName).append('\'');
        sb.append(", algorithm='").append(this.algorithm).append('\'');
        sb.append(", digits=").append(this.digits);
        sb.append(", issuer='").append(this.issuer).append('\'');
        sb.append(", period=").append(this.period);
        sb.append('}');
        return sb.toString();
    }
}

